/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.RExclusionPolicyType;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReference;
import com.evolveum.midpoint.repo.sql.data.common.ROwnable;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExclusionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Type;

@Entity
@ForeignKey(name="fk_exclusion")
public class RExclusion
extends RContainer
implements ROwnable {
    private RObject owner;
    private String ownerOid;
    private Long ownerId;
    private String description;
    private RObjectReference targetRef;
    private RExclusionPolicyType policy;

    @ForeignKey(name="fk_exclusion_owner")
    @MapsId(value="owner")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="owner_oid", referencedColumnName="oid"), @JoinColumn(name="owner_id", referencedColumnName="id")})
    public RObject getOwner() {
        return this.owner;
    }

    @Column(name="owner_id", nullable=false)
    public Long getOwnerId() {
        if (this.ownerId == null && this.owner != null) {
            this.ownerId = this.owner.getId();
        }
        return this.ownerId;
    }

    @Column(name="owner_oid", length=36, nullable=false)
    public String getOwnerOid() {
        if (this.ownerOid == null && this.owner != null) {
            this.ownerOid = this.owner.getOid();
        }
        return this.ownerOid;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getDescription() {
        return this.description;
    }

    @Enumerated(value=EnumType.ORDINAL)
    public RExclusionPolicyType getPolicy() {
        return this.policy;
    }

    @OneToOne(optional=true, mappedBy="owner", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    public RObjectReference getTargetRef() {
        return this.targetRef;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPolicy(RExclusionPolicyType policy) {
        this.policy = policy;
    }

    public void setTargetRef(RObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    public void setOwner(RObject owner) {
        this.owner = owner;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public void setOwnerOid(String ownerOid) {
        this.ownerOid = ownerOid;
    }

    @Override
    @Transient
    public RContainer getContainerOwner() {
        return this.getOwner();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RExclusion that = (RExclusion)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.policy != that.policy) {
            return false;
        }
        return !(this.targetRef != null ? !this.targetRef.equals(that.targetRef) : that.targetRef != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RExclusion repo, ExclusionType jaxb, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        jaxb.setDescription(repo.getDescription());
        jaxb.setId(RUtil.getStringFromLong(repo.getId()));
        if (repo.getPolicy() != null) {
            jaxb.setPolicy(repo.getPolicy().getPolicy());
        }
        if (repo.getTargetRef() != null) {
            jaxb.setTargetRef(repo.getTargetRef().toJAXB(prismContext));
        }
    }

    public static void copyFromJAXB(ExclusionType jaxb, RExclusion repo, ObjectType parent, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        repo.setOid(parent.getOid());
        repo.setId(RUtil.getLongWrappedFromString(jaxb.getId()));
        repo.setDescription(jaxb.getDescription());
        repo.setPolicy(RExclusionPolicyType.toRepoType(jaxb.getPolicy()));
        repo.setTargetRef(RUtil.jaxbRefToRepo(jaxb.getTargetRef(), repo, prismContext));
    }

    public ExclusionType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        ExclusionType object = new ExclusionType();
        RExclusion.copyToJAXB(this, object, prismContext);
        return object;
    }
}

