/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class MDCLevelTurboFilter
extends TurboFilter {
    private FilterReply onMatch = FilterReply.ACCEPT;
    private FilterReply onMismatch = FilterReply.NEUTRAL;
    private String mdcKey;
    private String mdcValue;
    private Level level = Level.OFF;

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (this.mdcKey == null || this.mdcValue == null) {
            return FilterReply.NEUTRAL;
        }
        if (level.isGreaterOrEqual(this.borderLevel())) {
            if (this.mdcValue.equals(MDC.get((String)this.mdcKey))) {
                if (logger.getName().contains("com.evolveum.midpoint")) {
                    return this.onMatch;
                }
                if ("PROFILING".equals(logger.getName())) {
                    return FilterReply.NEUTRAL;
                }
                if (level.isGreaterOrEqual(Level.DEBUG)) {
                    level = Level.TRACE;
                }
            } else {
                return this.onMismatch;
            }
        }
        return FilterReply.NEUTRAL;
    }

    public void setOnMatch(String action) {
        this.onMatch = "NEUTRAL".equals(action) ? FilterReply.NEUTRAL : ("ACCEPT".equals(action) ? FilterReply.ACCEPT : FilterReply.DENY);
    }

    public void setOnMismatch(String action) {
        this.onMismatch = "NEUTRAL".equals(action) ? FilterReply.NEUTRAL : ("ACCEPT".equals(action) ? FilterReply.ACCEPT : FilterReply.DENY);
    }

    public void setMDCKey(String mdcKey) {
        System.out.println("MDCkey = " + mdcKey);
        this.mdcKey = mdcKey;
    }

    public void setMDCValue(String mdcValue) {
        System.out.println("MDCvalue = " + mdcValue);
        this.mdcValue = mdcValue;
    }

    public void setLevel(String loggingLevel) {
        String level = loggingLevel.toUpperCase();
        this.level = "OFF".equals(level) ? Level.OFF : ("ERROR".equals(level) ? Level.ERROR : ("WARN".equals(level) ? Level.WARN : ("INFO".equals(level) ? Level.INFO : ("DEBUG".equals(level) ? Level.DEBUG : ("TRACE".equals(level) ? Level.TRACE : Level.ALL)))));
    }

    private Level borderLevel() {
        return this.level;
    }

    public void start() {
    }
}

