/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DomElementVisitor;
import com.evolveum.midpoint.util.DomVisitorUtil;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UglyHacks {
    private static final String FORTIFIED_NAMESPACE_DECLARATIONS_ELEMENT_NAME = "FORtiFIed__xmlNS";
    private static final char FORTIFIED_NAMESPACE_DECLARATIONS_SEPARATOR = ' ';

    public static String forceXsiNsDeclaration(String originalXml) {
        int iOpeningBracket = -1;
        do {
            if ((iOpeningBracket = originalXml.indexOf(60, iOpeningBracket + 1)) >= 0) continue;
            return originalXml;
        } while (!Character.isLetter(originalXml.charAt(iOpeningBracket + 1)));
        int iClosingBracket = originalXml.indexOf(62, iOpeningBracket);
        if (iClosingBracket < 0) {
            return originalXml;
        }
        String firstElement = originalXml.substring(iOpeningBracket, iClosingBracket);
        if (firstElement.indexOf("xmlns:xsi") >= 0) {
            return originalXml;
        }
        int iEndOfElementName = iOpeningBracket;
        while (iEndOfElementName < iClosingBracket) {
            char ch = originalXml.charAt(iEndOfElementName);
            if (ch == ' ' || ch == '>') break;
            ++iEndOfElementName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(originalXml.substring(0, iEndOfElementName));
        sb.append(" xmlns:xsi='");
        sb.append("http://www.w3.org/2001/XMLSchema-instance");
        sb.append("'");
        sb.append(originalXml.substring(iEndOfElementName));
        return sb.toString();
    }

    public static void fortifyNamespaceDeclarations(Node node) {
        DomElementVisitor visitor = new DomElementVisitor(){

            @Override
            public void visit(Element element) {
                UglyHacks.fortifyNamespaceDeclarationsSingleElement(element);
            }
        };
        DomVisitorUtil.visitElements(node, visitor);
    }

    public static void fortifyNamespaceDeclarationsSingleElement(Element element) {
        ArrayList<String> xmlnss = new ArrayList<String>();
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            if (DOMUtil.isNamespaceDefinition(attr)) {
                String prefix = DOMUtil.getNamespaceDeclarationPrefix(attr);
                String namespace = DOMUtil.getNamespaceDeclarationNamespace(attr);
                xmlnss.add(String.valueOf(prefix) + "=" + namespace);
            }
            ++i;
        }
        String fortifiedXmlnss = StringUtils.join(xmlnss, (char)' ');
        element.setAttribute(FORTIFIED_NAMESPACE_DECLARATIONS_ELEMENT_NAME, fortifiedXmlnss);
    }

    public static void unfortifyNamespaceDeclarations(Node node) {
        DomElementVisitor visitor = new DomElementVisitor(){

            @Override
            public void visit(Element element) {
                UglyHacks.unfortifyNamespaceDeclarationsSingleElement(element);
            }
        };
        DomVisitorUtil.visitElements(node, visitor);
    }

    public static void unfortifyNamespaceDeclarationsSingleElement(Element element) {
        String[] xmlnss;
        String fortifiedXmlnss = element.getAttribute(FORTIFIED_NAMESPACE_DECLARATIONS_ELEMENT_NAME);
        if (element.hasAttribute(FORTIFIED_NAMESPACE_DECLARATIONS_ELEMENT_NAME)) {
            element.removeAttribute(FORTIFIED_NAMESPACE_DECLARATIONS_ELEMENT_NAME);
        }
        if (StringUtils.isBlank((String)fortifiedXmlnss)) {
            return;
        }
        String[] stringArray = xmlnss = StringUtils.split((String)fortifiedXmlnss, (char)' ');
        int n = xmlnss.length;
        int n2 = 0;
        while (n2 < n) {
            String xmlns = stringArray[n2];
            String[] prefixAndUrl = StringUtils.split((String)xmlns, (String)"=", (int)2);
            String prefix = prefixAndUrl[0];
            String url = prefixAndUrl[1];
            if (!DOMUtil.hasNamespaceDeclarationForPrefix(element, prefix)) {
                DOMUtil.setNamespaceDeclaration(element, prefix, url);
            }
            ++n2;
        }
    }
}

