/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.support;

import java.util.List;
import org.opensaml.saml2.metadata.IndexedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SAML2MetadataHelper {
    private SAML2MetadataHelper() {
    }

    public static <T extends IndexedEndpoint> T getDefaultIndexedEndpoint(List<T> candidates) {
        Logger log = SAML2MetadataHelper.getLogger();
        log.debug("Selecting default IndexedEndpoint");
        if (candidates == null || candidates.isEmpty()) {
            log.debug("IndexedEndpoint list was null or empty, returning null");
            return null;
        }
        IndexedEndpoint firstNoDefault = null;
        for (IndexedEndpoint endpoint : candidates) {
            if (endpoint.isDefault().booleanValue()) {
                log.debug("Selected IndexedEndpoint with explicit isDefault of true");
                return (T)endpoint;
            }
            if (firstNoDefault != null || endpoint.isDefaultXSBoolean() != null) continue;
            firstNoDefault = endpoint;
        }
        if (firstNoDefault != null) {
            log.debug("Selected first IndexedEndpoint with no explicit isDefault");
            return (T)firstNoDefault;
        }
        log.debug("Selected first IndexedEndpoint with explicit isDefault of false");
        return (T)((IndexedEndpoint)candidates.get(0));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SAML2MetadataHelper.class);
    }
}

