/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.api.PolicyViolationException;
import com.evolveum.midpoint.model.synchronizer.AccountValuesProcessor;
import com.evolveum.midpoint.model.synchronizer.ActivationProcessor;
import com.evolveum.midpoint.model.synchronizer.AssignmentProcessor;
import com.evolveum.midpoint.model.synchronizer.CredentialsProcessor;
import com.evolveum.midpoint.model.synchronizer.InboundProcessor;
import com.evolveum.midpoint.model.synchronizer.ReconciliationProcessor;
import com.evolveum.midpoint.model.synchronizer.SyncContextListener;
import com.evolveum.midpoint.model.synchronizer.SynchronizerUtil;
import com.evolveum.midpoint.model.synchronizer.UserPolicyProcessor;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.ReferenceDelta;
import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountSynchronizationSettingsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemObjectsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserTemplateType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UserSynchronizer {
    private static final Trace LOGGER = TraceManager.getTrace(UserSynchronizer.class);
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    private transient RepositoryService cacheRepositoryService;
    @Autowired(required=true)
    private ProvisioningService provisioningService;
    @Autowired(required=true)
    private UserPolicyProcessor userPolicyProcessor;
    @Autowired(required=true)
    private AssignmentProcessor assignmentProcessor;
    @Autowired(required=true)
    private InboundProcessor inboundProcessor;
    @Autowired(required=true)
    private AccountValuesProcessor accountValuesProcessor;
    @Autowired(required=true)
    private ReconciliationProcessor reconciliationProcessor;
    @Autowired(required=true)
    private CredentialsProcessor credentialsProcessor;
    @Autowired(required=true)
    private ActivationProcessor activationProcessor;
    @Autowired(required=true)
    private PrismContext prismContext;
    private boolean consistenceChecks = true;
    private SyncContextListener syncContextListener;

    public SyncContextListener getSyncContextListener() {
        return this.syncContextListener;
    }

    public void setSyncContextListener(SyncContextListener syncContextListener) {
        this.syncContextListener = syncContextListener;
    }

    public void synchronizeUser(SyncContext context, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException, CommunicationException, ConfigurationException, ObjectAlreadyExistsException, PolicyViolationException, SecurityViolationException {
        if (this.syncContextListener != null) {
            this.syncContextListener.beforeSync(context);
        }
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        this.loadUser(context, result);
        this.loadFromSystemConfig(context, result);
        context.recomputeUserNew();
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        this.loadAccountRefs(context, result);
        context.recomputeUserNew();
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        SynchronizerUtil.traceContext("load", context, false);
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        this.checkAccountContextReconciliation(context, result);
        this.inboundProcessor.processInbound(context, result);
        context.recomputeUserNew();
        SynchronizerUtil.traceContext("inbound", context, false);
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        this.userPolicyProcessor.processUserPolicy(context, result);
        context.recomputeUserNew();
        SynchronizerUtil.traceContext("user policy", context, false);
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        this.assignmentProcessor.processAssignmentsAccounts(context, result);
        context.recomputeNew();
        SynchronizerUtil.traceContext("assignments", context, true);
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        this.accountValuesProcessor.process(context, result);
        this.credentialsProcessor.processCredentials(context, result);
        context.recomputeNew();
        SynchronizerUtil.traceContext("credentials", context, false);
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        this.activationProcessor.processActivation(context, result);
        context.recomputeNew();
        SynchronizerUtil.traceContext("activation", context, false);
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        this.reconciliationProcessor.processReconciliation(context, result);
        context.recomputeNew();
        SynchronizerUtil.traceContext("reconciliation", context, false);
        if (this.consistenceChecks) {
            context.checkConsistence();
        }
        if (this.syncContextListener != null) {
            this.syncContextListener.afterSync(context);
        }
    }

    private void checkAccountContextReconciliation(SyncContext context, OperationResult result) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException, SecurityViolationException {
        OperationResult subResult = result.createSubresult(String.valueOf(UserSynchronizer.class.getName()) + ".checkAccountContextReconciliation");
        try {
            for (AccountSyncContext accContext : context.getAccountContexts()) {
                if (!accContext.isDoReconciliation() || accContext.getAccountOld() != null && accContext.isFullAccount()) continue;
                if (accContext.getOid() == null) {
                    throw new SystemException("Request to reconcile account with null OID and without a full representation in account sync context");
                }
                PrismObject account = this.provisioningService.getObject(AccountShadowType.class, accContext.getOid(), subResult);
                accContext.setAccountOld((PrismObject<AccountShadowType>)account);
                accContext.fixAccounts();
                accContext.setFullAccount(true);
            }
        }
        finally {
            subResult.computeStatus();
        }
    }

    private void loadUser(SyncContext context, OperationResult result) throws SchemaException, ObjectNotFoundException {
        if (context.getUserOld() != null) {
            return;
        }
        if (context.getUserDelta().getObjectToAdd() != null) {
            return;
        }
        ObjectDelta<UserType> userPrimaryDelta = context.getUserPrimaryDelta();
        if (userPrimaryDelta == null) {
            throw new UnsupportedOperationException("TODO");
        }
        if (userPrimaryDelta.getChangeType() == ChangeType.ADD) {
            return;
        }
        String userOid = userPrimaryDelta.getOid();
        if (StringUtils.isBlank((String)userOid)) {
            throw new IllegalArgumentException("No OID in primary user delta");
        }
        PrismObject user = this.cacheRepositoryService.getObject(UserType.class, userOid, result);
        context.setUserOld((PrismObject<UserType>)user);
    }

    private void loadAccountRefs(SyncContext context, OperationResult result) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        PrismObject<UserType> userOld;
        PolicyDecision policyDecision = null;
        if (context.getUserPrimaryDelta() != null && context.getUserPrimaryDelta().getChangeType() == ChangeType.DELETE) {
            policyDecision = PolicyDecision.DELETE;
        }
        if ((userOld = context.getUserOld()) != null) {
            this.loadAccountRefsFromUser(context, userOld, policyDecision, result);
        }
        this.loadAccountRefsFromDelta(context, userOld, context.getUserPrimaryDelta(), result);
        this.loadAccountContextsSync(context, result);
    }

    private void loadAccountRefsFromUser(SyncContext context, PrismObject<UserType> user, PolicyDecision policyDecision, OperationResult result) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException, SecurityViolationException {
        PrismReference accountRef = user.findReference(UserType.F_ACCOUNT_REF);
        if (accountRef == null) {
            return;
        }
        for (PrismReferenceValue accountRefVal : accountRef.getValues()) {
            AccountSyncContext accountSyncContext;
            String oid = accountRefVal.getOid();
            if (StringUtils.isBlank((String)oid)) {
                LOGGER.trace("Null or empty OID in account reference {} in user:\n{}", (Object)accountRef, (Object)user.dump());
                throw new SchemaException("Null or empty OID in account reference in " + user);
            }
            if (this.accountContextAlreadyExists(oid, context)) continue;
            PrismObject account = accountRefVal.getObject();
            if (account == null) {
                account = this.cacheRepositoryService.getObject(AccountShadowType.class, oid, result);
            }
            if ((accountSyncContext = this.getOrCreateAccountContext(context, (PrismObject<AccountShadowType>)account, result)).getPolicyDecision() == null) {
                accountSyncContext.setPolicyDecision(policyDecision);
            }
            if (accountSyncContext.isDoReconciliation()) continue;
            accountSyncContext.setAccountOld((PrismObject<AccountShadowType>)account);
            accountSyncContext.fixAccounts();
            if (!context.isDoReconciliationForAllAccounts()) continue;
            accountSyncContext.setDoReconciliation(true);
        }
    }

    private void loadAccountRefsFromDelta(SyncContext context, PrismObject<UserType> user, ObjectDelta<UserType> userPrimaryDelta, OperationResult result) throws SchemaException, ObjectNotFoundException, CommunicationException, ConfigurationException, SecurityViolationException {
        PrismObject account;
        AccountSyncContext accountSyncContext;
        String oid;
        ReferenceDelta accountRefDelta;
        PrismReference accountRef;
        if (userPrimaryDelta == null) {
            return;
        }
        if (userPrimaryDelta.getChangeType() == ChangeType.ADD) {
            accountRef = userPrimaryDelta.getObjectToAdd().findReference(UserType.F_ACCOUNT_REF);
            if (accountRef == null) {
                return;
            }
            accountRefDelta = accountRef.createDelta(new PropertyPath(new QName[]{UserType.F_ACCOUNT_REF}));
            accountRefDelta.addValuesToAdd(PrismValue.cloneValues((Collection)accountRef.getValues()));
        } else if (userPrimaryDelta.getChangeType() == ChangeType.MODIFY) {
            accountRefDelta = userPrimaryDelta.findReferenceModification(UserType.F_ACCOUNT_REF);
            if (accountRefDelta == null) {
                return;
            }
        } else {
            return;
        }
        if (accountRefDelta.isReplace()) {
            accountRefDelta = accountRefDelta.clone();
            accountRef = user.findReference(UserType.F_ACCOUNT_REF);
            accountRefDelta.distributeReplace((Collection)(accountRef == null ? null : accountRef.getValues()));
        }
        if (accountRefDelta.getValuesToAdd() != null) {
            for (PrismReferenceValue refVal : accountRefDelta.getValuesToAdd()) {
                oid = refVal.getOid();
                accountSyncContext = null;
                account = null;
                boolean isCombinedAdd = false;
                if (oid == null) {
                    account = refVal.getObject();
                    if (account == null) {
                        throw new SchemaException("Null or empty OID in account reference " + refVal + " in " + user);
                    }
                    accountSyncContext = this.getOrCreateAccountContext(context, (PrismObject<AccountShadowType>)account, result);
                    ObjectDelta accountPrimaryDelta = account.createAddDelta();
                    accountSyncContext.setAccountPrimaryDelta((ObjectDelta<AccountShadowType>)accountPrimaryDelta);
                    accountSyncContext.setFullAccount(true);
                    isCombinedAdd = true;
                } else {
                    try {
                        account = this.cacheRepositoryService.getObject(AccountShadowType.class, oid, result);
                        accountSyncContext = this.getOrCreateAccountContext(context, (PrismObject<AccountShadowType>)account, result);
                        accountSyncContext.setAccountOld((PrismObject<AccountShadowType>)account);
                        accountSyncContext.fixAccounts();
                    }
                    catch (ObjectNotFoundException e) {
                        if (refVal.getObject() == null) {
                            throw e;
                        }
                        account = refVal.getObject();
                        accountSyncContext = this.getOrCreateAccountContext(context, (PrismObject<AccountShadowType>)account, result);
                        ObjectDelta accountPrimaryDelta = account.createAddDelta();
                        accountSyncContext.setAccountPrimaryDelta((ObjectDelta<AccountShadowType>)accountPrimaryDelta);
                        accountSyncContext.setFullAccount(true);
                        isCombinedAdd = true;
                    }
                }
                if (!context.isDoReconciliationForAllAccounts() || isCombinedAdd) continue;
                accountSyncContext.setDoReconciliation(true);
            }
        }
        if (accountRefDelta.getValuesToDelete() != null) {
            for (PrismReferenceValue refVal : accountRefDelta.getValuesToDelete()) {
                oid = refVal.getOid();
                accountSyncContext = null;
                account = null;
                if (oid == null) {
                    throw new SchemaException("Cannot delete account ref withot an oid in " + user);
                }
                try {
                    account = this.cacheRepositoryService.getObject(AccountShadowType.class, oid, result);
                    accountSyncContext = this.getOrCreateAccountContext(context, (PrismObject<AccountShadowType>)account, result);
                    accountSyncContext.setAccountOld((PrismObject<AccountShadowType>)account);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    LOGGER.warn("Deleting accountRef of " + user + " that points to non-existing OID " + oid);
                }
                if (accountSyncContext == null) continue;
                if (refVal.getObject() == null) {
                    accountSyncContext.setPolicyDecision(PolicyDecision.UNLINK);
                    continue;
                }
                accountSyncContext.setPolicyDecision(PolicyDecision.DELETE);
                ObjectDelta accountPrimaryDelta = account.createDeleteDelta();
                accountSyncContext.setAccountPrimaryDelta((ObjectDelta<AccountShadowType>)accountPrimaryDelta);
            }
        }
        if (userPrimaryDelta.getChangeType() == ChangeType.ADD) {
            accountRef = userPrimaryDelta.getObjectToAdd().findReference(UserType.F_ACCOUNT_REF);
            this.pruneOidlessReferences(accountRef.getValues());
        } else if (userPrimaryDelta.getChangeType() == ChangeType.MODIFY) {
            accountRefDelta = userPrimaryDelta.findReferenceModification(UserType.F_ACCOUNT_REF);
            this.pruneOidlessReferences(accountRefDelta.getValuesToAdd());
            this.pruneOidlessReferences(accountRefDelta.getValuesToReplace());
            this.pruneOidlessReferences(accountRefDelta.getValuesToDelete());
        }
    }

    private void loadAccountContextsSync(SyncContext context, OperationResult result) throws SchemaException, ObjectNotFoundException, CommunicationException, ConfigurationException, SecurityViolationException {
        for (AccountSyncContext accountCtx : context.getAccountContexts()) {
            ObjectDelta<AccountShadowType> syncDelta;
            if (accountCtx.getAccountOld() != null || accountCtx.isDoReconciliation() || (syncDelta = accountCtx.getAccountSyncDelta()) == null) continue;
            String oid = syncDelta.getOid();
            PrismObject account = null;
            if (syncDelta.getChangeType() == ChangeType.ADD) {
                account = syncDelta.getObjectToAdd().clone();
                accountCtx.setAccountOld((PrismObject<AccountShadowType>)account);
                accountCtx.fixAccounts();
            } else {
                if (oid == null) {
                    throw new IllegalArgumentException("No OID in sync delta in " + accountCtx);
                }
                account = this.cacheRepositoryService.getObject(AccountShadowType.class, oid, result);
                if (syncDelta.getChangeType() != ChangeType.DELETE) {
                    syncDelta.applyTo(account);
                    accountCtx.setAccountOld((PrismObject<AccountShadowType>)account);
                    accountCtx.fixAccounts();
                }
            }
            accountCtx.setOid(oid);
            if (accountCtx.getResource() != null) continue;
            String resourceOid = ResourceObjectShadowUtil.getResourceOid((ResourceObjectShadowType)((ResourceObjectShadowType)account.asObjectable()));
            if (resourceOid == null) {
                throw new IllegalArgumentException("No resource OID in " + account);
            }
            ResourceType resourceType = (ResourceType)this.provisioningService.getObject(ResourceType.class, resourceOid, result).asObjectable();
            context.rememberResource(resourceType);
            accountCtx.setResource(resourceType);
        }
    }

    private void pruneOidlessReferences(Collection<PrismReferenceValue> refVals) {
        if (refVals == null) {
            return;
        }
        Iterator<PrismReferenceValue> iterator = refVals.iterator();
        while (iterator.hasNext()) {
            PrismReferenceValue referenceValue = iterator.next();
            if (referenceValue.getOid() != null) continue;
            iterator.remove();
        }
    }

    private AccountSyncContext getOrCreateAccountContext(SyncContext context, PrismObject<AccountShadowType> account, OperationResult result) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException, SecurityViolationException {
        AccountShadowType accountType = (AccountShadowType)account.asObjectable();
        String resourceOid = ResourceObjectShadowUtil.getResourceOid((ResourceObjectShadowType)accountType);
        if (resourceOid == null) {
            throw new SchemaException("The " + account + " has null resource reference OID");
        }
        ResourceAccountType rat = new ResourceAccountType(resourceOid, accountType.getAccountType());
        AccountSyncContext accountSyncContext = context.getAccountSyncContext(rat);
        if (accountSyncContext == null) {
            ResourceType resource = context.getResource(rat);
            if (resource == null) {
                resource = (ResourceType)this.provisioningService.getObject(ResourceType.class, resourceOid, result).asObjectable();
                context.rememberResource(resource);
            }
            accountSyncContext = context.createAccountSyncContext(rat);
        }
        accountSyncContext.setOid(account.getOid());
        return accountSyncContext;
    }

    private boolean accountContextAlreadyExists(String oid, SyncContext context) {
        for (AccountSyncContext accContext : context.getAccountContexts()) {
            if (!oid.equals(accContext.getOid())) continue;
            return true;
        }
        return false;
    }

    private void loadFromSystemConfig(SyncContext context, OperationResult result) throws ObjectNotFoundException, SchemaException {
        PrismObject systemConfiguration = this.cacheRepositoryService.getObject(SystemConfigurationType.class, SystemObjectsType.SYSTEM_CONFIGURATION.value(), result);
        if (systemConfiguration == null) {
            LOGGER.warn("System configuration object is null (should not happen!)");
            return;
        }
        SystemConfigurationType systemConfigurationType = (SystemConfigurationType)systemConfiguration.asObjectable();
        if (context.getUserTemplate() == null) {
            UserTemplateType defaultUserTemplate = systemConfigurationType.getDefaultUserTemplate();
            context.setUserTemplate(defaultUserTemplate);
        }
        if (context.getAccountSynchronizationSettings() == null) {
            AccountSynchronizationSettingsType globalAccountSynchronizationSettings = systemConfigurationType.getGlobalAccountSynchronizationSettings();
            LOGGER.trace("Applying globalAccountSynchronizationSettings to context: {}", (Object)globalAccountSynchronizationSettings);
            context.setAccountSynchronizationSettings(globalAccountSynchronizationSettings);
        }
    }
}

