/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructionFactory;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.schema.constants.ExpressionConstants;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PropertyConstructionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserTemplateType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserPolicyProcessor {
    private static final Trace LOGGER = TraceManager.getTrace(UserPolicyProcessor.class);
    @Autowired(required=true)
    private ValueConstructionFactory valueConstructionFactory;
    @Autowired(required=true)
    private PrismContext prismContext;

    public void processUserPolicy(SyncContext context, OperationResult result) throws ObjectNotFoundException, SchemaException, ExpressionEvaluationException {
        UserTemplateType userTemplate = this.determineUserTemplate(context, result);
        if (userTemplate == null) {
            return;
        }
        this.applyUserTemplate(context, userTemplate, result);
    }

    private void applyUserTemplate(SyncContext context, UserTemplateType userTemplate, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        LOGGER.trace("Applying " + ObjectTypeUtil.toShortString((ObjectType)userTemplate) + " to " + context.getUserNew());
        ObjectDelta userSecondaryDelta = context.getUserSecondaryDelta();
        for (PropertyConstructionType propConstr : userTemplate.getPropertyConstruction()) {
            XPathHolder propertyXPath = new XPathHolder(propConstr.getProperty());
            PropertyPath itemPath = propertyXPath.toPropertyPath();
            PrismObjectDefinition<UserType> userDefinition = this.getUserDefinition();
            ItemDefinition itemDefinition = userDefinition.findItemDefinition(itemPath);
            if (itemDefinition == null) {
                throw new SchemaException("The property " + itemPath + " is not a valid user property, defined in " + ObjectTypeUtil.toShortString((ObjectType)userTemplate));
            }
            ValueConstructionType valueConstructionType = propConstr.getValueConstruction();
            ValueConstruction valueConstruction = this.valueConstructionFactory.createValueConstruction(valueConstructionType, itemDefinition, "user template expression for " + itemDefinition.getName() + " while processing user " + context.getUserNew());
            PrismProperty existingValue = context.getUserNew().findProperty(itemPath);
            if (existingValue != null && !existingValue.isEmpty() && valueConstruction.isInitial()) continue;
            this.evaluateUserTemplateValueConstruction(valueConstruction, itemDefinition, context, result);
            Item output = valueConstruction.getOutput();
            ItemDelta itemDelta = output.createDelta(itemPath);
            if (itemDefinition.isMultiValue()) {
                itemDelta.addValuesToAdd((Collection)output.getValues());
            } else {
                itemDelta.setValuesToReplace((Collection)output.getValues());
            }
            if (userSecondaryDelta == null) {
                userSecondaryDelta = new ObjectDelta(UserType.class, ChangeType.MODIFY);
                context.setUserSecondaryDelta((ObjectDelta<UserType>)userSecondaryDelta);
            }
            userSecondaryDelta.addModification(itemDelta);
        }
    }

    private PrismObjectDefinition<UserType> getUserDefinition() {
        return this.prismContext.getSchemaRegistry().getObjectSchema().findObjectDefinitionByCompileTimeClass(UserType.class);
    }

    private void evaluateUserTemplateValueConstruction(ValueConstruction valueConstruction, ItemDefinition propertyDefinition, SyncContext context, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        valueConstruction.addVariableDefinition(ExpressionConstants.VAR_USER, context.getUserNew());
        valueConstruction.evaluate(result);
    }

    private UserTemplateType determineUserTemplate(SyncContext context, OperationResult result) throws ObjectNotFoundException, SchemaException {
        if (context.getUserTemplate() != null) {
            return context.getUserTemplate();
        }
        return null;
    }
}

