/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;

public class SynchronizerUtil {
    private static final Trace LOGGER = TraceManager.getTrace(SynchronizerUtil.class);

    public static void traceContext(String phase, SyncContext context, boolean showTriples) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Synchronization context changes after ");
            sb.append(phase);
            sb.append(":");
            boolean empty = true;
            for (ObjectDelta<? extends ObjectType> objectDelta : context.getAllChanges()) {
                if (objectDelta.isEmpty()) continue;
                sb.append("\n");
                sb.append(objectDelta.toString());
                empty = false;
            }
            if (empty) {
                sb.append(" no change");
            }
            LOGGER.debug(sb.toString());
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Synchronization context:\n---[ CONTEXT after {} ]--------------------------------\n{}\n", (Object)phase, (Object)context.dump(showTriples));
        }
    }
}

