/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedAttributeDefinition;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.synchronizer.PropertyValueWithOrigin;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.SourceType;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.DeltaSetTriple;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationProcessor {
    @Autowired(required=true)
    PrismContext prismContext;
    public static final String PROCESS_RECONCILIATION = String.valueOf(ReconciliationProcessor.class.getName()) + ".processReconciliation";
    private static final Trace LOGGER = TraceManager.getTrace(ReconciliationProcessor.class);

    void processReconciliation(SyncContext context, OperationResult result) throws SchemaException {
        OperationResult subResult = result.createSubresult(PROCESS_RECONCILIATION);
        try {
            try {
                for (AccountSyncContext accContext : context.getAccountContexts()) {
                    PolicyDecision policyDecision;
                    if (!accContext.isDoReconciliation() || (policyDecision = accContext.getPolicyDecision()) != null && (policyDecision == PolicyDecision.DELETE || policyDecision == PolicyDecision.UNLINK)) continue;
                    if (accContext.getAccountOld() == null) {
                        LOGGER.warn("Can't do reconciliation. Account context doesn't contain old version of account.");
                        continue;
                    }
                    LOGGER.trace("Attribute reconciliation processing ACCOUNT {}", (Object)accContext.getResourceAccountType());
                    Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedAttributes = accContext.getSqueezedAttributes();
                    if (squeezedAttributes.isEmpty()) continue;
                    RefinedResourceSchema refinedSchema = RefinedResourceSchema.getRefinedSchema((ResourceType)accContext.getResource(), (PrismContext)this.prismContext);
                    RefinedAccountDefinition accountDefinition = refinedSchema.getAccountDefinition(accContext.getResourceAccountType().getAccountType());
                    this.reconcileAccount(accContext, squeezedAttributes, accountDefinition);
                }
            }
            catch (RuntimeException e) {
                subResult.recordFatalError((Throwable)e);
                throw e;
            }
            catch (SchemaException e) {
                subResult.recordFatalError((Throwable)e);
                throw e;
            }
        }
        finally {
            subResult.computeStatus();
        }
    }

    private void reconcileAccount(AccountSyncContext accCtx, Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedAttributes, RefinedAccountDefinition accountDefinition) throws SchemaException {
        PrismObject<AccountShadowType> account = accCtx.getAccountNew();
        PrismContainer attributesContainer = account.findContainer(AccountShadowType.F_ATTRIBUTES);
        Collection attributeNames = MiscUtil.union((Collection[])new Collection[]{squeezedAttributes.keySet(), attributesContainer.getValue().getPropertyNames()});
        for (QName attrName : attributeNames) {
            RefinedAttributeDefinition attributeDefinition = accountDefinition.getAttributeDefinition(attrName);
            if (attributeDefinition == null) {
                throw new SchemaException("No definition for attribute " + attrName + " in " + accCtx.getResourceAccountType());
            }
            DeltaSetTriple<PropertyValueWithOrigin> pvwoTriple = squeezedAttributes.get(attrName);
            ArrayList<PropertyValueWithOrigin> shouldBePValues = null;
            shouldBePValues = pvwoTriple == null ? new ArrayList<PropertyValueWithOrigin>() : pvwoTriple.getNonNegativeValues();
            PrismProperty attribute = attributesContainer.findProperty(attrName);
            Collection arePValues = null;
            arePValues = attribute != null ? (Collection)attribute.getValues(Object.class) : new HashSet();
            for (PropertyValueWithOrigin shouldBePvwo : shouldBePValues) {
                Object shouldBeRealValue;
                ValueConstruction<?> shouldBeVc = shouldBePvwo.getValueConstruction();
                if (shouldBeVc == null || shouldBeVc.isInitial() && !arePValues.isEmpty() || this.isInValues(shouldBeRealValue = shouldBePvwo.getPropertyValue().getValue(), arePValues)) continue;
                this.recordDelta(accCtx, (ResourceAttributeDefinition)attributeDefinition, ChangeType.ADD, shouldBeRealValue);
            }
            if (attributeDefinition.isTolerant()) continue;
            for (PrismPropertyValue isPValue : arePValues) {
                if (this.isInPvwoValues(isPValue.getValue(), shouldBePValues)) continue;
                this.recordDelta(accCtx, (ResourceAttributeDefinition)attributeDefinition, ChangeType.DELETE, isPValue.getValue());
            }
        }
    }

    private void recordDelta(AccountSyncContext accCtx, ResourceAttributeDefinition attrDef, ChangeType changeType, Object value) throws SchemaException {
        LOGGER.trace("Reconciliation will {} value of attribute {}: {}", new Object[]{changeType, attrDef, value});
        PropertyDelta attrDelta = new PropertyDelta(SchemaConstants.PATH_ATTRIBUTES, attrDef.getName(), (PrismPropertyDefinition)attrDef);
        PrismPropertyValue pValue = new PrismPropertyValue(value, SourceType.RECONCILIATION, null);
        if (changeType == ChangeType.ADD) {
            attrDelta.addValueToAdd((PrismValue)pValue);
        } else if (changeType == ChangeType.DELETE) {
            attrDelta.addValueToDelete((PrismValue)pValue);
        } else {
            throw new IllegalArgumentException("Unknown change type " + changeType);
        }
        accCtx.addToSecondaryDelta(attrDelta);
    }

    private boolean isInValues(Object shouldBeValue, Collection<PrismPropertyValue<Object>> arePValues) {
        if (arePValues == null || arePValues.isEmpty()) {
            return false;
        }
        for (PrismPropertyValue<Object> isPValue : arePValues) {
            if (!isPValue.getValue().equals(shouldBeValue)) continue;
            return true;
        }
        return false;
    }

    private boolean isInPvwoValues(Object value, Collection<PropertyValueWithOrigin> shouldBePvwos) {
        for (PropertyValueWithOrigin shouldBePvwo : shouldBePvwos) {
            PrismPropertyValue<?> shouldBePPValue = shouldBePvwo.getPropertyValue();
            Object shouldBeValue = shouldBePPValue.getValue();
            if (!shouldBeValue.equals(value)) continue;
            return true;
        }
        return false;
    }
}

