/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedAttributeDefinition;
import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.synchronizer.AccountConstruction;
import com.evolveum.midpoint.model.synchronizer.PropertyValueWithOrigin;
import com.evolveum.midpoint.model.synchronizer.ReconciliationProcessor;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.DeltaSetTriple;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.springframework.stereotype.Component;

@Component
public class ConsolidationProcessor {
    public static final String PROCESS_CONSOLIDATION = String.valueOf(ConsolidationProcessor.class.getName()) + ".consolidateValues";
    private static final Trace LOGGER = TraceManager.getTrace(ReconciliationProcessor.class);

    void consolidateValues(SyncContext context, AccountSyncContext accCtx, OperationResult result) throws SchemaException, ExpressionEvaluationException {
        if (this.wasAccountDeleted(accCtx)) {
            this.dropAllAccountDelta(accCtx);
            return;
        }
        PolicyDecision policyDecision = accCtx.getPolicyDecision();
        if (policyDecision == PolicyDecision.ADD) {
            this.consolidateValuesAddAccount(context, accCtx, result);
        } else if (policyDecision == PolicyDecision.KEEP) {
            this.consolidateValuesModifyAccount(context, accCtx, result);
        } else if (policyDecision == PolicyDecision.DELETE) {
            this.consolidateValuesDeleteAccount(context, accCtx, result);
        } else {
            this.consolidateValuesModifyAccount(context, accCtx, result);
        }
    }

    private void dropAllAccountDelta(AccountSyncContext accContext) {
        accContext.setAccountPrimaryDelta(null);
        accContext.setAccountSecondaryDelta(null);
    }

    private boolean wasAccountDeleted(AccountSyncContext accContext) {
        ObjectDelta<AccountShadowType> delta = accContext.getAccountSyncDelta();
        return delta != null && ChangeType.DELETE.equals((Object)delta.getChangeType());
    }

    private ObjectDelta<AccountShadowType> consolidateValuesToModifyDelta(SyncContext context, AccountSyncContext accCtx, boolean addUnchangedValues, OperationResult result) throws SchemaException, ExpressionEvaluationException {
        Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedAttributes = this.sqeezeAttributes(accCtx);
        accCtx.setSqueezedAttributes(squeezedAttributes);
        ResourceAccountType rat = accCtx.getResourceAccountType();
        ObjectDelta objectDelta = new ObjectDelta(AccountShadowType.class, ChangeType.MODIFY);
        objectDelta.setOid(accCtx.getOid());
        RefinedAccountDefinition rAccount = context.getRefinedAccountDefinition(rat);
        if (rAccount == null) {
            LOGGER.error("Definition for account type {} not found in the context, but it should be there, dumping context:\n{}", (Object)rat, (Object)context.dump());
            throw new IllegalStateException("Definition for account type " + rat + " not found in the context, but it should be there");
        }
        PropertyPath parentPath = new PropertyPath(new QName[]{SchemaConstants.I_ATTRIBUTES});
        for (Map.Entry<QName, DeltaSetTriple<PropertyValueWithOrigin>> entry : squeezedAttributes.entrySet()) {
            QName attributeName = entry.getKey();
            DeltaSetTriple<PropertyValueWithOrigin> triple = entry.getValue();
            PropertyDelta propDelta = null;
            LOGGER.trace("Consolidating (modify) account {}, attribute {}", (Object)rat, (Object)attributeName);
            PrismContainer attributesPropertyContainer = null;
            if (accCtx.getAccountNew() != null) {
                attributesPropertyContainer = accCtx.getAccountNew().findContainer(SchemaConstants.I_ATTRIBUTES);
            }
            Collection<PrismPropertyValue<?>> allValues = this.collectAllValues(triple);
            for (PrismPropertyValue<?> value : allValues) {
                Collection<PropertyValueWithOrigin> zeroPvwos = this.collectPvwosFromSet(value, triple.getZeroSet());
                if (!zeroPvwos.isEmpty() && !addUnchangedValues) {
                    LOGGER.trace("Value {} unchanged, doing nothing", value);
                    continue;
                }
                Collection plusPvwos = this.collectPvwosFromSet(value, triple.getPlusSet());
                Collection<PropertyValueWithOrigin> minusPvwos = this.collectPvwosFromSet(value, triple.getMinusSet());
                if (!plusPvwos.isEmpty() && !minusPvwos.isEmpty()) {
                    LOGGER.trace("Value {} added and removed, doing nothing", value);
                    continue;
                }
                if (propDelta == null) {
                    RefinedAttributeDefinition attributeDefinition = rAccount.findAttributeDefinition(attributeName);
                    propDelta = new PropertyDelta(parentPath, attributeName, (PrismPropertyDefinition)attributeDefinition);
                }
                boolean initialOnly = true;
                ValueConstruction<?> exclusiveVc = null;
                Collection pvwosToAdd = null;
                pvwosToAdd = addUnchangedValues ? MiscUtil.union((Collection[])new Collection[]{zeroPvwos, plusPvwos}) : plusPvwos;
                if (!pvwosToAdd.isEmpty()) {
                    PrismProperty attributeNew;
                    for (PropertyValueWithOrigin pvwoToAdd : pvwosToAdd) {
                        ValueConstruction<?> vc = pvwoToAdd.getValueConstruction();
                        if (!vc.isInitial()) {
                            initialOnly = false;
                        }
                        if (!vc.isExclusive()) continue;
                        if (exclusiveVc == null) {
                            exclusiveVc = vc;
                            continue;
                        }
                        String message = "Exclusion conflict in account " + rat + ", attribute " + attributeName + ", conflicting constructions: " + exclusiveVc + " and " + vc;
                        LOGGER.error(message);
                        throw new ExpressionEvaluationException(message);
                    }
                    if (initialOnly && attributesPropertyContainer != null && (attributeNew = attributesPropertyContainer.findProperty(attributeName)) != null && !attributeNew.isEmpty()) {
                        LOGGER.trace("Value {} is initial and the attribute already has a value, skipping it", value);
                        continue;
                    }
                    LOGGER.trace("Value {} added", value);
                    propDelta.addValueToAdd(value);
                }
                if (minusPvwos.isEmpty()) continue;
                LOGGER.trace("Value {} deleted", value);
                propDelta.addValueToDelete(value);
            }
            if ((propDelta = this.consolidateWithSync(accCtx, propDelta)) == null) continue;
            propDelta.simplify();
            objectDelta.addModification((ItemDelta)propDelta);
        }
        return objectDelta;
    }

    private void consolidateValuesAddAccount(SyncContext context, AccountSyncContext accCtx, OperationResult result) throws SchemaException, ExpressionEvaluationException {
        ObjectDelta<AccountShadowType> modifyDelta = this.consolidateValuesToModifyDelta(context, accCtx, true, result);
        ObjectDelta<AccountShadowType> accountSecondaryDelta = accCtx.getAccountSecondaryDelta();
        if (accountSecondaryDelta != null) {
            accountSecondaryDelta.merge(modifyDelta);
        } else if (accCtx.getAccountPrimaryDelta() == null) {
            ObjectDelta addDelta = new ObjectDelta(AccountShadowType.class, ChangeType.ADD);
            RefinedAccountDefinition rAccount = context.getRefinedAccountDefinition(accCtx.getResourceAccountType());
            if (rAccount == null) {
                LOGGER.error("Definition for account type {} not found in the context, but it should be there, dumping context:\n{}", (Object)accCtx.getResourceAccountType(), (Object)context.dump());
                throw new IllegalStateException("Definition for account type " + accCtx.getResourceAccountType() + " not found in the context, but it should be there");
            }
            PrismObject newAccount = rAccount.createBlankShadow();
            addDelta.setObjectToAdd(newAccount);
            addDelta.merge(modifyDelta);
            accCtx.setAccountSecondaryDelta((ObjectDelta<AccountShadowType>)addDelta);
        } else {
            accCtx.setAccountSecondaryDelta(modifyDelta);
        }
    }

    private void consolidateValuesModifyAccount(SyncContext context, AccountSyncContext accCtx, OperationResult result) throws SchemaException, ExpressionEvaluationException {
        ObjectDelta<AccountShadowType> modifyDelta = this.consolidateValuesToModifyDelta(context, accCtx, false, result);
        ObjectDelta<AccountShadowType> accountSecondaryDelta = accCtx.getAccountSecondaryDelta();
        if (accountSecondaryDelta != null) {
            if (!modifyDelta.isEmpty()) {
                accountSecondaryDelta.merge(modifyDelta);
            }
        } else {
            accCtx.setAccountSecondaryDelta(modifyDelta);
        }
    }

    private void consolidateValuesDeleteAccount(SyncContext context, AccountSyncContext accCtx, OperationResult result) {
        ObjectDelta deleteDelta = new ObjectDelta(AccountShadowType.class, ChangeType.DELETE);
        deleteDelta.setOid(accCtx.getOid());
        accCtx.setAccountSecondaryDelta((ObjectDelta<AccountShadowType>)deleteDelta);
    }

    private PropertyDelta consolidateWithSync(AccountSyncContext accCtx, PropertyDelta delta) {
        if (delta == null) {
            return null;
        }
        ObjectDelta<AccountShadowType> syncDelta = accCtx.getAccountSyncDelta();
        if (syncDelta == null) {
            return this.consolidateWithSyncAbsolute(accCtx, delta);
        }
        PropertyDelta alreadyDoneDelta = syncDelta.findPropertyDelta(delta.getPath());
        if (alreadyDoneDelta == null) {
            return delta;
        }
        this.cleanupValues(delta.getValuesToAdd(), alreadyDoneDelta);
        this.cleanupValues(delta.getValuesToDelete(), alreadyDoneDelta);
        if (delta.getValues(Object.class).isEmpty()) {
            return null;
        }
        return delta;
    }

    private PropertyDelta consolidateWithSyncAbsolute(AccountSyncContext accCtx, PropertyDelta delta) {
        if (delta == null || accCtx.getAccountOld() == null) {
            return delta;
        }
        PrismObject<AccountShadowType> absoluteAccountState = accCtx.getAccountOld();
        PrismProperty absoluteProperty = absoluteAccountState.findProperty(delta.getPath());
        if (absoluteProperty == null) {
            return delta;
        }
        this.cleanupAbsoluteValues(delta.getValuesToAdd(), true, absoluteProperty);
        this.cleanupAbsoluteValues(delta.getValuesToDelete(), false, absoluteProperty);
        if (delta.getValues(Object.class).isEmpty()) {
            return null;
        }
        return delta;
    }

    private void cleanupAbsoluteValues(Collection<PrismPropertyValue<Object>> values, boolean adding, PrismProperty property) {
        if (values == null) {
            return;
        }
        Iterator<PrismPropertyValue<Object>> iterator = values.iterator();
        while (iterator.hasNext()) {
            PrismPropertyValue<Object> value = iterator.next();
            if (adding && property.hasRealValue(value)) {
                iterator.remove();
            }
            if (adding || property.hasRealValue(value)) continue;
            iterator.remove();
        }
    }

    private void cleanupValues(Collection<PrismPropertyValue<Object>> values, PropertyDelta alreadyDoneDelta) {
        if (values == null) {
            return;
        }
        Iterator<PrismPropertyValue<Object>> iterator = values.iterator();
        while (iterator.hasNext()) {
            PrismPropertyValue<Object> valueToAdd = iterator.next();
            if (!alreadyDoneDelta.isRealValueToAdd(valueToAdd)) continue;
            iterator.remove();
        }
    }

    private Collection<PrismPropertyValue<?>> collectAllValues(DeltaSetTriple<PropertyValueWithOrigin> triple) {
        HashSet allValues = new HashSet();
        this.collectAllValuesFromSet(allValues, triple.getZeroSet());
        this.collectAllValuesFromSet(allValues, triple.getPlusSet());
        this.collectAllValuesFromSet(allValues, triple.getMinusSet());
        return allValues;
    }

    private void collectAllValuesFromSet(Collection<PrismPropertyValue<?>> allValues, Collection<PropertyValueWithOrigin> collection) {
        if (collection == null) {
            return;
        }
        for (PropertyValueWithOrigin pvwo : collection) {
            PrismPropertyValue<?> pval = pvwo.getPropertyValue();
            if (PrismValue.containsRealValue(allValues, pval)) continue;
            allValues.add(pval);
        }
    }

    private Collection<PropertyValueWithOrigin> collectPvwosFromSet(PrismPropertyValue<?> pvalue, Collection<PropertyValueWithOrigin> deltaSet) {
        ArrayList<PropertyValueWithOrigin> pvwos = new ArrayList<PropertyValueWithOrigin>();
        for (PropertyValueWithOrigin setPvwo : deltaSet) {
            if (!setPvwo.equalsRealValue(pvalue)) continue;
            pvwos.add(setPvwo);
        }
        return pvwos;
    }

    private Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> sqeezeAttributes(AccountSyncContext accCtx) {
        HashMap<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedMap = new HashMap<QName, DeltaSetTriple<PropertyValueWithOrigin>>();
        if (accCtx.getAccountConstructionDeltaSetTriple() != null) {
            this.sqeezeAttributesFromAccountConstructionTriple(squeezedMap, accCtx.getAccountConstructionDeltaSetTriple());
        }
        if (accCtx.getOutboundAccountConstruction() != null) {
            if (accCtx.isAdd()) {
                this.sqeezeAttributesFromAccountConstructionNonminusToPlus(squeezedMap, accCtx.getOutboundAccountConstruction());
            } else if (accCtx.isDelete()) {
                this.sqeezeAttributesFromAccountConstructionNonminusToMinus(squeezedMap, accCtx.getOutboundAccountConstruction());
            } else {
                this.sqeezeAttributesFromAccountConstruction(squeezedMap, accCtx.getOutboundAccountConstruction());
            }
        }
        return squeezedMap;
    }

    private void sqeezeAttributesFromAccountConstructionTriple(Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedMap, PrismValueDeltaSetTriple<PrismPropertyValue<AccountConstruction>> accountConstructionDeltaSetTriple) {
        this.sqeezeAttributesFromAccountConstructionSet(squeezedMap, accountConstructionDeltaSetTriple.getZeroSet());
        this.sqeezeAttributesFromAccountConstructionSetNonminusToPlus(squeezedMap, accountConstructionDeltaSetTriple.getPlusSet());
        this.sqeezeAttributesFromAccountConstructionSetNonminusToMinus(squeezedMap, accountConstructionDeltaSetTriple.getMinusSet());
    }

    private void sqeezeAttributesFromAccountConstructionSet(Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedMap, Collection<PrismPropertyValue<AccountConstruction>> accountConstructionSet) {
        if (accountConstructionSet == null) {
            return;
        }
        for (PrismPropertyValue<AccountConstruction> accountConstruction : accountConstructionSet) {
            this.sqeezeAttributesFromAccountConstruction(squeezedMap, (AccountConstruction)accountConstruction.getValue());
        }
    }

    private void sqeezeAttributesFromAccountConstructionSetNonminusToPlus(Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedMap, Collection<PrismPropertyValue<AccountConstruction>> accountConstructionSet) {
        if (accountConstructionSet == null) {
            return;
        }
        for (PrismPropertyValue<AccountConstruction> accountConstruction : accountConstructionSet) {
            this.sqeezeAttributesFromAccountConstructionNonminusToPlus(squeezedMap, (AccountConstruction)accountConstruction.getValue());
        }
    }

    private void sqeezeAttributesFromAccountConstructionSetNonminusToMinus(Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedMap, Collection<PrismPropertyValue<AccountConstruction>> accountConstructionSet) {
        if (accountConstructionSet == null) {
            return;
        }
        for (PrismPropertyValue<AccountConstruction> accountConstruction : accountConstructionSet) {
            this.sqeezeAttributesFromAccountConstructionNonminusToMinus(squeezedMap, (AccountConstruction)accountConstruction.getValue());
        }
    }

    private void sqeezeAttributesFromAccountConstruction(Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedMap, AccountConstruction accountConstruction) {
        for (ValueConstruction<? extends PrismPropertyValue<?>> valueConstruction : accountConstruction.getAttributeConstructions()) {
            DeltaSetTriple<PropertyValueWithOrigin> squeezeTriple = this.getSqueezeMapTriple(squeezedMap, valueConstruction.getItemName());
            PrismValueDeltaSetTriple vcTriple = valueConstruction.getOutputTriple();
            if (vcTriple == null) continue;
            this.convertSqueezeSet(vcTriple.getZeroSet(), squeezeTriple.getZeroSet(), valueConstruction, accountConstruction);
            this.convertSqueezeSet(vcTriple.getPlusSet(), squeezeTriple.getPlusSet(), valueConstruction, accountConstruction);
            this.convertSqueezeSet(vcTriple.getMinusSet(), squeezeTriple.getMinusSet(), valueConstruction, accountConstruction);
        }
    }

    private void sqeezeAttributesFromAccountConstructionNonminusToPlus(Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedMap, AccountConstruction accountConstruction) {
        for (ValueConstruction<? extends PrismPropertyValue<?>> valueConstruction : accountConstruction.getAttributeConstructions()) {
            DeltaSetTriple<PropertyValueWithOrigin> squeezeTriple = this.getSqueezeMapTriple(squeezedMap, valueConstruction.getItemName());
            PrismValueDeltaSetTriple vcTriple = valueConstruction.getOutputTriple();
            if (vcTriple == null) continue;
            this.convertSqueezeSet(vcTriple.getZeroSet(), squeezeTriple.getPlusSet(), valueConstruction, accountConstruction);
            this.convertSqueezeSet(vcTriple.getPlusSet(), squeezeTriple.getPlusSet(), valueConstruction, accountConstruction);
        }
    }

    private void sqeezeAttributesFromAccountConstructionNonminusToMinus(Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedMap, AccountConstruction accountConstruction) {
        for (ValueConstruction<? extends PrismPropertyValue<?>> valueConstruction : accountConstruction.getAttributeConstructions()) {
            DeltaSetTriple<PropertyValueWithOrigin> squeezeTriple = this.getSqueezeMapTriple(squeezedMap, valueConstruction.getItemName());
            PrismValueDeltaSetTriple vcTriple = valueConstruction.getOutputTriple();
            this.convertSqueezeSet(vcTriple.getZeroSet(), squeezeTriple.getMinusSet(), valueConstruction, accountConstruction);
            this.convertSqueezeSet(vcTriple.getPlusSet(), squeezeTriple.getMinusSet(), valueConstruction, accountConstruction);
        }
    }

    private void convertSqueezeSet(Collection<? extends PrismPropertyValue<?>> fromSet, Collection<PropertyValueWithOrigin> toSet, ValueConstruction<? extends PrismPropertyValue<?>> valueConstruction, AccountConstruction accountConstruction) {
        for (PrismPropertyValue<?> from : fromSet) {
            PropertyValueWithOrigin pvwo = new PropertyValueWithOrigin(from, valueConstruction, accountConstruction);
            toSet.add(pvwo);
        }
    }

    private DeltaSetTriple<PropertyValueWithOrigin> getSqueezeMapTriple(Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedMap, QName itemName) {
        DeltaSetTriple triple = squeezedMap.get(itemName);
        if (triple == null) {
            triple = new DeltaSetTriple();
            squeezedMap.put(itemName, (DeltaSetTriple<PropertyValueWithOrigin>)triple);
        }
        return triple;
    }
}

