/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync.action;

import com.evolveum.midpoint.audit.api.AuditEventRecord;
import com.evolveum.midpoint.audit.api.AuditEventStage;
import com.evolveum.midpoint.audit.api.AuditEventType;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.sync.Action;
import com.evolveum.midpoint.model.sync.SynchronizationException;
import com.evolveum.midpoint.model.sync.action.ActivationDecision;
import com.evolveum.midpoint.model.sync.action.BaseAction;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ModifyUserAction
extends BaseAction {
    private static final Trace LOGGER = TraceManager.getTrace(ModifyUserAction.class);
    private final String actionName;
    private ActivationDecision userActivationDecision;
    private ActivationDecision accountActivationDecision;
    private PolicyDecision accountPolicyDecision;

    public ModifyUserAction() {
        this(PolicyDecision.KEEP, Action.ACTION_MODIFY_USER);
    }

    public ModifyUserAction(PolicyDecision accountPolicyDecision, String actionName) {
        Validate.notEmpty((String)actionName, (String)"Action name must not be null or empty.");
        this.accountPolicyDecision = accountPolicyDecision;
        this.actionName = actionName;
    }

    protected void setAccountActivationDecision(ActivationDecision decision) {
        this.accountActivationDecision = decision;
    }

    protected void setUserActivationDecision(ActivationDecision decision) {
        this.userActivationDecision = decision;
    }

    protected PolicyDecision getAccountPolicyDecision() {
        return this.accountPolicyDecision;
    }

    protected ActivationDecision getUserActivationDecision() {
        return this.userActivationDecision;
    }

    protected ActivationDecision getAccountActivationDecision() {
        return this.accountActivationDecision;
    }

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescription change, SynchronizationSituationType situation, AuditEventRecord auditRecord, Task task, OperationResult result) throws SynchronizationException {
        super.executeChanges(userOid, change, situation, auditRecord, task, result);
        Class<? extends ResourceObjectShadowType> clazz = this.getClassFromChange(change);
        if (!AccountShadowType.class.isAssignableFrom(clazz)) {
            throw new SynchronizationException("Couldn't synchronize shadow of type '" + clazz + "', only '" + AccountShadowType.class.getName() + "' is supported.");
        }
        OperationResult subResult = result.createSubresult(this.actionName);
        if (StringUtils.isEmpty((String)userOid)) {
            String message = "Can't modify user, user oid is empty or null.";
            subResult.computeStatus(message);
            throw new SynchronizationException(message);
        }
        UserType userType = this.getUser(userOid, subResult);
        if (userType == null) {
            String message = "Can't find user with oid '" + userOid + "'.";
            subResult.computeStatus(message);
            throw new SynchronizationException(message);
        }
        SyncContext context = null;
        try {
            context = this.createSyncContext(userType, (ResourceType)change.getResource().asObjectable());
            AccountSyncContext accountContext = this.createAccountSyncContext(context, change, this.getAccountPolicyDecision(), this.getAccountActivationDecision());
            if (accountContext == null) {
                LOGGER.warn("Couldn't create account sync context, skipping action for this change.");
                String string = userOid;
                return string;
            }
        }
        catch (Exception ex) {
            throw new SynchronizationException("Couldn't update account sync context in modify user action.", ex);
        }
        finally {
            subResult.recomputeStatus("Couldn't update account sync context in modify user action.");
        }
        try {
            this.synchronizeUser(context, subResult);
            this.executeChanges(context, subResult);
        }
        finally {
            subResult.recomputeStatus();
            result.recomputeStatus();
            auditRecord.clearTimestamp();
            auditRecord.setEventType(AuditEventType.MODIFY_OBJECT);
            auditRecord.setEventStage(AuditEventStage.EXECUTION);
            auditRecord.setResult(result);
            auditRecord.clearDeltas();
            auditRecord.addDeltas(context.getAllChanges());
            this.getAuditService().audit(auditRecord, task);
        }
        return userOid;
    }

    private Class<? extends ResourceObjectShadowType> getClassFromChange(ResourceObjectShadowChangeDescription change) {
        if (change.getObjectDelta() != null) {
            return change.getObjectDelta().getObjectTypeClass();
        }
        if (change.getCurrentShadow() != null) {
            return change.getCurrentShadow().getCompileTimeClass();
        }
        return change.getOldShadow().getCompileTimeClass();
    }

    private SyncContext createSyncContext(UserType user, ResourceType resource) throws SchemaException {
        LOGGER.debug("Creating sync context.");
        this.getPrismContext().getSchemaRegistry().findObjectDefinitionByType(SchemaConstants.I_USER_TYPE);
        SyncContext context = new SyncContext(this.getPrismContext());
        PrismObject oldUser = user.asPrismObject();
        context.setUserOld((PrismObject<UserType>)oldUser);
        context.rememberResource(resource);
        if (this.userActivationDecision == null) {
            LOGGER.debug("User activation decision not defined, skipping activation check.");
            return context;
        }
        PrismProperty enable = oldUser.findOrCreateProperty(SchemaConstants.PATH_ACTIVATION_ENABLE);
        LOGGER.debug("User activation defined, activation property found {}", (Object)enable);
        PrismPropertyValue value = enable.getValue(Boolean.class);
        if (value != null) {
            Boolean isEnabled = (Boolean)value.getValue();
            if (isEnabled == null) {
                this.createActivationPropertyDelta(context, this.userActivationDecision, null);
            }
            if (isEnabled.booleanValue() && ActivationDecision.DISABLE.equals((Object)this.userActivationDecision) || !isEnabled.booleanValue() && ActivationDecision.ENABLE.equals((Object)this.userActivationDecision)) {
                this.createActivationPropertyDelta(context, this.userActivationDecision, isEnabled);
            }
        } else {
            this.createActivationPropertyDelta(context, this.userActivationDecision, null);
        }
        return context;
    }

    private void createActivationPropertyDelta(SyncContext context, ActivationDecision activationDecision, Boolean oldValue) {
        ObjectDelta userDelta = context.getUserSecondaryDelta();
        if (userDelta == null) {
            userDelta = new ObjectDelta(UserType.class, ChangeType.MODIFY);
            userDelta.setOid(context.getUserOld().getOid());
            context.setUserSecondaryDelta((ObjectDelta<UserType>)userDelta);
        }
        this.createActivationPropertyDelta(userDelta, activationDecision, oldValue);
    }
}

