/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync.action;

import com.evolveum.midpoint.audit.api.AuditEventRecord;
import com.evolveum.midpoint.audit.api.AuditEventStage;
import com.evolveum.midpoint.audit.api.AuditEventType;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.sync.Action;
import com.evolveum.midpoint.model.sync.SynchronizationException;
import com.evolveum.midpoint.model.sync.action.BaseAction;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import org.apache.commons.lang.StringUtils;

public class DeleteUserAction
extends BaseAction {
    private static final Trace LOGGER = TraceManager.getTrace(DeleteUserAction.class);

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescription change, SynchronizationSituationType situation, AuditEventRecord auditRecord, Task task, OperationResult result) throws SynchronizationException {
        super.executeChanges(userOid, change, situation, auditRecord, task, result);
        OperationResult subResult = result.createSubresult(Action.ACTION_DELETE_USER);
        if (StringUtils.isEmpty((String)userOid)) {
            String message = "Can't delete user, user oid is empty or null.";
            subResult.computeStatus(message);
            throw new SynchronizationException(message);
        }
        UserType userType = this.getUser(userOid, subResult);
        if (userType == null) {
            String message = "Can't find user with oid '" + userOid + "'.";
            subResult.computeStatus(message);
            throw new SynchronizationException(message);
        }
        SyncContext context = new SyncContext(this.getPrismContext());
        try {
            context.rememberResource((ResourceType)change.getResource().asObjectable());
            this.getPrismContext().getSchemaRegistry().findObjectDefinitionByType(SchemaConstants.I_USER_TYPE);
            PrismObject oldUser = userType.asPrismObject();
            context.setUserOld((PrismObject<UserType>)oldUser);
            ObjectDelta userDelta = new ObjectDelta(UserType.class, ChangeType.DELETE);
            userDelta.setOid(oldUser.getOid());
            context.setUserSecondaryDelta((ObjectDelta<UserType>)userDelta);
            AccountSyncContext accContext = this.createAccountSyncContext(context, change, null, null);
            if (accContext == null) {
                LOGGER.warn("Couldn't create account sync context, skipping action for this change.");
                String string = userOid;
                return string;
            }
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't delete user {}", (Throwable)ex, (Object[])new Object[]{userType.getName()});
            throw new SynchronizationException("Couldn't delete user '" + userType.getName() + "', reason: " + ex.getMessage(), ex);
        }
        finally {
            subResult.recomputeStatus("Couldn't create sync context to delete user '" + userType.getName() + "'.");
        }
        try {
            this.synchronizeUser(context, subResult);
            this.executeChanges(context, subResult);
            userOid = null;
        }
        finally {
            subResult.recomputeStatus("Couldn't delete user '" + userType.getName() + "'.");
            result.recomputeStatus();
            auditRecord.clearTimestamp();
            auditRecord.setEventType(AuditEventType.DELETE_OBJECT);
            auditRecord.setEventStage(AuditEventStage.EXECUTION);
            auditRecord.setResult(result);
            auditRecord.clearDeltas();
            auditRecord.addDeltas(context.getAllChanges());
            this.getAuditService().audit(auditRecord, task);
        }
        return userOid;
    }
}

