/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.model.ChangeExecutor;
import com.evolveum.midpoint.model.sync.SynchronizeAccountResultHandler;
import com.evolveum.midpoint.model.synchronizer.UserSynchronizer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.provisioning.api.ChangeNotificationDispatcher;
import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.provisioning.api.ResourceObjectChangeListener;
import com.evolveum.midpoint.provisioning.api.ResultHandler;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.DeltaConvertor;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.task.api.TaskRunResult;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.FailedOperationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import com.evolveum.prism.xml.ns._public.types_2.ObjectDeltaType;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationTaskHandler
implements TaskHandler {
    public static final String HANDLER_URI = "http://midpoint.evolveum.com/model/sync/reconciliation-handler-1";
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private ProvisioningService provisioningService;
    @Autowired(required=true)
    private RepositoryService repositoryService;
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private UserSynchronizer userSynchronizer;
    @Autowired
    private ChangeExecutor changeExecutor;
    @Autowired(required=true)
    private ChangeNotificationDispatcher changeNotificationDispatcher;
    private static final transient Trace LOGGER = TraceManager.getTrace(ReconciliationTaskHandler.class);
    private static final int SEARCH_MAX_SIZE = 100;
    private static final int MAX_ITERATIONS = 10;

    @PostConstruct
    private void initialize() {
        this.taskManager.registerHandler(HANDLER_URI, (TaskHandler)this);
    }

    public TaskRunResult run(Task task) {
        LOGGER.trace("ReconciliationTaskHandler.run starting");
        long progress = task.getProgress();
        OperationResult opResult = new OperationResult("com.evolveum.midpoint.common.operation.reconciliation");
        TaskRunResult runResult = new TaskRunResult();
        runResult.setOperationResult(opResult);
        String resourceOid = task.getObjectOid();
        opResult.addContext("resourceOid", (Object)resourceOid);
        if (resourceOid == null) {
            throw new IllegalArgumentException("Resource OID is missing in task extension");
        }
        try {
            this.performResourceReconciliation(resourceOid, task, opResult);
            this.performRepoReconciliation(task, opResult);
        }
        catch (ObjectNotFoundException ex) {
            LOGGER.error("Reconciliation: Resource does not exist, OID: {}", (Object)resourceOid, (Object)ex);
            opResult.recordFatalError("Resource does not exist, OID: " + resourceOid, (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (ObjectAlreadyExistsException ex) {
            LOGGER.error("Reconciliation: Object already exist: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Object already exist: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (CommunicationException ex) {
            LOGGER.error("Reconciliation: Communication error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordPartialError("Communication error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (SchemaException ex) {
            LOGGER.error("Reconciliation: Error dealing with schema: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Error dealing with schema: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (RuntimeException ex) {
            LOGGER.error("Reconciliation: Internal Error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Internal Error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Reconciliation: Configuration error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Error dealing with schema: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (SecurityViolationException ex) {
            LOGGER.error("Recompute: Security violation: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Security violation: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        opResult.computeStatus("Reconciliation run has failed");
        runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.FINISHED);
        runResult.setProgress(progress);
        LOGGER.trace("Reconciliation.run stopping, result: {}", (Object)opResult.getStatus());
        return runResult;
    }

    private void performResourceReconciliation(String resourceOid, Task task, OperationResult result) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        OperationResult opResult = result.createSubresult("com.evolveum.midpoint.common.operation.reconciliation.ResourceReconciliation");
        ResourceType resource = (ResourceType)this.repositoryService.getObject(ResourceType.class, resourceOid, opResult).asObjectable();
        RefinedResourceSchema refinedSchema = RefinedResourceSchema.getRefinedSchema((ResourceType)resource, (PrismContext)this.prismContext);
        RefinedAccountDefinition refinedAccountDefinition = refinedSchema.getDefaultAccountDefinition();
        LOGGER.info("Start executing reconciliation of resource {}, reconciling object class {}", (Object)ObjectTypeUtil.toShortString((ObjectType)resource), (Object)refinedAccountDefinition);
        SynchronizeAccountResultHandler handler = new SynchronizeAccountResultHandler(resource, refinedAccountDefinition, task, (ResourceObjectChangeListener)this.changeNotificationDispatcher);
        handler.setSourceChannel(SchemaConstants.CHANGE_CHANNEL_RECON);
        handler.setProcessShortName("reconciliation");
        handler.setStopOnError(false);
        QueryType query = this.createAccountSearchQuery(resource, refinedAccountDefinition);
        this.provisioningService.searchObjectsIterative(AccountShadowType.class, query, null, (ResultHandler)handler, opResult);
    }

    private void performRepoReconciliation(Task task, OperationResult result) throws SchemaException, ObjectAlreadyExistsException, CommunicationException, ObjectNotFoundException, ConfigurationException, SecurityViolationException {
        OperationResult opResult = result.createSubresult("com.evolveum.midpoint.common.operation.reconciliation.RepoReconciliation");
        opResult.addParam("reconciled", (Object)true);
        List shadows = this.repositoryService.listObjects(AccountShadowType.class, new PagingType(), opResult);
        for (PrismObject shadow : shadows) {
            if (((AccountShadowType)shadow.asObjectable()).getFailedOperationType() == null) continue;
            try {
                this.retryFailedOperation((AccountShadowType)shadow.asObjectable(), opResult);
            }
            catch (Exception exception) {
                Collection modifications = PropertyDelta.createModificationReplacePropertyCollection((QName)AccountShadowType.F_ATTEMPT_NUMBER, (PrismObjectDefinition)shadow.getDefinition(), (Object[])new Object[]{((AccountShadowType)shadow.asObjectable()).getAttemptNumber() + 1});
                this.repositoryService.modifyObject(AccountShadowType.class, shadow.getOid(), modifications, opResult);
            }
        }
    }

    private void retryFailedOperation(AccountShadowType shadow, OperationResult parentResult) throws ObjectAlreadyExistsException, SchemaException, CommunicationException, ObjectNotFoundException, ConfigurationException, SecurityViolationException {
        if (shadow.getFailedOperationType().equals((Object)FailedOperationTypeType.ADD)) {
            this.addObject((PrismObject<AccountShadowType>)shadow.asPrismObject(), parentResult);
            return;
        }
        if (shadow.getFailedOperationType().equals((Object)FailedOperationTypeType.MODIFY)) {
            ObjectDeltaType shadowDelta = shadow.getObjectChange();
            Collection modifications = DeltaConvertor.toModifications((Collection)shadowDelta.getModification(), (PrismObjectDefinition)shadow.asPrismObject().getDefinition());
            this.modifyObject(shadow.getOid(), modifications, parentResult);
            return;
        }
        if (shadow.getFailedOperationType().equals((Object)FailedOperationTypeType.DELETE)) {
            this.deleteObject(shadow.getOid(), parentResult);
            return;
        }
    }

    private void addObject(PrismObject<AccountShadowType> shadow, OperationResult parentResult) throws ObjectAlreadyExistsException, SchemaException, CommunicationException, ObjectNotFoundException, ConfigurationException, SecurityViolationException {
        try {
            this.provisioningService.addObject(shadow, null, parentResult);
        }
        catch (ObjectAlreadyExistsException e) {
            parentResult.recordFatalError("Cannot add object: object already exist: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SchemaException e) {
            parentResult.recordFatalError("Cannot add object: schema violation: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CommunicationException e) {
            parentResult.recordFatalError("Cannot add object: communication problem: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ObjectNotFoundException e) {
            parentResult.recordFatalError("Cannot add object: object not found: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ConfigurationException e) {
            parentResult.recordFatalError("Cannot add object: configuration problem: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SecurityViolationException e) {
            parentResult.recordFatalError("Cannot add object: security violation: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void modifyObject(String oid, Collection<? extends ItemDelta> modifications, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        try {
            this.provisioningService.modifyObject(AccountShadowType.class, oid, modifications, null, parentResult);
        }
        catch (ObjectNotFoundException e) {
            parentResult.recordFatalError("Cannot modify object: object not found: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SchemaException e) {
            parentResult.recordFatalError("Cannot modify object: schema violation: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CommunicationException e) {
            parentResult.recordFatalError("Cannot modify object: communication problem: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ConfigurationException e) {
            parentResult.recordFatalError("Cannot modify object: configuration problem: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SecurityViolationException e) {
            parentResult.recordFatalError("Cannot modify object: security violation: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void deleteObject(String oid, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException, SecurityViolationException {
        try {
            this.provisioningService.deleteObject(AccountShadowType.class, oid, null, parentResult);
        }
        catch (ObjectNotFoundException e) {
            parentResult.recordFatalError("Cannot delete object: object not found: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (CommunicationException e) {
            parentResult.recordFatalError("Cannot delete object: communication problem: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SchemaException e) {
            parentResult.recordFatalError("Cannot delete object: schema violation: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ConfigurationException e) {
            parentResult.recordFatalError("Cannot delete object: configuration problem: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SecurityViolationException e) {
            parentResult.recordFatalError("Cannot delete object: security violation: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private QueryType createAccountSearchQuery(ResourceType resource, RefinedAccountDefinition refinedAccountDefinition) throws SchemaException {
        QName objectClass = refinedAccountDefinition.getObjectClassDefinition().getTypeName();
        return QueryUtil.createResourceAndAccountQuery((ResourceType)resource, (QName)objectClass, null);
    }

    public Long heartbeat(Task task) {
        return 0L;
    }

    public void refreshStatus(Task task) {
    }

    public String getCategoryName(Task task) {
        return "Reconciliation";
    }

    public List<String> getCategoryNames() {
        return null;
    }
}

