/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync;

import com.evolveum.midpoint.audit.api.AuditService;
import com.evolveum.midpoint.model.ChangeExecutor;
import com.evolveum.midpoint.model.controller.ModelController;
import com.evolveum.midpoint.model.sync.Action;
import com.evolveum.midpoint.model.sync.ActionManager;
import com.evolveum.midpoint.model.sync.action.BaseAction;
import com.evolveum.midpoint.model.synchronizer.UserSynchronizer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ActionManagerImpl<T extends Action>
implements ActionManager<T> {
    private static transient Trace trace = TraceManager.getTrace(ActionManagerImpl.class);
    private Map<String, Class<T>> actionMap;
    private UserSynchronizer synchronizer;
    private ChangeExecutor changeExecutor;
    private PrismContext prismContext;
    private AuditService auditService;
    @Deprecated
    private ModelController model;

    @Override
    public void setActionMapping(Map<String, Class<T>> actionMap) {
        Validate.notNull(actionMap, (String)"Action mapping must not be null.");
        this.actionMap = actionMap;
    }

    @Override
    public Action getActionInstance(String uri) {
        Validate.notEmpty((String)uri, (String)"Action URI must not be null or empty.");
        Class<T> clazz = this.actionMap.get(uri);
        if (clazz == null) {
            return null;
        }
        Action action = null;
        try {
            action = (Action)clazz.newInstance();
            if (action instanceof BaseAction) {
                BaseAction baseAction = (BaseAction)action;
                baseAction.setSynchronizer(this.synchronizer);
                baseAction.setExecutor(this.changeExecutor);
                baseAction.setPrismContext(this.prismContext);
                baseAction.setAuditService(this.auditService);
                baseAction.setModel(this.model);
            }
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)trace, (String)"Couldn't create action instance", (Throwable)ex, (Object[])new Object[0]);
        }
        return action;
    }

    @Override
    public List<String> getAvailableActions() {
        ArrayList<String> actions = new ArrayList<String>();
        if (this.actionMap != null) {
            actions.addAll((Collection<String>)this.actionMap.keySet());
        }
        return actions;
    }

    public void setSynchronizer(UserSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void setChangeExecutor(ChangeExecutor executor) {
        this.changeExecutor = executor;
    }

    @Deprecated
    public void setModel(ModelController model) {
        this.model = model;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }
}

