/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.security;

import com.evolveum.midpoint.model.security.api.PrincipalUser;
import com.evolveum.midpoint.model.security.api.UserDetailsService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.WSSecurityUtil;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringAuthenticationInjectorInterceptor
implements PhaseInterceptor<SoapMessage> {
    private String phase;
    private Set<String> before = new HashSet<String>();
    private Set<String> after = new HashSet<String>();
    private String id;
    private UserDetailsService userDetailsService;

    public SpringAuthenticationInjectorInterceptor(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
        this.id = this.getClass().getName();
        this.phase = "pre-protocol";
        this.getAfter().add(WSS4JInInterceptor.class.getName());
    }

    public Set<String> getAfter() {
        return this.after;
    }

    public Set<String> getBefore() {
        return this.before;
    }

    public String getId() {
        return this.id;
    }

    public String getPhase() {
        return this.phase;
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    private SOAPMessage getSOAPMessage(SoapMessage msg) {
        SAAJInInterceptor.INSTANCE.handleMessage(msg);
        return (SOAPMessage)msg.getContent(SOAPMessage.class);
    }

    public void handleMessage(SoapMessage message) throws Fault {
        SOAPMessage doc = this.getSOAPMessage(message);
        try {
            String username = "";
            Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)doc.getSOAPPart(), (String)"");
            username = this.getUsernameFromSecurityHeader(securityHeader);
            if (username != null && username.length() > 0) {
                PrincipalUser user = this.userDetailsService.getUser(username);
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getUser(), null);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
        }
        catch (WSSecurityException e) {
            throw new Fault((Throwable)e);
        }
    }

    private String getUsernameFromSecurityHeader(Element securityHeader) {
        String username = "";
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        int i = 0;
        while (i < len) {
            Node elem = list.item(i);
            if (elem.getNodeType() == 1 && "UsernameToken".equals(elem.getLocalName())) {
                NodeList nodes = elem.getChildNodes();
                int len2 = nodes.getLength();
                int j = 0;
                while (j < len2) {
                    Node elem2 = nodes.item(j);
                    if ("Username".equals(elem2.getLocalName())) {
                        username = elem2.getTextContent();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return username;
    }

    public void handleFault(SoapMessage message) {
    }
}

