/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.security;

import com.evolveum.midpoint.common.crypto.EncryptionException;
import com.evolveum.midpoint.common.crypto.Protector;
import com.evolveum.midpoint.model.security.api.PrincipalUser;
import com.evolveum.midpoint.model.security.api.UserDetailsService;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;

public class PasswordCallback
implements CallbackHandler {
    private UserDetailsService userDetailsService;
    private Protector protector;

    public PasswordCallback(UserDetailsService userDetailsService, Protector protector) {
        this.userDetailsService = userDetailsService;
        this.protector = protector;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        WSPasswordCallback pc = (WSPasswordCallback)callbacks[0];
        PrincipalUser user = this.userDetailsService.getUser(pc.getIdentifier());
        UserType userType = user.getUser();
        CredentialsType credentials = userType.getCredentials();
        if (user != null && credentials != null && credentials.getPassword() != null && credentials.getPassword().getProtectedString() != null) {
            try {
                PasswordType password = credentials.getPassword();
                pc.setPassword(this.protector.decryptString(password.getProtectedString()));
            }
            catch (EncryptionException e) {
                throw new IOException(e);
            }
        } else {
            throw new SecurityException("unknown user");
        }
    }
}

