/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.controller;

import com.evolveum.midpoint.audit.api.AuditEventRecord;
import com.evolveum.midpoint.audit.api.AuditEventStage;
import com.evolveum.midpoint.audit.api.AuditEventType;
import com.evolveum.midpoint.audit.api.AuditService;
import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.ChangeExecutor;
import com.evolveum.midpoint.model.ModelObjectResolver;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.api.ModelService;
import com.evolveum.midpoint.model.api.PolicyViolationException;
import com.evolveum.midpoint.model.api.hooks.ChangeHook;
import com.evolveum.midpoint.model.api.hooks.HookOperationMode;
import com.evolveum.midpoint.model.api.hooks.HookRegistry;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure1;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure11;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure13;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure15;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure17;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure19;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure21;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure23;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure25;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure27;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure29;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure3;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure31;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure5;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure7;
import com.evolveum.midpoint.model.controller.ModelController$AjcClosure9;
import com.evolveum.midpoint.model.controller.ModelUtils;
import com.evolveum.midpoint.model.controller.SystemConfigurationHandler;
import com.evolveum.midpoint.model.importer.ImportAccountsFromResourceTaskHandler;
import com.evolveum.midpoint.model.importer.ObjectImporter;
import com.evolveum.midpoint.model.synchronizer.UserSynchronizer;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.repo.cache.RepositoryCache;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ConsistencyViolationException;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ImportOptionsType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorHostType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemObjectsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ModelController
implements ModelService {
    public static final String CLASS_NAME_WITH_DOT;
    public static final String SEARCH_OBJECTS_IN_REPOSITORY;
    public static final String SEARCH_OBJECTS_IN_PROVISIONING;
    public static final String ADD_OBJECT_WITH_EXCLUSION;
    public static final String MODIFY_OBJECT_WITH_EXCLUSION;
    public static final String CHANGE_ACCOUNT;
    public static final String GET_SYSTEM_CONFIGURATION;
    public static final String RESOLVE_USER_ATTRIBUTES;
    public static final String RESOLVE_ACCOUNT_ATTRIBUTES;
    public static final String CREATE_ACCOUNT;
    public static final String UPDATE_ACCOUNT;
    public static final String PROCESS_USER_TEMPLATE;
    private static final Trace LOGGER;
    @Autowired(required=true)
    private UserSynchronizer userSynchronizer;
    @Autowired(required=true)
    PrismContext prismContext;
    @Autowired(required=true)
    private ProvisioningService provisioning;
    @Autowired(required=true)
    private ModelObjectResolver objectResolver;
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    private transient RepositoryService cacheRepositoryService;
    @Autowired
    private ChangeExecutor changeExecutor;
    @Autowired(required=true)
    private transient ImportAccountsFromResourceTaskHandler importAccountsFromResourceTaskHandler;
    @Autowired(required=true)
    private transient ObjectImporter objectImporter;
    @Autowired(required=false)
    private HookRegistry hookRegistry;
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private AuditService auditService;
    @Autowired(required=true)
    SystemConfigurationHandler systemConfigurationHandler;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;

    static {
        ModelController.ajc$preClinit();
        CLASS_NAME_WITH_DOT = String.valueOf(ModelController.class.getName()) + ".";
        SEARCH_OBJECTS_IN_REPOSITORY = String.valueOf(CLASS_NAME_WITH_DOT) + "searchObjectsInRepository";
        SEARCH_OBJECTS_IN_PROVISIONING = String.valueOf(CLASS_NAME_WITH_DOT) + "searchObjectsInProvisioning";
        ADD_OBJECT_WITH_EXCLUSION = String.valueOf(CLASS_NAME_WITH_DOT) + "addObjectWithExclusion";
        MODIFY_OBJECT_WITH_EXCLUSION = String.valueOf(CLASS_NAME_WITH_DOT) + "modifyObjectWithExclusion";
        CHANGE_ACCOUNT = String.valueOf(CLASS_NAME_WITH_DOT) + "changeAccount";
        GET_SYSTEM_CONFIGURATION = String.valueOf(CLASS_NAME_WITH_DOT) + "getSystemConfiguration";
        RESOLVE_USER_ATTRIBUTES = String.valueOf(CLASS_NAME_WITH_DOT) + "resolveUserAttributes";
        RESOLVE_ACCOUNT_ATTRIBUTES = String.valueOf(CLASS_NAME_WITH_DOT) + "resolveAccountAttributes";
        CREATE_ACCOUNT = String.valueOf(CLASS_NAME_WITH_DOT) + "createAccount";
        UPDATE_ACCOUNT = String.valueOf(CLASS_NAME_WITH_DOT) + "updateAccount";
        PROCESS_USER_TEMPLATE = String.valueOf(CLASS_NAME_WITH_DOT) + "processUserTemplate";
        LOGGER = TraceManager.getTrace(ModelController.class);
    }

    public ModelObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public <T extends ObjectType> PrismObject<T> getObject(Class<T> clazz, String oid, Collection<PropertyPath> resolve, Task task, OperationResult result) throws ObjectNotFoundException, SchemaException {
        Class<T> clazz2 = clazz;
        String string = oid;
        Collection<PropertyPath> collection = resolve;
        Task task2 = task;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{clazz2, string, collection, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz2, string, collection, task2, operationResult, joinPoint};
        return (PrismObject)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    protected void resolve(PrismObject<?> object, Collection<PropertyPath> resolve, Task task, OperationResult result) throws SchemaException, ObjectNotFoundException {
        if (object == null || resolve == null) {
            return;
        }
        for (PropertyPath path : resolve) {
            this.resolve(object, path, task, result);
        }
    }

    private void resolve(PrismObject<?> object, PropertyPath path, Task task, OperationResult result) throws SchemaException, ObjectNotFoundException {
        if (path.isEmpty()) {
            return;
        }
        PropertyPathSegment first = path.first();
        PropertyPath rest = path.rest();
        QName refName = first.getName();
        PrismReference reference = object.findReferenceByCompositeObjectElementName(refName);
        if (reference == null) {
            return;
        }
        for (PrismReferenceValue refVal : reference.getValues()) {
            PrismObject<?> refObject = refVal.getObject();
            if (refObject == null) {
                refObject = this.objectResolver.resolve(refVal, object.toString(), result);
                this.updateDefinition(refObject, result);
                refVal.setObject(refObject);
            }
            if (rest.isEmpty()) continue;
            this.resolve(refObject, rest, task, result);
        }
    }

    public <T extends ObjectType> String addObject(PrismObject<T> object, Task task, OperationResult parentResult) throws ObjectAlreadyExistsException, ObjectNotFoundException, SchemaException, ExpressionEvaluationException, CommunicationException, ConfigurationException, PolicyViolationException, SecurityViolationException {
        PrismObject<T> prismObject = object;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{prismObject, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, prismObject, task2, operationResult, joinPoint};
        return (String)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private PrismObject<SystemConfigurationType> getSystemConfiguration(OperationResult result) throws ObjectNotFoundException, SchemaException {
        PrismObject config = this.cacheRepositoryService.getObject(SystemConfigurationType.class, SystemObjectsType.SYSTEM_CONFIGURATION.value(), result);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("System configuration version read from repo: " + config.getVersion());
        }
        return config;
    }

    private HookOperationMode executePreChangePrimary(Collection<ObjectDelta<? extends ObjectType>> objectDeltas, Task task, OperationResult result) {
        HookOperationMode resultMode = HookOperationMode.FOREGROUND;
        if (this.hookRegistry != null) {
            for (ChangeHook hook : this.hookRegistry.getAllChangeHooks()) {
                HookOperationMode mode = hook.preChangePrimary(objectDeltas, task, result);
                if (mode != HookOperationMode.BACKGROUND) continue;
                resultMode = HookOperationMode.BACKGROUND;
            }
        }
        return resultMode;
    }

    private HookOperationMode executePreChangePrimary(ObjectDelta<? extends ObjectType> objectDelta, Task task, OperationResult result) {
        ArrayList<ObjectDelta<? extends ObjectType>> deltas = new ArrayList<ObjectDelta<? extends ObjectType>>();
        deltas.add(objectDelta);
        return this.executePreChangePrimary(deltas, task, result);
    }

    private HookOperationMode executePreChangeSecondary(Collection<ObjectDelta<? extends ObjectType>> objectDeltas, Task task, OperationResult result) {
        HookOperationMode resultMode = HookOperationMode.FOREGROUND;
        if (this.hookRegistry != null) {
            for (ChangeHook hook : this.hookRegistry.getAllChangeHooks()) {
                HookOperationMode mode = hook.preChangeSecondary(objectDeltas, task, result);
                if (mode != HookOperationMode.BACKGROUND) continue;
                resultMode = HookOperationMode.BACKGROUND;
            }
        }
        return resultMode;
    }

    private HookOperationMode executePostChange(Collection<ObjectDelta<? extends ObjectType>> objectDeltas, Task task, OperationResult result) {
        HookOperationMode resultMode = HookOperationMode.FOREGROUND;
        if (this.hookRegistry != null) {
            for (ChangeHook hook : this.hookRegistry.getAllChangeHooks()) {
                HookOperationMode mode = hook.postChange(objectDeltas, task, result);
                if (mode != HookOperationMode.BACKGROUND) continue;
                resultMode = HookOperationMode.BACKGROUND;
            }
        }
        return resultMode;
    }

    private HookOperationMode executePostChange(ObjectDelta<? extends ObjectType> objectDelta, Task task, OperationResult result) {
        ArrayList<ObjectDelta<? extends ObjectType>> deltas = new ArrayList<ObjectDelta<? extends ObjectType>>();
        deltas.add(objectDelta);
        return this.executePostChange(deltas, task, result);
    }

    private SyncContext userTypeAddToContext(PrismObject<UserType> user, OperationResult result) throws SchemaException, ObjectNotFoundException, CommunicationException, ConfigurationException, SecurityViolationException {
        UserType cfr_ignored_0 = (UserType)user.asObjectable();
        SyncContext syncContext = new SyncContext(this.prismContext);
        ObjectDelta userDelta = new ObjectDelta(UserType.class, ChangeType.ADD);
        userDelta.setObjectToAdd(user);
        syncContext.setUserOld(null);
        syncContext.setUserNew(user);
        syncContext.setUserPrimaryDelta((ObjectDelta<UserType>)userDelta);
        return syncContext;
    }

    public <T extends ObjectType> List<PrismObject<T>> listObjects(Class<T> objectType, PagingType paging, Task task, OperationResult result) {
        Class<T> clazz = objectType;
        PagingType pagingType = paging;
        Task task2 = task;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{clazz, pagingType, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, pagingType, task2, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> List<PrismObject<T>> searchObjects(Class<T> type, QueryType query, PagingType paging, Task task, OperationResult result) throws SchemaException, ObjectNotFoundException {
        Class<T> clazz = type;
        QueryType queryType = query;
        PagingType pagingType = paging;
        Task task2 = task;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{clazz, queryType, pagingType, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, queryType, pagingType, task2, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> int countObjects(Class<T> type, QueryType query, Task task, OperationResult parentResult) throws SchemaException, ObjectNotFoundException {
        Class<T> clazz = type;
        QueryType queryType = query;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, queryType, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, queryType, task2, operationResult, joinPoint};
        return Conversions.intValue((Object)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648)));
    }

    public <T extends ObjectType> void modifyObject(Class<T> type, String oid, Collection<? extends ItemDelta> modifications, Task task, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ExpressionEvaluationException, CommunicationException, ConfigurationException, ObjectAlreadyExistsException, PolicyViolationException, SecurityViolationException {
        Class<T> clazz = type;
        String string = oid;
        Collection<? extends ItemDelta> collection = modifications;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, string, collection, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, collection, task2, operationResult, joinPoint};
        MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private void logDebugChange(Class<?> type, String oid, Collection<? extends ItemDelta> modifications) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("model.modifyObject class={}, oid={}, change:\n{}", new Object[]{oid, type.getName(), DebugUtil.debugDump(modifications)});
        }
    }

    private SyncContext userTypeModifyToContext(String oid, Collection<? extends ItemDelta> modifications, OperationResult result) throws SchemaException, ObjectNotFoundException, CommunicationException {
        SyncContext syncContext = new SyncContext(this.prismContext);
        ObjectDelta userDelta = ObjectDelta.createModifyDelta((String)oid, modifications, UserType.class);
        syncContext.setUserOld(null);
        syncContext.setUserNew(null);
        syncContext.setUserPrimaryDelta((ObjectDelta<UserType>)userDelta);
        return syncContext;
    }

    private SyncContext userTypeModifyToContextAssertRecon(String oid, Collection<? extends ItemDelta> modifications, OperationResult result) throws SchemaException, ObjectNotFoundException, CommunicationException {
        SyncContext syncContext = new SyncContext(this.prismContext);
        syncContext.setDoReconciliationForAllAccounts(true);
        ObjectDelta userDelta = ObjectDelta.createModifyDelta((String)oid, modifications, UserType.class);
        syncContext.setUserOld(null);
        syncContext.setUserNew(null);
        syncContext.setUserPrimaryDelta((ObjectDelta<UserType>)userDelta);
        return syncContext;
    }

    private void addAccountToContext(SyncContext syncContext, AccountShadowType accountType, ChangeType changeType, OperationResult result) throws SchemaException, ObjectNotFoundException, CommunicationException, ConfigurationException, SecurityViolationException {
        String resourceOid = ResourceObjectShadowUtil.getResourceOid((ResourceObjectShadowType)accountType);
        if (resourceOid == null) {
            throw new SchemaException("Account shadow does not contain resource OID");
        }
        ResourceType resourceType = (ResourceType)this.provisioning.getObject(ResourceType.class, resourceOid, result).asObjectable();
        RefinedResourceSchema refinedSchema = RefinedResourceSchema.getRefinedSchema((ResourceType)resourceType, (PrismContext)this.prismContext);
        syncContext.rememberResource(resourceType);
        PrismObject refinedAccount = refinedSchema.refine(accountType.asPrismObject());
        ObjectDelta accountDelta = new ObjectDelta(AccountShadowType.class, changeType);
        accountDelta.setObjectToAdd(refinedAccount);
        ResourceAccountType rat = new ResourceAccountType(resourceOid, accountType.getAccountType());
        AccountSyncContext accountSyncContext = syncContext.createAccountSyncContext(rat);
        accountSyncContext.setAccountPrimaryDelta((ObjectDelta<AccountShadowType>)accountDelta);
    }

    public <T extends ObjectType> void deleteObject(Class<T> clazz, String oid, Task task, OperationResult parentResult) throws ObjectNotFoundException, ConsistencyViolationException, CommunicationException, SchemaException, ConfigurationException, PolicyViolationException, SecurityViolationException {
        Class<T> clazz2 = clazz;
        String string = oid;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz2, string, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz2, string, task2, operationResult, joinPoint};
        MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public PrismObject<UserType> listAccountShadowOwner(String accountOid, Task task, OperationResult result) throws ObjectNotFoundException {
        String string = accountOid;
        Task task2 = task;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{string, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, task2, operationResult, joinPoint};
        return (PrismObject)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public <T extends ResourceObjectShadowType> List<PrismObject<T>> listResourceObjectShadows(String resourceOid, Class<T> resourceObjectShadowType, Task task, OperationResult result) throws ObjectNotFoundException {
        String string = resourceOid;
        Class<T> clazz = resourceObjectShadowType;
        Task task2 = task;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{string, clazz, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, clazz, task2, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure17(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public List<PrismObject<? extends ResourceObjectShadowType>> listResourceObjects(String resourceOid, QName objectClass, PagingType paging, Task task, OperationResult result) throws SchemaException, ObjectNotFoundException, CommunicationException {
        String string = resourceOid;
        QName qName = objectClass;
        PagingType pagingType = paging;
        Task task2 = task;
        OperationResult operationResult = result;
        Object[] objectArray = new Object[]{string, qName, pagingType, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, qName, pagingType, task2, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure19(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public OperationResult testResource(String resourceOid, Task task) throws ObjectNotFoundException {
        String string = resourceOid;
        Task task2 = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string, (Object)task2);
        Object[] objectArray = new Object[]{this, string, task2, joinPoint};
        return (OperationResult)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void importAccountsFromResource(String resourceOid, QName objectClass, Task task, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        String string = resourceOid;
        QName qName = objectClass;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{string, qName, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, qName, task2, operationResult, joinPoint};
        MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure23(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public void importObjectsFromFile(File input, ImportOptionsType options, Task task, OperationResult parentResult) {
        File file = input;
        ImportOptionsType importOptionsType = options;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{file, importOptionsType, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, file, importOptionsType, task2, operationResult, joinPoint};
        MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure25(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public void importObjectsFromStream(InputStream input, ImportOptionsType options, Task task, OperationResult parentResult) {
        InputStream inputStream = input;
        ImportOptionsType importOptionsType = options;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{inputStream, importOptionsType, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, inputStream, importOptionsType, task2, operationResult, joinPoint};
        MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure27(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public Set<ConnectorType> discoverConnectors(ConnectorHostType hostType, OperationResult parentResult) throws CommunicationException {
        ConnectorHostType connectorHostType = hostType;
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)connectorHostType, (Object)operationResult);
        Object[] objectArray = new Object[]{this, connectorHostType, operationResult, joinPoint};
        return (Set)MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure29(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void postInit(OperationResult parentResult) {
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)operationResult);
        Object[] objectArray = new Object[]{this, operationResult, joinPoint};
        MidpointAspect.aspectOf().processModelNdc(new ModelController$AjcClosure31(objectArray).linkClosureAndJoinPoint(69648));
    }

    private <T extends ObjectType> void updateDefinitions(Collection<PrismObject<T>> objects, OperationResult result) throws ObjectNotFoundException, SchemaException {
        for (PrismObject<T> object : objects) {
            this.updateDefinition(object, result);
        }
    }

    private <T extends ObjectType> void updateDefinition(PrismObject<T> object, OperationResult result) throws ObjectNotFoundException, SchemaException {
        if (object.canRepresent(AccountShadowType.class)) {
            ResourceType resourceType = this.getResource((ResourceObjectShadowType)((AccountShadowType)object.asObjectable()), result);
            this.updateAccountShadowDefinition(object, resourceType);
        }
    }

    private ResourceType getResource(ResourceObjectShadowType shadowType, OperationResult result) throws ObjectNotFoundException, SchemaException {
        ObjectReferenceType resourceRef = shadowType.getResourceRef();
        return this.objectResolver.resolve(resourceRef, ResourceType.class, "resource reference in " + shadowType, result);
    }

    private <T extends AccountShadowType> void updateAccountShadowDefinition(PrismObject<T> shadow, ResourceType resourceType) throws SchemaException {
        RefinedResourceSchema refinedSchema = RefinedResourceSchema.getRefinedSchema((ResourceType)resourceType, (PrismContext)this.prismContext);
        QName objectClass = ((AccountShadowType)shadow.asObjectable()).getObjectClass();
        RefinedAccountDefinition rAccountDef = refinedSchema.findAccountDefinitionByObjectClass(objectClass);
        PrismContainer attributesContainer = shadow.findContainer(AccountShadowType.F_ATTRIBUTES);
        attributesContainer.applyDefinition((ItemDefinition)rAccountDef, true);
    }

    static final /* synthetic */ PrismObject getObject_aroundBody0(ModelController ajc$this, Class clazz, String oid, Collection resolve, Task task, OperationResult result, JoinPoint joinPoint) {
        Validate.notEmpty((String)oid, (String)"Object oid must not be null or empty.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        Validate.notNull((Object)clazz, (String)"Object class must not be null.");
        RepositoryCache.enter();
        Object object = null;
        try {
            OperationResult subResult = result.createSubresult(ModelService.GET_OBJECT);
            subResult.addParams(new String[]{"oid", "resolve", "class"}, new Object[]{oid, resolve, clazz});
            ObjectReferenceType ref = new ObjectReferenceType();
            ref.setOid(oid);
            ref.setType(ObjectTypes.getObjectType((Class)clazz).getTypeQName());
            object = ajc$this.objectResolver.resolve(ref, clazz, "getObject", subResult);
            ajc$this.updateDefinition(object.asPrismObject(), result);
            ajc$this.resolve(object.asPrismObject(), resolve, task, subResult);
        }
        finally {
            RepositoryCache.exit();
        }
        return object.asPrismObject();
    }

    /*
     * Unable to fully structure code
     */
    static final /* synthetic */ String addObject_aroundBody2(ModelController ajc$this, PrismObject object, Task task, OperationResult parentResult, JoinPoint var4_4) {
        Validate.notNull((Object)object, (String)"Object must not be null.");
        Validate.notNull((Object)parentResult, (String)"Result type must not be null.");
        objectType = (ObjectType)object.asObjectable();
        ajc$this.prismContext.adopt((Objectable)objectType);
        if (!(objectType instanceof ResourceObjectShadowType)) {
            Validate.notEmpty((String)objectType.getName(), (String)"Object name must not be null or empty.");
        }
        result = parentResult.createSubresult(ModelService.ADD_OBJECT);
        result.addParams(new String[]{"object"}, new Object[]{object});
        oid = null;
        auditRecord = new AuditEventRecord(AuditEventType.ADD_OBJECT, AuditEventStage.REQUEST);
        RepositoryCache.enter();
        try {
            block19: {
                auditRecord.setTarget(object);
                objectDelta = new ObjectDelta<UserType>(object.getCompileTimeClass(), ChangeType.ADD);
                if (ModelController.LOGGER.isTraceEnabled()) {
                    ModelController.LOGGER.trace("Entering addObject with {}", (Object)object);
                    ModelController.LOGGER.trace(object.dump());
                }
                if (!(objectType instanceof UserType)) break block19;
                userType = (UserType)objectType;
                syncContext = ajc$this.userTypeAddToContext((PrismObject<UserType>)userType.asPrismObject(), result);
                auditRecord.addDeltas(syncContext.getAllChanges());
                ajc$this.auditService.audit(auditRecord, task);
                objectDelta = syncContext.getUserPrimaryDelta();
                if (ajc$this.executePreChangePrimary(objectDelta, task, result) != HookOperationMode.FOREGROUND) {
                    return null;
                }
                ajc$this.userSynchronizer.synchronizeUser(syncContext, result);
                if (ajc$this.executePreChangeSecondary(syncContext.getAllChanges(), task, result) != HookOperationMode.FOREGROUND) ** continue;
                auditRecord.clearDeltas();
                auditRecord.addDeltas(syncContext.getAllChanges());
                ajc$this.changeExecutor.executeChanges(syncContext, result);
                ajc$this.executePostChange(syncContext.getAllChanges(), task, result);
                ** GOTO lbl46
            }
            auditRecord.addDelta((ObjectDelta)objectDelta);
            ajc$this.auditService.audit(auditRecord, task);
            objectDelta.setObjectToAdd(object);
            if (ajc$this.executePreChangePrimary((ObjectDelta<? extends ObjectType>)objectDelta, task, result) != HookOperationMode.FOREGROUND) {
                return null;
            }
            try {
                ModelController.LOGGER.trace("Executing GENERIC change " + objectDelta);
                ajc$this.changeExecutor.executeChange(objectDelta, result);
                ajc$this.executePostChange(objectDelta, task, result);
lbl46:
                // 2 sources

                oid = objectDelta.getOid();
                result.computeStatus();
            }
            catch (ExpressionEvaluationException ex) {
                result.recordFatalError((Throwable)ex);
                ModelController.LOGGER.error("model.addObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
            catch (SchemaException ex) {
                result.recordFatalError((Throwable)ex);
                ModelController.LOGGER.error("model.addObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
            catch (ObjectNotFoundException ex) {
                result.recordFatalError((Throwable)ex);
                ModelController.LOGGER.error("model.addObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
            catch (ObjectAlreadyExistsException ex) {
                result.recordFatalError((Throwable)ex);
                ModelController.LOGGER.error("model.addObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
            catch (ConfigurationException ex) {
                result.recordFatalError((Throwable)ex);
                ModelController.LOGGER.error("model.addObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
            catch (SecurityViolationException ex) {
                result.recordFatalError((Throwable)ex);
                ModelController.LOGGER.error("model.addObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                result.recordFatalError((Throwable)ex);
                ModelController.LOGGER.error("model.addObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
        }
        finally {
            RepositoryCache.exit();
            auditRecord.setEventStage(AuditEventStage.EXECUTION);
            auditRecord.setResult(result);
            auditRecord.clearTimestamp();
            ajc$this.auditService.audit(auditRecord, task);
        }
        return oid;
    }

    static final /* synthetic */ List listObjects_aroundBody4(ModelController ajc$this, Class objectType, PagingType paging, Task task, OperationResult result, JoinPoint joinPoint) {
        Validate.notNull((Object)objectType, (String)"Object type must not be null.");
        Validate.notNull((Object)result, (String)"Result type must not be null.");
        ModelUtils.validatePaging(paging);
        RepositoryCache.enter();
        ArrayList list = null;
        try {
            if (paging == null) {
                LOGGER.trace("Listing objects of type {} (no paging).", (Object)objectType);
            } else {
                LOGGER.trace("Listing objects of type {} offset {} count {} ordered {} by {}.", new Object[]{objectType, paging.getOffset(), paging.getMaxSize(), paging.getOrderDirection(), paging.getOrderBy()});
            }
            OperationResult subResult = result.createSubresult(ModelService.LIST_OBJECTS);
            subResult.addParams(new String[]{"objectType", "paging"}, new Object[]{objectType, paging});
            try {
                try {
                    if (ObjectTypes.isObjectTypeManagedByProvisioning((Class)objectType)) {
                        LOGGER.trace("Listing objects from provisioning.");
                        list = ajc$this.provisioning.listObjects(objectType, paging, subResult);
                    } else {
                        LOGGER.trace("Listing objects from repository.");
                        list = ajc$this.cacheRepositoryService.listObjects(objectType, paging, subResult);
                    }
                    subResult.computeStatus();
                }
                catch (Exception ex) {
                    LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't list objects", (Throwable)ex, (Object[])new Object[0]);
                    subResult.recordFatalError("Couldn't list objects.", (Throwable)ex);
                    throw new SystemException(ex.getMessage(), (Throwable)ex);
                }
            }
            finally {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(subResult.dump(false));
                }
            }
            if (list == null) {
                list = new ArrayList();
            }
            LOGGER.trace("Returning {} objects.", new Object[]{list.size()});
        }
        finally {
            RepositoryCache.exit();
        }
        return list;
    }

    static final /* synthetic */ List searchObjects_aroundBody6(ModelController ajc$this, Class type, QueryType query, PagingType paging, Task task, OperationResult result, JoinPoint joinPoint) {
        Validate.notNull((Object)type, (String)"Object type must not be null.");
        Validate.notNull((Object)result, (String)"Result type must not be null.");
        ModelUtils.validatePaging(paging);
        RepositoryCache.enter();
        List<Object> list = null;
        try {
            block14: {
                if (paging == null) {
                    LOGGER.trace("Searching objects with null paging (query in TRACE).");
                } else {
                    LOGGER.trace("Searching objects from {} to {} ordered {} by {} (query in TRACE).", new Object[]{paging.getOffset(), paging.getMaxSize(), paging.getOrderDirection(), paging.getOrderBy()});
                }
                boolean searchInProvisioning = ObjectTypes.isClassManagedByProvisioning((Class)type);
                String operationName = searchInProvisioning ? SEARCH_OBJECTS_IN_PROVISIONING : SEARCH_OBJECTS_IN_REPOSITORY;
                OperationResult subResult = result.createSubresult(operationName);
                subResult.addParams(new String[]{"query", "paging", "searchInProvisioning"}, new Object[]{query, paging, searchInProvisioning});
                try {
                    try {
                        list = searchInProvisioning ? ajc$this.provisioning.searchObjects(type, query, paging, subResult) : ajc$this.cacheRepositoryService.searchObjects(type, query, paging, subResult);
                        subResult.recordSuccess();
                    }
                    catch (Exception ex) {
                        String message = !searchInProvisioning ? "Couldn't search objects in repository" : "Couldn't search objects in provisioning";
                        LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)ex, (Object[])new Object[0]);
                        subResult.recordFatalError(message, (Throwable)ex);
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace(subResult.dump(false));
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(subResult.dump(false));
                    }
                    throw throwable;
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(subResult.dump(false));
                }
            }
            if (list == null) {
                list = new ArrayList();
            }
            ajc$this.updateDefinitions(list, result);
        }
        finally {
            RepositoryCache.exit();
        }
        return list;
    }

    static final /* synthetic */ int countObjects_aroundBody8(ModelController ajc$this, Class type, QueryType query, Task task, OperationResult parentResult, JoinPoint joinPoint) {
        try {
            if (ObjectTypes.isObjectTypeManagedByProvisioning((Class)type)) {
                return ajc$this.provisioning.countObjects(type, query, parentResult);
            }
            return ajc$this.cacheRepositoryService.countObjects(type, query, parentResult);
        }
        catch (Exception ex) {
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    static final /* synthetic */ void modifyObject_aroundBody10(ModelController ajc$this, Class type, String oid, Collection modifications, Task task, OperationResult parentResult, JoinPoint joinPoint) {
        block25: {
            Validate.notNull((Object)modifications, (String)"Object modification must not be null.");
            Validate.notEmpty((String)oid, (String)"Change oid must not be null or empty.");
            Validate.notNull((Object)parentResult, (String)"Result type must not be null.");
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Modifying object with oid {}", (Object)oid);
                LOGGER.trace(DebugUtil.debugDump((Collection)modifications));
            }
            if (modifications.isEmpty()) {
                LOGGER.warn("Calling modifyObject with empty modificaiton set");
                return;
            }
            ItemDelta.checkConsistence((Collection)modifications);
            OperationResult result = parentResult.createSubresult(ModelService.MODIFY_OBJECT);
            result.addParams(new String[]{"modifications"}, new Object[]{modifications});
            RepositoryCache.enter();
            AuditEventRecord auditRecord = new AuditEventRecord(AuditEventType.MODIFY_OBJECT, AuditEventStage.REQUEST);
            PrismObject object = null;
            try {
                object = ajc$this.cacheRepositoryService.getObject(type, oid, result);
            }
            catch (ObjectNotFoundException e) {
                result.recordFatalError((Throwable)e);
                RepositoryCache.exit();
                throw e;
            }
            catch (SchemaException e) {
                result.recordFatalError((Throwable)e);
                RepositoryCache.exit();
                throw e;
            }
            catch (RuntimeException e) {
                result.recordFatalError((Throwable)e);
                RepositoryCache.exit();
                throw e;
            }
            try {
                try {
                    auditRecord.setTarget(object);
                    ObjectDelta objectDelta = null;
                    if (UserType.class.isAssignableFrom(type)) {
                        SyncContext syncContext = ajc$this.userTypeModifyToContext(oid, modifications, result);
                        auditRecord.addDeltas(syncContext.getAllChanges());
                        ajc$this.auditService.audit(auditRecord, task);
                        ArrayList<ItemDelta> modificationsCloned = new ArrayList<ItemDelta>();
                        for (ItemDelta delta : modifications) {
                            ItemDelta deltaNew = delta.clone();
                            modificationsCloned.add(deltaNew);
                        }
                        ajc$this.userSynchronizer.synchronizeUser(syncContext, result);
                        auditRecord.clearDeltas();
                        auditRecord.addDeltas(syncContext.getAllChanges());
                        try {
                            ajc$this.changeExecutor.executeChanges(syncContext, result);
                            result.computeStatus();
                            break block25;
                        }
                        catch (ObjectAlreadyExistsException e) {
                            LOGGER.debug("Restarting user synchronizer as a reaction to ObjectAlreadyExistsException", (Throwable)e);
                            syncContext = ajc$this.userTypeModifyToContextAssertRecon(oid, modificationsCloned, result);
                            result = parentResult.createSubresult(ModelService.MODIFY_OBJECT);
                            result.addParam("syncContext", (Object)syncContext);
                            ajc$this.userSynchronizer.synchronizeUser(syncContext, result);
                            try {
                                ajc$this.changeExecutor.executeChanges(syncContext, parentResult);
                                break block25;
                            }
                            catch (ObjectAlreadyExistsException ex) {
                                throw new SystemException(ex.getMessage(), (Throwable)ex);
                            }
                        }
                    }
                    if (AccountShadowType.class.isAssignableFrom(type)) {
                        AccountShadowType shadow = (AccountShadowType)ajc$this.cacheRepositoryService.getObject(type, oid, result).asObjectable();
                        String resourceOid = ResourceObjectShadowUtil.getResourceOid((ResourceObjectShadowType)shadow);
                        ResourceType resource = (ResourceType)ajc$this.provisioning.getObject(ResourceType.class, resourceOid, result).asObjectable();
                        RefinedResourceSchema refinedSchema = RefinedResourceSchema.getRefinedSchema((ResourceType)resource, (PrismContext)ajc$this.prismContext);
                        refinedSchema.getObjectDefinition(shadow);
                    }
                    objectDelta = ObjectDelta.createModifyDelta((String)oid, (Collection)modifications, (Class)type);
                    auditRecord.addDelta(objectDelta);
                    ajc$this.auditService.audit(auditRecord, task);
                    HashSet<ObjectDelta<? extends ObjectType>> changes = new HashSet<ObjectDelta<? extends ObjectType>>();
                    changes.add(objectDelta);
                    try {
                        ajc$this.changeExecutor.executeChanges(changes, parentResult);
                        ajc$this.executePostChange((ObjectDelta<? extends ObjectType>)objectDelta, task, result);
                        result.recordSuccessIfUnknown();
                    }
                    catch (ObjectAlreadyExistsException e) {
                        throw new SystemException(e.getMessage(), (Throwable)e);
                    }
                }
                catch (ExpressionEvaluationException ex) {
                    LOGGER.error("model.modifyObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                    result.recordFatalError((Throwable)ex);
                    throw ex;
                }
                catch (ObjectNotFoundException ex) {
                    LOGGER.error("model.modifyObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                    result.recordFatalError((Throwable)ex);
                    throw ex;
                }
                catch (SchemaException ex) {
                    LOGGER.error("model.modifyObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                    ajc$this.logDebugChange(type, oid, modifications);
                    result.recordFatalError((Throwable)ex);
                    throw ex;
                }
                catch (ConfigurationException ex) {
                    LOGGER.error("model.modifyObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                    ajc$this.logDebugChange(type, oid, modifications);
                    result.recordFatalError((Throwable)ex);
                    throw ex;
                }
                catch (SecurityViolationException ex) {
                    LOGGER.error("model.modifyObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                    ajc$this.logDebugChange(type, oid, modifications);
                    result.recordFatalError((Throwable)ex);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    LOGGER.error("model.modifyObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                    ajc$this.logDebugChange(type, oid, modifications);
                    result.recordFatalError((Throwable)ex);
                    throw ex;
                }
            }
            finally {
                RepositoryCache.exit();
                auditRecord.setEventStage(AuditEventStage.EXECUTION);
                auditRecord.setResult(result);
                auditRecord.clearTimestamp();
                ajc$this.auditService.audit(auditRecord, task);
            }
        }
    }

    static final /* synthetic */ void deleteObject_aroundBody12(ModelController ajc$this, Class clazz, String oid, Task task, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notNull((Object)clazz, (String)"Class must not be null.");
        Validate.notEmpty((String)oid, (String)"Oid must not be null or empty.");
        Validate.notNull((Object)parentResult, (String)"Result type must not be null.");
        OperationResult result = parentResult.createSubresult(ModelService.DELETE_OBJECT);
        result.addParams(new String[]{"oid"}, new Object[]{oid});
        RepositoryCache.enter();
        AuditEventRecord auditRecord = new AuditEventRecord(AuditEventType.DELETE_OBJECT, AuditEventStage.REQUEST);
        PrismObject object = null;
        try {
            object = ajc$this.cacheRepositoryService.getObject(clazz, oid, result);
        }
        catch (ObjectNotFoundException e) {
            result.recordFatalError((Throwable)e);
            RepositoryCache.exit();
            throw e;
        }
        catch (SchemaException e) {
            result.recordFatalError((Throwable)e);
            RepositoryCache.exit();
            throw e;
        }
        catch (RuntimeException e) {
            result.recordFatalError((Throwable)e);
            RepositoryCache.exit();
            throw e;
        }
        try {
            try {
                auditRecord.setTarget(object);
                ObjectDelta objectDelta = new ObjectDelta(clazz, ChangeType.DELETE);
                objectDelta.setOid(oid);
                auditRecord.addDelta(objectDelta);
                ajc$this.auditService.audit(auditRecord, task);
                LOGGER.trace("Deleting object with oid {}.", new Object[]{oid});
                Collection<ObjectDelta<? extends ObjectType>> changes = null;
                if (UserType.class.isAssignableFrom(clazz)) {
                    SyncContext syncContext = new SyncContext(ajc$this.prismContext);
                    syncContext.setUserOld(null);
                    syncContext.setUserNew(null);
                    syncContext.setUserPrimaryDelta((ObjectDelta<UserType>)objectDelta);
                    try {
                        ajc$this.userSynchronizer.synchronizeUser(syncContext, result);
                    }
                    catch (SchemaException e) {
                        throw new SystemException(e.getMessage(), (Throwable)e);
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new SystemException(e.getMessage(), (Throwable)e);
                    }
                    catch (ConfigurationException e) {
                        throw e;
                    }
                    catch (ObjectAlreadyExistsException e) {
                        throw new SystemException(e.getMessage(), (Throwable)e);
                    }
                    changes = syncContext.getAllChanges();
                } else {
                    changes = new HashSet<ObjectDelta<? extends ObjectType>>();
                    changes.add(objectDelta);
                }
                try {
                    ajc$this.changeExecutor.executeChanges(changes, result);
                    ajc$this.executePostChange(changes, task, result);
                    auditRecord.clearDeltas();
                    auditRecord.addDeltas(changes);
                    result.computeStatus();
                }
                catch (ObjectAlreadyExistsException e) {
                    throw new SystemException(e.getMessage(), (Throwable)e);
                }
                catch (SchemaException e) {
                    throw new SystemException(e.getMessage(), (Throwable)e);
                }
            }
            catch (ObjectNotFoundException ex) {
                LOGGER.error("model.deleteObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
            catch (CommunicationException ex) {
                LOGGER.error("model.deleteObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
            catch (SecurityViolationException ex) {
                LOGGER.error("model.deleteObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                LOGGER.error("model.deleteObject failed: {}", (Object)ex.getMessage(), (Object)ex);
                result.recordFatalError((Throwable)ex);
                throw ex;
            }
        }
        finally {
            RepositoryCache.exit();
            auditRecord.setEventStage(AuditEventStage.EXECUTION);
            auditRecord.setResult(result);
            auditRecord.clearTimestamp();
            ajc$this.auditService.audit(auditRecord, task);
        }
    }

    static final /* synthetic */ PrismObject listAccountShadowOwner_aroundBody14(ModelController ajc$this, String accountOid, Task task, OperationResult result, JoinPoint joinPoint) {
        Validate.notEmpty((String)accountOid, (String)"Account oid must not be null or empty.");
        Validate.notNull((Object)result, (String)"Result type must not be null.");
        RepositoryCache.enter();
        PrismObject user = null;
        try {
            LOGGER.trace("Listing account shadow owner for account with oid {}.", new Object[]{accountOid});
            OperationResult subResult = result.createSubresult(ModelService.LIST_ACCOUNT_SHADOW_OWNER);
            subResult.addParams(new String[]{"accountOid"}, new Object[]{accountOid});
            try {
                try {
                    user = ajc$this.cacheRepositoryService.listAccountShadowOwner(accountOid, subResult);
                    subResult.recordSuccess();
                }
                catch (ObjectNotFoundException ex) {
                    LoggingUtils.logException((Trace)LOGGER, (String)"Account with oid {} doesn't exists", (Throwable)ex, (Object[])new Object[]{accountOid});
                    subResult.recordFatalError("Account with oid '" + accountOid + "' doesn't exists", (Throwable)ex);
                    throw ex;
                }
                catch (Exception ex) {
                    LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't list account shadow owner from repository for account with oid {}", (Throwable)ex, (Object[])new Object[]{accountOid});
                    subResult.recordFatalError("Couldn't list account shadow owner for account with oid '" + accountOid + "'.", (Throwable)ex);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(subResult.dump(false));
                    }
                }
            }
            finally {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(subResult.dump(false));
                }
            }
        }
        finally {
            RepositoryCache.exit();
        }
        return user;
    }

    static final /* synthetic */ List listResourceObjectShadows_aroundBody16(ModelController ajc$this, String resourceOid, Class resourceObjectShadowType, Task task, OperationResult result, JoinPoint joinPoint) {
        Validate.notEmpty((String)resourceOid, (String)"Resource oid must not be null or empty.");
        Validate.notNull((Object)result, (String)"Result type must not be null.");
        RepositoryCache.enter();
        ArrayList list = null;
        try {
            block13: {
                LOGGER.trace("Listing resource object shadows \"{}\" for resource with oid {}.", new Object[]{resourceObjectShadowType, resourceOid});
                OperationResult subResult = result.createSubresult(ModelService.LIST_RESOURCE_OBJECT_SHADOWS);
                subResult.addParams(new String[]{"resourceOid", "resourceObjectShadowType"}, new Object[]{resourceOid, resourceObjectShadowType});
                try {
                    try {
                        list = ajc$this.cacheRepositoryService.listResourceObjectShadows(resourceOid, resourceObjectShadowType, subResult);
                        subResult.recordSuccess();
                    }
                    catch (ObjectNotFoundException ex) {
                        subResult.recordFatalError("Resource with oid '" + resourceOid + "' was not found.", (Throwable)ex);
                        RepositoryCache.exit();
                        throw ex;
                    }
                    catch (Exception ex) {
                        LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't list resource object shadows type {} from repository for resource, oid {}", (Throwable)ex, (Object[])new Object[]{resourceObjectShadowType, resourceOid});
                        subResult.recordFatalError("Couldn't list resource object shadows type '" + resourceObjectShadowType + "' from repository for resource, oid '" + resourceOid + "'.", (Throwable)ex);
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace(subResult.dump(false));
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(subResult.dump(false));
                    }
                    throw throwable;
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(subResult.dump(false));
                }
            }
            if (list == null) {
                list = new ArrayList();
            }
        }
        finally {
            RepositoryCache.exit();
        }
        return list;
    }

    static final /* synthetic */ List listResourceObjects_aroundBody18(ModelController ajc$this, String resourceOid, QName objectClass, PagingType paging, Task task, OperationResult result, JoinPoint joinPoint) {
        Validate.notEmpty((String)resourceOid, (String)"Resource oid must not be null or empty.");
        Validate.notNull((Object)objectClass, (String)"Object type must not be null.");
        Validate.notNull((Object)paging, (String)"Paging must not be null.");
        Validate.notNull((Object)result, (String)"Result type must not be null.");
        ModelUtils.validatePaging(paging);
        RepositoryCache.enter();
        ArrayList list = null;
        try {
            LOGGER.trace("Listing resource objects {} from resource, oid {}, from {} to {} ordered {} by {}.", new Object[]{objectClass, resourceOid, paging.getOffset(), paging.getMaxSize(), paging.getOrderDirection(), paging.getOrderDirection()});
            OperationResult subResult = result.createSubresult(ModelService.LIST_RESOURCE_OBJECTS);
            subResult.addParams(new String[]{"resourceOid", "objectType", "paging"}, new Object[]{resourceOid, objectClass, paging});
            try {
                list = ajc$this.provisioning.listResourceObjects(resourceOid, objectClass, paging, subResult);
            }
            catch (SchemaException ex) {
                RepositoryCache.exit();
                subResult.recordFatalError("Schema violation");
                throw ex;
            }
            catch (CommunicationException ex) {
                RepositoryCache.exit();
                subResult.recordFatalError("Communication error");
                throw ex;
            }
            catch (ObjectNotFoundException ex) {
                RepositoryCache.exit();
                subResult.recordFatalError("Object not found");
                throw ex;
            }
            subResult.recordSuccess();
            if (list == null) {
                list = new ArrayList();
            }
        }
        finally {
            RepositoryCache.exit();
        }
        return list;
    }

    static final /* synthetic */ OperationResult testResource_aroundBody20(ModelController ajc$this, String resourceOid, Task task, JoinPoint joinPoint) {
        Validate.notEmpty((String)resourceOid, (String)"Resource oid must not be null or empty.");
        RepositoryCache.enter();
        LOGGER.trace("Testing resource OID: {}", new Object[]{resourceOid});
        OperationResult testResult = null;
        try {
            testResult = ajc$this.provisioning.testResource(resourceOid);
        }
        catch (ObjectNotFoundException ex) {
            LOGGER.error("Error testing resource OID: {}: Object not found: {} ", new Object[]{resourceOid, ex.getMessage(), ex});
            RepositoryCache.exit();
            throw ex;
        }
        catch (SystemException ex) {
            LOGGER.error("Error testing resource OID: {}: Object not found: {} ", new Object[]{resourceOid, ex.getMessage(), ex});
            RepositoryCache.exit();
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Error testing resource OID: {}: {} ", new Object[]{resourceOid, ex.getMessage(), ex});
            RepositoryCache.exit();
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
        if (testResult != null) {
            LOGGER.debug("Finished testing resource OID: {}, result: {} ", (Object)resourceOid, (Object)testResult.getStatus());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Test result:\n{}", (Object)testResult.dump(false));
            }
        } else {
            LOGGER.error("Test resource returned null result");
        }
        RepositoryCache.exit();
        return testResult;
    }

    static final /* synthetic */ void importAccountsFromResource_aroundBody22(ModelController ajc$this, String resourceOid, QName objectClass, Task task, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notEmpty((String)resourceOid, (String)"Resource oid must not be null or empty.");
        Validate.notNull((Object)objectClass, (String)"Object class must not be null.");
        Validate.notNull((Object)task, (String)"Task must not be null.");
        RepositoryCache.enter();
        LOGGER.trace("Launching import from resource with oid {} for object class {}.", new Object[]{resourceOid, objectClass});
        OperationResult result = parentResult.createSubresult(ModelService.IMPORT_ACCOUNTS_FROM_RESOURCE);
        result.addParams(new String[]{"resourceOid", "objectClass", "task"}, new Object[]{resourceOid, objectClass, task});
        ResourceType resource = null;
        try {
            resource = (ResourceType)ajc$this.getObject(ResourceType.class, resourceOid, null, task, result).asObjectable();
        }
        catch (ObjectNotFoundException ex) {
            result.recordFatalError("Object not found");
            RepositoryCache.exit();
            throw ex;
        }
        ajc$this.importAccountsFromResourceTaskHandler.launch(resource, objectClass, task, result);
        if (task.isAsynchronous()) {
            result.recordStatus(OperationResultStatus.IN_PROGRESS, "Task running in background");
        } else {
            result.recordSuccess();
        }
        RepositoryCache.exit();
    }

    static final /* synthetic */ void importObjectsFromFile_aroundBody24(ModelController ajc$this, File input, ImportOptionsType options, Task task, OperationResult parentResult, JoinPoint joinPoint) {
        RepositoryCache.enter();
        RepositoryCache.exit();
        throw new NotImplementedException();
    }

    static final /* synthetic */ void importObjectsFromStream_aroundBody26(ModelController ajc$this, InputStream input, ImportOptionsType options, Task task, OperationResult parentResult, JoinPoint joinPoint) {
        RepositoryCache.enter();
        OperationResult result = parentResult.createSubresult(ModelService.IMPORT_OBJECTS_FROM_STREAM);
        ajc$this.objectImporter.importObjects(input, options, task, result, ajc$this.cacheRepositoryService);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Import result:\n{}", (Object)result.dump());
        }
        RepositoryCache.exit();
    }

    static final /* synthetic */ Set discoverConnectors_aroundBody28(ModelController ajc$this, ConnectorHostType hostType, OperationResult parentResult, JoinPoint joinPoint) {
        Set discoverConnectors;
        RepositoryCache.enter();
        OperationResult result = parentResult.createSubresult(ModelService.DISCOVER_CONNECTORS);
        try {
            discoverConnectors = ajc$this.provisioning.discoverConnectors(hostType, result);
        }
        catch (CommunicationException e) {
            result.recordFatalError(e.getMessage(), (Throwable)e);
            RepositoryCache.exit();
            throw e;
        }
        result.computeStatus("Connector discovery failed");
        RepositoryCache.exit();
        return discoverConnectors;
    }

    static final /* synthetic */ void postInit_aroundBody30(ModelController ajc$this, OperationResult parentResult, JoinPoint joinPoint) {
        RepositoryCache.enter();
        OperationResult result = parentResult.createSubresult(ModelService.POST_INIT);
        result.addContext("implementationClass", ModelController.class);
        try {
            PrismObject<SystemConfigurationType> systemConfiguration = ajc$this.getSystemConfiguration(result);
            ajc$this.systemConfigurationHandler.postInit(systemConfiguration, result);
        }
        catch (ObjectNotFoundException e) {
            String message = "No system configuration found, skipping application of initial system settings";
            LOGGER.error(String.valueOf(message) + ": " + e.getMessage(), (Throwable)e);
            result.recordWarning(message, (Throwable)e);
        }
        catch (SchemaException e) {
            String message = "Schema error in system configuration, skipping application of initial system settings";
            LOGGER.error(String.valueOf(message) + ": " + e.getMessage(), (Throwable)e);
            result.recordWarning(message, (Throwable)e);
        }
        ajc$this.taskManager.postInit(result);
        ajc$this.provisioning.postInit(result);
        if (result.isUnknown()) {
            result.computeStatus();
        }
        RepositoryCache.exit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ModelController.java", ModelController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.Class:java.lang.String:java.util.Collection:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "clazz:oid:resolve:task:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException", "com.evolveum.midpoint.prism.PrismObject"), 185);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addObject", "com.evolveum.midpoint.model.controller.ModelController", "com.evolveum.midpoint.prism.PrismObject:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "object:task:parentResult", "com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException:com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ExpressionEvaluationException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.model.api.PolicyViolationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "java.lang.String"), 249);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testResource", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.String:com.evolveum.midpoint.task.api.Task", "resourceOid:task", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "com.evolveum.midpoint.schema.result.OperationResult"), 1119);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importAccountsFromResource", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.String:javax.xml.namespace.QName:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "resourceOid:objectClass:task:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException", "void"), 1159);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importObjectsFromFile", "com.evolveum.midpoint.model.controller.ModelController", "java.io.File:com.evolveum.midpoint.xml.ns._public.common.api_types_2.ImportOptionsType:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "input:options:task:parentResult", "", "void"), 1197);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importObjectsFromStream", "com.evolveum.midpoint.model.controller.ModelController", "java.io.InputStream:com.evolveum.midpoint.xml.ns._public.common.api_types_2.ImportOptionsType:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "input:options:task:parentResult", "", "void"), 1208);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "discoverConnectors", "com.evolveum.midpoint.model.controller.ModelController", "com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorHostType:com.evolveum.midpoint.schema.result.OperationResult", "hostType:parentResult", "com.evolveum.midpoint.util.exception.CommunicationException", "java.util.Set"), 1230);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "postInit", "com.evolveum.midpoint.model.controller.ModelController", "com.evolveum.midpoint.schema.result.OperationResult", "parentResult", "", "void"), 1255);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listObjects", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.Class:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "objectType:paging:task:result", "", "java.util.List"), 474);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchObjects", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.Class:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "type:query:paging:task:result", "com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectNotFoundException", "java.util.List"), 531);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "countObjects", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.Class:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "type:query:task:parentResult", "com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectNotFoundException", "int"), 593);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "modifyObject", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.Class:java.lang.String:java.util.Collection:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:modifications:task:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ExpressionEvaluationException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException:com.evolveum.midpoint.model.api.PolicyViolationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "void"), 609);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteObject", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.Class:java.lang.String:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "clazz:oid:task:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.ConsistencyViolationException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.model.api.PolicyViolationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "void"), 855);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listAccountShadowOwner", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.String:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "accountOid:task:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "com.evolveum.midpoint.prism.PrismObject"), 969);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listResourceObjectShadows", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.String:java.lang.Class:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "resourceOid:resourceObjectShadowType:task:result", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "java.util.List"), 1010);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listResourceObjects", "com.evolveum.midpoint.model.controller.ModelController", "java.lang.String:javax.xml.namespace.QName:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "resourceOid:objectClass:paging:task:result", "com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException", "java.util.List"), 1061);
    }
}

