/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.ReferenceDelta;
import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ChangeExecutor {
    private static final Trace LOGGER = TraceManager.getTrace(ChangeExecutor.class);
    @Autowired(required=true)
    private transient TaskManager taskManager;
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    private transient RepositoryService cacheRepositoryService;
    @Autowired(required=true)
    private ProvisioningService provisioning;
    @Autowired(required=true)
    private PrismContext prismContext;
    private PrismObjectDefinition<UserType> userDefinition = null;

    @PostConstruct
    private void locateUserDefinition() {
        this.userDefinition = this.prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(UserType.class);
    }

    public void executeChanges(Collection<ObjectDelta<? extends ObjectType>> changes, OperationResult result) throws ObjectAlreadyExistsException, ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        for (ObjectDelta<? extends ObjectType> change : changes) {
            this.executeChange(change, result);
        }
    }

    public void executeChanges(SyncContext syncContext, OperationResult result) throws ObjectAlreadyExistsException, ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        ObjectDelta<UserType> userDelta = syncContext.getUserDelta();
        if (userDelta != null) {
            this.executeChange(userDelta, result);
            syncContext.setUserOid(userDelta.getOid());
        } else {
            LOGGER.trace("Skipping change execute, because user delta is null");
        }
        for (AccountSyncContext accCtx : syncContext.getAccountContexts()) {
            ObjectDelta<AccountShadowType> accDelta = accCtx.getAccountDelta();
            if (accDelta == null || accDelta.isEmpty()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("No change for account " + accCtx.getResourceAccountType());
                    LOGGER.trace("Delta:\n{}", (Object)(accDelta == null ? null : accDelta.dump()));
                }
                accCtx.setOid(this.getOidFromContext(accCtx));
                this.updateAccountLinks(syncContext.getUserNew(), accCtx, result);
                continue;
            }
            this.executeChange(accDelta, result);
            accCtx.setOid(accDelta.getOid());
            this.updateAccountLinks(syncContext.getUserNew(), accCtx, result);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Context after change execution:\n{}", (Object)syncContext.dump(false));
        }
    }

    private String getOidFromContext(AccountSyncContext context) throws SchemaException {
        if (context.getAccountDelta() != null && context.getAccountDelta().getOid() != null) {
            return context.getAccountDelta().getOid();
        }
        if (context.getAccountOld() != null && context.getAccountOld().getOid() != null) {
            return context.getAccountOld().getOid();
        }
        if (context.getAccountSyncDelta() != null && context.getAccountSyncDelta().getOid() != null) {
            return context.getAccountSyncDelta().getOid();
        }
        return null;
    }

    private void updateAccountLinks(PrismObject<UserType> userNew, AccountSyncContext accCtx, OperationResult result) throws ObjectNotFoundException, SchemaException {
        UserType userTypeNew = (UserType)userNew.asObjectable();
        String accountOid = accCtx.getOid();
        if (accountOid == null) {
            throw new IllegalStateException("Account has null OID, this should not happen");
        }
        if (accCtx.getPolicyDecision() == PolicyDecision.UNLINK || accCtx.getPolicyDecision() == PolicyDecision.DELETE) {
            for (ObjectReferenceType accountRef : userTypeNew.getAccountRef()) {
                if (!accountRef.getOid().equals(accountOid)) continue;
                this.unlinkAccount(userTypeNew.getOid(), accountOid, result);
            }
        } else {
            for (ObjectReferenceType accountRef : userTypeNew.getAccountRef()) {
                if (!accountOid.equals(accountRef.getOid())) continue;
                return;
            }
            this.linkAccount(userTypeNew.getOid(), accountOid, result);
        }
    }

    private void linkAccount(String userOid, String accountOid, OperationResult result) throws ObjectNotFoundException, SchemaException {
        LOGGER.trace("Linking account " + accountOid + " to user " + userOid);
        PrismReferenceValue accountRef = new PrismReferenceValue();
        accountRef.setOid(accountOid);
        accountRef.setTargetType(AccountShadowType.COMPLEX_TYPE);
        Collection accountRefDeltas = ReferenceDelta.createModificationAddCollection((QName)UserType.F_ACCOUNT_REF, this.getUserDefinition(), (PrismReferenceValue)accountRef);
        try {
            this.cacheRepositoryService.modifyObject(UserType.class, userOid, accountRefDeltas, result);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    private PrismObjectDefinition<UserType> getUserDefinition() {
        return this.userDefinition;
    }

    private void unlinkAccount(String userOid, String accountOid, OperationResult result) throws ObjectNotFoundException, SchemaException {
        LOGGER.trace("Unlinking account " + accountOid + " to user " + userOid);
        PrismReferenceValue accountRef = new PrismReferenceValue();
        accountRef.setOid(accountOid);
        accountRef.setTargetType(AccountShadowType.COMPLEX_TYPE);
        Collection accountRefDeltas = ReferenceDelta.createModificationDeleteCollection((QName)UserType.F_ACCOUNT_REF, this.getUserDefinition(), (PrismReferenceValue)accountRef);
        try {
            this.cacheRepositoryService.modifyObject(UserType.class, userOid, accountRefDeltas, result);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public <T extends ObjectType> void executeChange(ObjectDelta<T> objectDelta, OperationResult result) throws ObjectAlreadyExistsException, ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        if (objectDelta == null) {
            throw new IllegalArgumentException("Null change");
        }
        if (UserType.class.isAssignableFrom(objectDelta.getObjectTypeClass())) {
            objectDelta.assertDefinitions();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("\n---[ EXECUTE delta of {} {} ]---------------------\n{}\n--------------------------------------------------", new Object[]{objectDelta.getObjectTypeClass().getSimpleName(), objectDelta.getOid(), objectDelta.dump()});
        }
        if (objectDelta.getChangeType() == ChangeType.ADD) {
            this.executeAddition(objectDelta, result);
        } else if (objectDelta.getChangeType() == ChangeType.MODIFY) {
            this.executeModification(objectDelta, result);
        } else if (objectDelta.getChangeType() == ChangeType.DELETE) {
            this.executeDeletion(objectDelta, result);
        }
    }

    private <T extends ObjectType> void executeAddition(ObjectDelta<T> change, OperationResult result) throws ObjectAlreadyExistsException, ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        PrismObject objectToAdd = change.getObjectToAdd();
        if (change.getModifications() != null) {
            for (ItemDelta delta : change.getModifications()) {
                delta.applyTo((PrismContainer)objectToAdd);
            }
            change.getModifications().clear();
        }
        ObjectType objectTypeToAdd = (ObjectType)objectToAdd.asObjectable();
        String oid = null;
        if (objectTypeToAdd instanceof TaskType) {
            oid = this.addTask((TaskType)objectTypeToAdd, result);
        } else if (ObjectTypes.isManagedByProvisioning((ObjectType)objectTypeToAdd)) {
            oid = this.addProvisioningObject((PrismObject<? extends ObjectType>)objectToAdd, result);
            if (oid == null) {
                throw new SystemException("Provisioning addObject returned null OID while adding " + objectToAdd);
            }
            result.addReturn("createdAccountOid", (Object)oid);
        } else {
            oid = this.cacheRepositoryService.addObject(objectToAdd, result);
            if (oid == null) {
                throw new SystemException("Repository addObject returned null OID while adding " + objectToAdd);
            }
        }
        change.setOid(oid);
    }

    private <T extends ObjectType> void executeDeletion(ObjectDelta<T> change, OperationResult result) throws ObjectNotFoundException, ObjectAlreadyExistsException, SchemaException {
        String oid = change.getOid();
        Class objectTypeClass = change.getObjectTypeClass();
        if (TaskType.class.isAssignableFrom(objectTypeClass)) {
            this.taskManager.deleteTask(oid, result);
        } else if (ObjectTypes.isClassManagedByProvisioning((Class)objectTypeClass)) {
            this.deleteProvisioningObject(objectTypeClass, oid, result);
        } else {
            this.cacheRepositoryService.deleteObject(objectTypeClass, oid, result);
        }
    }

    private <T extends ObjectType> void executeModification(ObjectDelta<T> change, OperationResult result) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        if (change.isEmpty()) {
            return;
        }
        change.getOid();
        Class objectTypeClass = change.getObjectTypeClass();
        if (TaskType.class.isAssignableFrom(objectTypeClass)) {
            this.taskManager.modifyTask(change.getOid(), change.getModifications(), result);
        } else if (ObjectTypes.isClassManagedByProvisioning((Class)objectTypeClass)) {
            this.modifyProvisioningObject(objectTypeClass, change.getOid(), change.getModifications(), result);
        } else {
            this.cacheRepositoryService.modifyObject(objectTypeClass, change.getOid(), change.getModifications(), result);
        }
    }

    private String addTask(TaskType task, OperationResult result) throws ObjectAlreadyExistsException, ObjectNotFoundException {
        try {
            return this.taskManager.addTask(task.asPrismObject(), result);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't add object {} to task manager", (Throwable)ex, (Object[])new Object[]{task.getName()});
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String addProvisioningObject(PrismObject<? extends ObjectType> object, OperationResult result) throws ObjectNotFoundException, ObjectAlreadyExistsException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        ResourceObjectShadowType shadow;
        String resourceOid;
        if (object.canRepresent(ResourceObjectShadowType.class) && (resourceOid = ResourceObjectShadowUtil.getResourceOid((ResourceObjectShadowType)(shadow = (ResourceObjectShadowType)object.asObjectable()))) == null) {
            throw new IllegalArgumentException("Resource OID is null in shadow");
        }
        try {
            ScriptsType scripts = this.getScripts((ObjectType)object.asObjectable(), result);
            return this.provisioning.addObject(object, scripts, result);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (ObjectAlreadyExistsException ex) {
            throw ex;
        }
        catch (CommunicationException ex) {
            throw ex;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (RuntimeException ex) {
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void deleteProvisioningObject(Class<? extends ObjectType> objectTypeClass, String oid, OperationResult result) throws ObjectNotFoundException, ObjectAlreadyExistsException, SchemaException {
        try {
            this.provisioning.deleteObject(objectTypeClass, oid, null, result);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void modifyProvisioningObject(Class<? extends ObjectType> objectTypeClass, String oid, Collection<? extends ItemDelta> modifications, OperationResult result) throws ObjectNotFoundException {
        try {
            this.provisioning.modifyObject(objectTypeClass, oid, modifications, null, result);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    private ScriptsType getScripts(ObjectType object, OperationResult result) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        ScriptsType scripts = null;
        if (object instanceof ResourceType) {
            ResourceType resource = (ResourceType)object;
            scripts = resource.getScripts();
        } else if (object instanceof ResourceObjectShadowType) {
            ResourceObjectShadowType resourceObject = (ResourceObjectShadowType)object;
            if (resourceObject.getResource() != null) {
                scripts = resourceObject.getResource().getScripts();
            } else {
                String resourceOid = ResourceObjectShadowUtil.getResourceOid((ResourceObjectShadowType)resourceObject);
                ResourceType resObject = (ResourceType)this.provisioning.getObject(ResourceType.class, resourceOid, result).asObjectable();
                scripts = resObject.getScripts();
            }
        }
        if (scripts == null) {
            scripts = new ScriptsType();
        }
        return scripts;
    }
}

