/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.xquery.XQCancelledException;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQDynamicContext;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQQueryException;
import javax.xml.xquery.XQSequence;
import org.basex.api.xqj.BXQAbstract;
import org.basex.api.xqj.BXQConnection;
import org.basex.api.xqj.BXQException;
import org.basex.api.xqj.BXQItem;
import org.basex.api.xqj.BXQPreparedExpression;
import org.basex.api.xqj.BXQSequence;
import org.basex.api.xqj.BXQStaticContext;
import org.basex.core.ProgressException;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.item.Atm;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.Dbl;
import org.basex.query.item.Dec;
import org.basex.query.item.Flt;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.w3c.dom.Node;

abstract class BXQDynamicContext
extends BXQAbstract
implements XQDynamicContext {
    protected final BXQStaticContext sc;
    protected final QueryProcessor qp;
    private TimeZone zone;

    protected BXQDynamicContext(String qu, BXQStaticContext s, BXQConnection c) {
        super(c);
        this.sc = s;
        this.qp = new QueryProcessor(qu, s.context);
        this.qp.ctx.copy(this.sc.ctx);
    }

    public void bindAtomicValue(QName qn, String v, XQItemType t) throws XQException {
        BXQDynamicContext.valid(t, XQItemType.class);
        this.bind(qn, (Value)new Atm(Token.token((String)BXQDynamicContext.valid(v, String.class).toString())), t);
    }

    public void bindBoolean(QName qn, boolean v, XQItemType it) throws XQException {
        this.bind(qn, (Value)Bln.get((boolean)v), it);
    }

    public void bindByte(QName qn, byte v, XQItemType t) throws XQException {
        this.bind(qn, (Value)Itr.get((long)v, (Type)AtomType.BYT), t);
    }

    public void bindDocument(QName qn, InputStream is, String base, XQItemType t) throws XQException {
        this.bind(qn, (Value)this.createNode(is), t);
    }

    public void bindDocument(QName qn, Reader r, String base, XQItemType t) throws XQException {
        this.bind(qn, (Value)this.createNode(r), t);
    }

    public void bindDocument(QName qn, Source s, XQItemType t) throws XQException {
        this.bind(qn, (Value)this.createNode(s, t), t);
    }

    public void bindDocument(QName qn, String v, String base, XQItemType t) throws XQException {
        BXQDynamicContext.valid(v, String.class);
        this.bind(qn, (Value)this.createNode((IO)new IOContent(Token.token((String)v))), t);
    }

    public void bindDocument(QName qn, XMLStreamReader sr, XQItemType t) throws XQException {
        this.bind(qn, (Value)this.createNode(sr), t);
    }

    public void bindDouble(QName qn, double v, XQItemType t) throws XQException {
        this.bind(qn, (Value)Dbl.get((double)v), t);
    }

    public void bindFloat(QName qn, float v, XQItemType t) throws XQException {
        this.bind(qn, (Value)Flt.get((float)v), t);
    }

    public void bindInt(QName qn, int v, XQItemType t) throws XQException {
        this.bind(qn, (Value)Itr.get((long)v), t);
    }

    public void bindItem(QName qn, XQItem t) throws XQException {
        BXQDynamicContext.valid(t, XQItem.class);
        this.bind(qn, (Value)((BXQItem)t).it, null);
    }

    public void bindLong(QName qn, long v, XQItemType t) throws XQException {
        this.bind(qn, (Value)new Dec(new BigDecimal(v), (Type)AtomType.LNG), t);
    }

    public void bindNode(QName qn, Node v, XQItemType t) throws XQException {
        this.bind(qn, (Value)this.create(v, null), t);
    }

    public void bindObject(QName qn, Object v, XQItemType t) throws XQException {
        this.bind(qn, (Value)this.create(v, null), t);
    }

    public void bindSequence(QName qn, XQSequence s) throws XQException {
        BXQDynamicContext.valid(s, XQSequence.class);
        try {
            this.bind(qn, ((BXQSequence)s).result.finish(), null);
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }

    public void bindShort(QName qn, short v, XQItemType t) throws XQException {
        this.bind(qn, (Value)Itr.get((long)v, (Type)AtomType.SHR), t);
    }

    public void bindString(QName qn, String v, XQItemType t) throws XQException {
        this.bind(qn, (Value)Str.get((Object)BXQDynamicContext.valid(v, String.class)), t);
    }

    public TimeZone getImplicitTimeZone() throws XQException {
        this.opened();
        return this.zone != null ? this.zone : new GregorianCalendar().getTimeZone();
    }

    public void setImplicitTimeZone(TimeZone tz) throws XQException {
        this.opened();
        this.zone = tz;
    }

    private void bind(QName var, Value v, XQItemType t) throws XQException {
        this.opened();
        BXQDynamicContext.valid(var, QName.class);
        Type tt = this.check(v.type, t);
        Value vl = v;
        if (tt != v.type && v instanceof Item) {
            try {
                vl = tt.e((Item)v, this.ctx.ctx, null);
            }
            catch (QueryException ex) {
                throw new BXQException((Exception)((Object)ex));
            }
        }
        try {
            if (var == XQConstants.CONTEXT_ITEM) {
                this.qp.context((Object)vl);
            } else if (this instanceof BXQPreparedExpression) {
                Var vr = this.qp.ctx.vars.get(new QNm(var));
                if (vr == null) {
                    throw new BXQException("Unknown variable %.", var);
                }
                vr.bind(vl, null);
            } else {
                this.qp.bind(var.getLocalPart(), (Object)vl);
            }
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }

    protected final BXQSequence execute() throws XQException {
        this.opened();
        final QueryContext qctx = this.qp.ctx;
        qctx.ns = this.sc.ctx.ns;
        try {
            if (this.sc.timeout != 0) {
                new Thread(){

                    @Override
                    public void run() {
                        Performance.sleep((long)((long)BXQDynamicContext.this.sc.timeout * 1000L));
                        qctx.stop();
                    }
                }.start();
            }
            this.qp.parse();
            qctx.compile();
            Iter iter = qctx.iter();
            if (this.sc.scrollable) {
                iter = iter.finish().cache();
            }
            return new BXQSequence(iter, this, (BXQConnection)this.par);
        }
        catch (QueryException ex) {
            throw new XQQueryException(ex.getMessage(), new QName(ex.code()), ex.line(), ex.col(), -1);
        }
        catch (ProgressException ex) {
            throw new XQCancelledException("Query exceeded timeout.", null, null, -1, -1, -1, null, null, null);
        }
    }

    @Override
    public final void close() throws XQException {
        try {
            if (!this.closed) {
                this.qp.close();
            }
        }
        catch (IOException ex) {
            throw new XQQueryException(ex.getMessage());
        }
        super.close();
    }
}

