/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import org.basex.api.xqj.BXQException;
import org.basex.api.xqj.BXQItem;
import org.basex.api.xqj.BXQItemType;
import org.basex.api.xqj.BXQStaticContext;
import org.basex.api.xqj.XMLStreamWrapper;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.core.cmd.CreateDB;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.func.JavaFunc;
import org.basex.query.item.AtomType;
import org.basex.query.item.DBNode;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.Type;
import org.basex.util.Util;
import org.basex.util.list.ByteList;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

abstract class BXQAbstract {
    protected final BXQAbstract par;
    protected BXQStaticContext ctx;
    protected boolean closed;

    protected BXQAbstract(BXQAbstract p) {
        this.par = p;
        if (this.par != null) {
            this.ctx = p.ctx;
        }
    }

    public void close() throws XQException {
        if (!this.closed) {
            this.ctx.context.close();
        }
        this.closed = true;
    }

    public final boolean isClosed() {
        return this.closed || this.par != null && this.par.isClosed();
    }

    protected final void opened() throws XQException {
        if (this.isClosed()) {
            throw new BXQException(String.valueOf(Util.name((Object)this)) + " has been closed.", new Object[0]);
        }
    }

    protected static final Object valid(Object obj, Class<?> type) throws BXQException {
        if (obj == null) {
            throw new BXQException("% argument must not be null.", Util.name(type));
        }
        return obj;
    }

    protected final Type check(Type e, XQItemType tar) throws XQException {
        this.opened();
        if (tar == null) {
            return e;
        }
        Type t = ((BXQItemType)tar).getType();
        if (e != t && e != AtomType.ATM && (e.node() || t.node())) {
            throw new BXQException("Wrong data type; % expected, % found.", tar, e);
        }
        return t;
    }

    protected final Item create(Object v, XQItemType t) throws XQException {
        BXQAbstract.valid(v, Object.class);
        if (t == null && v instanceof BXQItem) {
            return ((BXQItem)v).it;
        }
        Type e = JavaFunc.type((Object)v);
        if (e == AtomType.JAVA) {
            throw new BXQException("No mapping available for '%'.", Util.name((Object)v));
        }
        try {
            return this.check(e, t).e(v, null);
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }

    protected final byte[] content(Reader r) throws BXQException {
        BXQAbstract.valid(r, XMLReader.class);
        try {
            int i;
            ByteList bl = new ByteList();
            BufferedReader br = new BufferedReader(r);
            while ((i = br.read()) != -1) {
                bl.add(i);
            }
            br.close();
            return bl.toArray();
        }
        catch (IOException ex) {
            throw new BXQException(ex);
        }
    }

    protected final byte[] content(InputStream is) throws BXQException {
        BXQAbstract.valid(is, InputStream.class);
        try {
            int i;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            while ((i = bis.read()) != -1) {
                bos.write(i);
            }
            bis.close();
            return bos.toByteArray();
        }
        catch (IOException ex) {
            throw new BXQException(ex);
        }
    }

    protected final DBNode createNode(Source s, XQItemType it) throws XQException {
        BXQAbstract.valid(s, Source.class);
        this.check((Type)NodeType.DOC, it);
        if (s instanceof SAXSource) {
            return this.createNode((SAXSource)s);
        }
        if (s instanceof StreamSource) {
            StreamSource ss = (StreamSource)s;
            InputStream is = ss.getInputStream();
            if (is != null) {
                return this.createNode(is);
            }
            Reader r = ss.getReader();
            if (r != null) {
                return this.createNode(r);
            }
            return this.createNode(IO.get((String)ss.getSystemId()));
        }
        Util.notimplemented((Object[])new Object[0]);
        return null;
    }

    protected final DBNode createNode(InputStream is) throws XQException {
        BXQAbstract.valid(is, InputStream.class);
        return this.createNode(new SAXSource(new InputSource(is)));
    }

    protected final DBNode createNode(Reader r) throws XQException {
        BXQAbstract.valid(r, Reader.class);
        return this.createNode(new SAXSource(new InputSource(r)));
    }

    private DBNode createNode(SAXSource s) throws XQException {
        this.opened();
        try {
            return this.checkNode(CreateDB.xml((SAXSource)s, (Context)this.ctx.context));
        }
        catch (IOException ex) {
            throw new BXQException(ex);
        }
    }

    protected final DBNode createNode(XMLStreamReader sr) throws XQException {
        this.opened();
        BXQAbstract.valid(sr, XMLStreamReader.class);
        try {
            return this.checkNode(CreateDB.xml((Parser)new XMLStreamWrapper(sr), (Context)this.ctx.context));
        }
        catch (IOException ex) {
            throw new BXQException(ex);
        }
    }

    protected final DBNode createNode(IO io) throws BXQException {
        try {
            return this.checkNode(CreateDB.xml((IO)io, (Context)this.ctx.context));
        }
        catch (IOException ex) {
            throw new BXQException(ex);
        }
    }

    protected final void serialize(Item it, Serializer ser) throws XQException {
        this.opened();
        try {
            if (it.type == NodeType.ATT) {
                throw new BXQException("Cannot serialize top-level attributes.", new Object[0]);
            }
            it.serialize(ser);
        }
        catch (IOException ex) {
            throw new BXQException(ex);
        }
    }

    private DBNode checkNode(Data d) throws BXQException {
        BXQAbstract.valid(d, Data.class);
        return new DBNode(d, 0);
    }
}

