/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class WordnetStemmer
extends Stemmer {
    private static final String PKG = "edu.mit.jwi";
    private static final String PATH = "etc/wndict";
    private static final Constructor<?> CTR;
    private static final Method FIND_STEMS;
    private static final Object DICT;
    private Object stemmer;

    static {
        if (Reflect.available(PKG)) {
            FIND_STEMS = null;
            CTR = null;
            DICT = null;
        } else {
            Class<?> dict = Reflect.find("edu.mit.jwi.Dictionary");
            Class<?> wn = Reflect.find("edu.mit.jwi.morph.WordnetStemmer");
            CTR = Reflect.find(wn, Reflect.find("edu.mit.jwi.IDictionary"));
            FIND_STEMS = Reflect.method(wn, "findStems", String.class);
            DICT = WordnetStemmer.newDict(dict);
        }
    }

    private static Object newDict(Class<?> dct) {
        try {
            Constructor<?> ctr = Reflect.find(dct, URL.class);
            Object dict = Reflect.get(ctr, new URL("file", null, PATH));
            return Reflect.invoke(Reflect.method(dct, "open", new Class[0]), dict, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static boolean available() {
        return DICT != null;
    }

    WordnetStemmer() {
    }

    WordnetStemmer(FTIterator fti) {
        super(fti);
        this.stemmer = Reflect.get(CTR, DICT);
    }

    @Override
    Stemmer get(Language l, FTIterator fti) {
        return new WordnetStemmer(fti);
    }

    @Override
    public boolean supports(Language lang) {
        return lang == Language.EN;
    }

    @Override
    EnumSet<Language> languages() {
        return EnumSet.of(Language.EN);
    }

    @Override
    int prec() {
        return 10;
    }

    @Override
    byte[] stem(byte[] word) {
        List l = (List)Reflect.invoke(FIND_STEMS, this.stemmer, Token.string(word));
        byte[] result = l.size() == 0 ? word : Token.token((String)l.get(0));
        return result.length == 0 ? word : result;
    }
}

