/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.BitSet;
import java.util.NoSuchElementException;
import org.basex.query.QueryException;
import org.basex.query.ft.FTTokens;
import org.basex.util.ft.FTIterator;
import org.basex.util.list.TokenList;

public final class FTBitapSearch {
    private final FTIterator haystack;
    private final FTTokens needles;
    private final TokenComparator cmp;
    private final BitSet[] masks;
    private final int[] sorted;
    private boolean next;
    private int pos;
    private int match;

    public FTBitapSearch(FTIterator h, FTTokens n, TokenComparator c) {
        this.haystack = h;
        this.cmp = c;
        this.needles = n;
        this.sorted = new int[n.size()];
        int count = -1;
        int i = 0;
        while (i < this.sorted.length) {
            if (n.get(i) != null && n.get(i).size() > 0) {
                this.sorted[++count] = i;
            }
            ++i;
        }
        this.masks = new BitSet[++count];
        i = 0;
        while (i < count) {
            int j = i;
            while (j > 0 && n.get(this.sorted[j]).size() > n.get(this.sorted[j - 1]).size()) {
                int t = this.sorted[j];
                this.sorted[j] = this.sorted[j - 1];
                this.sorted[j - 1] = t;
                --j;
            }
            this.masks[i] = new BitSet();
            this.masks[i].set(0);
            ++i;
        }
    }

    public boolean hasNext() throws QueryException {
        if (this.masks.length == 0) {
            return false;
        }
        if (this.next) {
            return this.pos >= 0;
        }
        this.next = true;
        while (this.haystack.hasNext()) {
            byte[] current = this.haystack.nextToken();
            ++this.pos;
            boolean matched = false;
            int i = 0;
            while (i < this.masks.length) {
                int id = this.sorted[i];
                TokenList n = this.needles.get(id);
                BitSet m = this.masks[id];
                int k = n.size();
                while (k >= 1) {
                    m.set(k, m.get(k - 1) && this.cmp.equal(current, n.get(k - 1)));
                    --k;
                }
                if (m.get(n.size()) && !matched) {
                    this.match = id;
                    matched = true;
                }
                ++i;
            }
            if (!matched) continue;
            return true;
        }
        this.pos = -1;
        return false;
    }

    public int next() throws QueryException {
        if (this.hasNext()) {
            this.next = false;
            return this.pos - this.needles.get(this.match).size();
        }
        throw new NoSuchElementException();
    }

    public static interface TokenComparator {
        public boolean equal(byte[] var1, byte[] var2) throws QueryException;
    }
}

