/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.basex.io.IO;
import org.basex.io.out.ArrayOutput;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;

public final class Xslt {
    private static final String S9API = "net.sf.saxon.s9api.";
    private static final Constructor<?> SAXONPROC = Reflect.find(Reflect.find("net.sf.saxon.s9api.Processor"), Boolean.TYPE);
    private static final Constructor<?> SAXONQNAME = Reflect.find(Reflect.find("net.sf.saxon.s9api.QName"), String.class);
    private static final Constructor<?> SAXONVALUE = Reflect.find(Reflect.find("net.sf.saxon.s9api.XdmAtomicValue"), String.class);
    private static final Constructor<?> SAXONSER = Reflect.find(Reflect.find("net.sf.saxon.s9api.Serializer"), OutputStream.class);
    public static final boolean SAXON = SAXONPROC != null;

    public byte[] transform(IO in, IO xsl, TokenObjMap<Object> params) throws Exception {
        return SAXON ? this.transformSaxon(in, xsl, params) : this.transformJava(in, xsl, params);
    }

    private byte[] transformJava(IO in, IO xsl, TokenObjMap<Object> params) throws Exception {
        TransformerFactory tc = TransformerFactory.newInstance();
        Transformer tr = tc.newTransformer(new StreamSource(new ByteArrayInputStream(xsl.content())));
        for (byte[] key : params) {
            tr.setParameter(Token.string(key), params.get(key));
        }
        ArrayOutput ao = new ArrayOutput();
        tr.transform(new StreamSource(new ByteArrayInputStream(in.content())), new StreamResult(ao));
        return ao.toArray();
    }

    private byte[] transformSaxon(IO in, IO xsl, TokenObjMap<Object> params) throws Exception {
        ArrayOutput ao = new ArrayOutput();
        Object xp = Reflect.get(SAXONPROC, true);
        Object xc = Reflect.invoke(xp, "newXsltCompiler", new Object[0]);
        SAXSource xslt = new SAXSource(xsl.inputSource());
        Object xe = Reflect.invoke(xc, "compile", xslt);
        Object xt = Reflect.invoke(xe, "load", new Object[0]);
        Object xb = Reflect.invoke(xp, "newDocumentBuilder", new Object[0]);
        SAXSource input = new SAXSource(in.inputSource());
        Reflect.invoke(xt, "setInitialContextNode", Reflect.invoke(xb, "build", input));
        Object xs = Reflect.get(SAXONSER, ao);
        Reflect.invoke(xt, "setDestination", xs);
        for (byte[] key : params) {
            Object k = Reflect.get(SAXONQNAME, Token.string(key));
            Object v = Reflect.get(SAXONVALUE, params.get(key).toString());
            Reflect.invoke(xt, "setParameter", k, v);
        }
        Reflect.invoke(xt, "transform", new Object[0]);
        Reflect.invoke(xt, "close", new Object[0]);
        return ao.toArray();
    }
}

