/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Token;

public final class Levenshtein {
    private static final int MAX = 50;
    private final int[][] m = new int[52][52];

    public Levenshtein() {
        int i = 0;
        while (i < this.m.length) {
            this.m[0][i] = i;
            this.m[i][0] = i;
            ++i;
        }
    }

    public boolean similar(byte[] token, byte[] sub, int err) {
        int k;
        int sl = 0;
        int tl = 0;
        int s = 0;
        while (s < sub.length) {
            ++sl;
            s += Token.cl(sub, s);
        }
        int t = 0;
        while (t < token.length) {
            ++tl;
            t += Token.cl(token, t);
        }
        if (tl == 0) {
            return false;
        }
        if (sl < 4 || tl > 50 || sl > 50) {
            return sl == tl && this.same(token, sub);
        }
        int n = k = err == 0 ? Math.max(1, sl >> 2) : err;
        return Math.abs(sl - tl) <= k && this.ls(token, tl, sub, sl, k);
    }

    private boolean ls(byte[] tk, int tl, byte[] sb, int sl, int k) {
        int e2 = -1;
        int f2 = -1;
        int t = 0;
        while (t < tl) {
            int e = Token.norm(Token.lc(Token.cp(tk, t)));
            int d = Integer.MAX_VALUE;
            int s = 0;
            while (s < sl) {
                int f = Token.norm(Token.lc(Token.cp(sb, s)));
                int c = this.m(this.m[t][s + 1] + 1, this.m[t + 1][s] + 1, this.m[t][s] + (e == f ? 0 : 1));
                if (e == f2 && f == e2) {
                    c = this.m[t][s];
                }
                this.m[t + 1][s + 1] = c;
                d = Math.min(d, c);
                f2 = f;
                s += Token.cl(sb, s);
            }
            if (d > k) {
                return false;
            }
            e2 = e;
            t += Token.cl(tk, t);
        }
        return this.m[tl][sl] <= k;
    }

    private int m(int a, int b, int c) {
        int d = a < b ? a : b;
        return d < c ? d : c;
    }

    private boolean same(byte[] tk, byte[] sb) {
        int t = 0;
        int s = 0;
        while (t < tk.length && s < sb.length) {
            if (Token.lc(Token.norm(Token.cp(tk, t))) != Token.lc(Token.norm(Token.cp(sb, t)))) {
                return false;
            }
            t += Token.cl(tk, t);
            s += Token.cl(sb, s);
        }
        return true;
    }
}

