/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.io.IO;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class InputParser {
    private static final String FOUND = ", found \"%\"";
    public final String query;
    public final int ql;
    public IO file;
    public int qp;
    public int qm;

    public InputParser(String q) {
        this.query = q;
        this.ql = this.query.length();
    }

    protected final boolean more() {
        return this.qp < this.ql;
    }

    protected final char curr() {
        return this.qp >= this.ql ? (char)'\u0000' : this.query.charAt(this.qp);
    }

    protected final boolean curr(int ch) {
        return this.curr() == ch;
    }

    protected final void mark() {
        this.qm = this.qp;
    }

    protected final char next() {
        return this.qp + 1 >= this.ql ? (char)'\u0000' : this.query.charAt(this.qp + 1);
    }

    protected final char consume() {
        return this.qp >= this.ql ? (char)'\u0000' : this.query.charAt(this.qp++);
    }

    protected final boolean consume(int ch) {
        boolean found;
        boolean bl = found = this.curr() == ch;
        if (found) {
            ++this.qp;
        }
        return found;
    }

    protected final boolean quote(int ch) {
        return ch == 34 || ch == 39;
    }

    protected final boolean consume(String str) {
        int p = this.qp;
        int l = str.length();
        if (p + l > this.ql) {
            return false;
        }
        int s = 0;
        while (s < l) {
            if (this.query.charAt(p++) != str.charAt(s)) {
                return false;
            }
            ++s;
        }
        this.qp = p;
        return true;
    }

    protected final byte[] found() {
        return this.curr() == '\u0000' ? Token.EMPTY : Util.inf(FOUND, Character.valueOf(this.curr()));
    }

    protected final String rest() {
        int e = Math.min(this.ql, this.qp + 15);
        return String.valueOf(this.query.substring(this.qp, e)) + (e == this.ql ? "" : "...");
    }

    public final InputInfo input() {
        return new InputInfo(this);
    }
}

