/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Progress;
import org.basex.core.Text;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.item.Item;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;

final class QueryListener
extends Progress {
    private final Performance perf = new Performance();
    private final QueryProcessor qp;
    private final Context ctx;
    private final PrintOutput out;
    private TokenBuilder info;
    private int hits;
    private XMLSerializer xml;
    private boolean monitored;
    private Iter iter;
    private boolean closed;

    QueryListener(String qu, PrintOutput po, Context c) throws QueryException {
        this.qp = new QueryProcessor(qu, c);
        try {
            this.qp.parse();
        }
        catch (QueryException ex) {
            try {
                this.qp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        this.out = po;
        this.ctx = c;
        this.startTimeout(this.ctx.mprop.num(MainProp.TIMEOUT));
    }

    void bind(String n, String o, String t) throws QueryException {
        this.qp.bind(n, o, t);
    }

    void init() throws IOException, QueryException {
        this.monitored = true;
        this.ctx.register(this.qp.ctx.updating);
        this.xml = this.qp.getSerializer(this.out);
        this.iter = this.qp.iter();
    }

    boolean next() throws IOException, QueryException {
        if (this.xml == null) {
            this.init();
        }
        this.xml.init();
        Item it = this.iter.next();
        if (it == null) {
            return false;
        }
        this.next(it);
        return true;
    }

    void execute() throws IOException, QueryException {
        Item it;
        if (this.xml == null) {
            this.init();
        }
        while ((it = this.iter.next()) != null) {
            this.next(it);
        }
        this.close(false);
    }

    void printInfo() throws IOException {
        this.out.print(this.info());
    }

    byte[] info() {
        this.initInfo();
        return this.info.finish();
    }

    void close(boolean forced) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.xml != null && !forced) {
            this.xml.close();
        }
        this.qp.stopTimeout();
        this.qp.close();
        if (this.monitored) {
            this.ctx.unregister(this.qp.ctx.updating);
        }
        this.initInfo();
        this.closed = true;
    }

    private void next(Item it) throws IOException, QueryException {
        if (this.stopped) {
            Err.SERVERTIME.thrw(null, new Object[0]);
        }
        this.xml.openResult();
        it.serialize(this.xml);
        this.xml.closeResult();
        ++this.hits;
    }

    private void initInfo() {
        if (this.info == null) {
            int up = this.qp.updates();
            this.info = new TokenBuilder();
            this.info.addExt(String.valueOf(Text.QUERYHITS) + "% %" + Text.NL, this.hits, this.hits == 1 ? "Item" : "Items");
            this.info.addExt(String.valueOf(Text.QUERYUPDATED) + "% %" + Text.NL, up, up == 1 ? "Item" : "Items");
            this.info.addExt(String.valueOf(Text.QUERYTOTAL) + "%", this.perf);
        }
    }
}

