/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.io.in.BufferInput;
import org.basex.io.out.ArrayOutput;
import org.basex.server.ClientSession;
import org.basex.server.Query;
import org.basex.server.ServerCmd;

public final class ClientQuery
extends Query {
    private final ClientSession cs;
    private final String id;
    private ArrayOutput next;

    public ClientQuery(String query, ClientSession session) throws BaseXException {
        this.cs = session;
        this.id = this.string(ServerCmd.QUERY, query).toString();
    }

    @Override
    public String info() throws BaseXException {
        return this.string(ServerCmd.INFO, this.id).toString();
    }

    @Override
    public void bind(String n, String v, String t) throws BaseXException {
        this.execute(ServerCmd.BIND, String.valueOf(this.id) + '\u0000' + n + '\u0000' + v + '\u0000' + (t == null ? "" : t));
    }

    @Override
    public String init() throws BaseXException {
        return this.execute(ServerCmd.INIT, this.id);
    }

    @Override
    public String execute() throws BaseXException {
        return this.execute(ServerCmd.EXEC, this.id);
    }

    @Override
    public boolean more() throws BaseXException {
        this.next = this.string(ServerCmd.NEXT, this.id);
        return this.next.size() != 0;
    }

    @Override
    public String next() throws BaseXException {
        if (this.next == null) {
            this.more();
        }
        ArrayOutput ao = this.next;
        this.next = null;
        if (this.cs.out == null) {
            return ao.toString();
        }
        try {
            this.cs.out.write(ao.toArray());
            return null;
        }
        catch (IOException ex) {
            throw new BaseXException(ex);
        }
    }

    @Override
    public String close() throws BaseXException {
        return this.execute(ServerCmd.CLOSE, this.id);
    }

    private String execute(ServerCmd cmd, String arg) throws BaseXException {
        if (this.cs.out == null) {
            return this.string(cmd, arg).toString();
        }
        this.exec(cmd, arg, this.cs.out);
        return null;
    }

    private ArrayOutput string(ServerCmd cmd, String arg) throws BaseXException {
        ArrayOutput ao = new ArrayOutput();
        this.exec(cmd, arg, ao);
        return ao;
    }

    private void exec(ServerCmd cmd, String arg, OutputStream os) throws BaseXException {
        try {
            byte l;
            this.cs.sout.write(cmd.code);
            this.cs.send(arg);
            BufferInput bi = new BufferInput(this.cs.sin);
            while ((l = bi.readByte()) != 0) {
                os.write(l);
            }
            if (!this.cs.ok(bi)) {
                throw new BaseXException(bi.readString(), new Object[0]);
            }
        }
        catch (IOException ex) {
            throw new BaseXException(ex);
        }
    }
}

