/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.http;

import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.Item;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.ItemCache;
import org.basex.query.util.Err;
import org.basex.query.util.http.Request;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.ObjList;

public final class RequestParser {
    private static final byte[] HDR = Token.token("http:header");
    private static final byte[] HDR_NAME = Token.token("name");
    private static final byte[] HDR_VALUE = Token.token("value");
    private static final byte[] MULTIPART = Token.token("http:multipart");
    private static final byte[] BODY = Token.token("http:body");
    private static final byte[] METHOD = Token.token("method");
    private static final byte[] USRNAME = Token.token("username");
    private static final byte[] PASSWD = Token.token("password");
    private static final byte[] SENDAUTH = Token.token("send-authorization");
    private static final byte[] MEDIATYPE = Token.token("media-type");
    private static final byte[] SRC = Token.token("src");
    private static final byte[] TRACE = Token.token("trace");
    private static final byte[] DELETE = Token.token("delete");

    private RequestParser() {
    }

    public static Request parse(ANode request, ItemCache bodies, InputInfo ii) throws QueryException {
        Request r = new Request();
        RequestParser.parseAttrs(request, r.attrs);
        RequestParser.checkRequest(r, ii);
        ANode payload = RequestParser.parseHdrs(request.children(), r.headers);
        byte[] httpMethod = Token.lc(r.attrs.get(METHOD));
        if ((Token.eq(TRACE, httpMethod) || Token.eq(DELETE, httpMethod)) && (payload != null || bodies != null)) {
            Err.REQINV.thrw(ii, "Body not expected for method " + Token.string(httpMethod));
        }
        if (payload != null) {
            if (Token.eq(payload.nname(), BODY)) {
                Item it = null;
                if (bodies != null) {
                    if (bodies.size() != 1L) {
                        Err.REQINV.thrw(ii, "Number of items with request body content differs from number of body descriptors.");
                    }
                    it = bodies.next();
                }
                RequestParser.parseBody(payload, it, r.payloadAttrs, r.bodyContent, ii);
                r.isMultipart = false;
            } else if (Token.eq(payload.nname(), MULTIPART)) {
                int i = 0;
                AxisMoreIter ch = payload.children();
                while (ch.next() != null) {
                    ++i;
                }
                if (bodies != null && bodies.size() != (long)i) {
                    Err.REQINV.thrw(ii, "Number of items with request body content differs from number of body descriptors.");
                }
                RequestParser.parseMultipart(payload, bodies, r.payloadAttrs, r.parts, ii);
                r.isMultipart = true;
            } else {
                Err.REQINV.thrw(ii, new Object[0]);
            }
        }
        return r;
    }

    private static void parseAttrs(ANode element, TokenMap attrs) {
        ANode attr;
        AxisIter elAttrs = element.attributes();
        while ((attr = elAttrs.next()) != null) {
            attrs.add(attr.nname(), attr.atom());
        }
    }

    private static ANode parseHdrs(AxisMoreIter i, TokenMap hdrs) {
        ANode n = null;
        block0: while ((n = i.next()) != null && Token.eq(n.nname(), HDR)) {
            ANode attr;
            AxisIter hdrAttrs = n.attributes();
            byte[] name = null;
            byte[] value = null;
            while ((attr = hdrAttrs.next()) != null) {
                if (Token.eq(attr.nname(), HDR_NAME)) {
                    name = attr.atom();
                }
                if (Token.eq(attr.nname(), HDR_VALUE)) {
                    value = attr.atom();
                }
                if (name == null || name.length == 0 || value == null || value.length == 0) continue;
                hdrs.add(name, value);
                continue block0;
            }
        }
        return n;
    }

    private static void parseBody(ANode body, Item contItem, TokenMap attrs, ItemCache bodyContent, InputInfo ii) throws QueryException {
        RequestParser.parseAttrs(body, attrs);
        RequestParser.checkBody(body, attrs, ii);
        if (attrs.get(SRC) == null) {
            if (contItem == null) {
                ANode n;
                AxisMoreIter i = body.children();
                while ((n = i.next()) != null) {
                    bodyContent.add(n);
                }
            } else {
                bodyContent.add(contItem);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void parseMultipart(ANode multipart, ItemCache contItems, TokenMap attrs, ObjList<Request.Part> parts, InputInfo ii) throws QueryException {
        block3: {
            RequestParser.parseAttrs(multipart, attrs);
            if (attrs.get(RequestParser.MEDIATYPE) == null) {
                Err.REQINV.thrw(ii, new Object[]{"Attribute media-type of http:multipart is mandatory"});
            }
            i = multipart.children();
            if (contItems != null) ** GOTO lbl12
            while ((n = i.next()) != null) {
                parts.add(RequestParser.parsePart(n, null, ii));
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                parts.add(RequestParser.parsePart(n, contItems.next(), ii));
lbl12:
                // 2 sources

                ** while ((n = i.next()) != null)
            }
        }
    }

    private static Request.Part parsePart(ANode part, Item contItem, InputInfo ii) throws QueryException {
        Request.Part p = new Request.Part();
        ANode partBody = RequestParser.parseHdrs(part.children(), p.headers);
        RequestParser.parseBody(partBody, contItem, p.bodyAttrs, p.bodyContent, ii);
        return p;
    }

    private static void checkRequest(Request r, InputInfo ii) throws QueryException {
        byte[] sendAuth;
        if (r.attrs.get(METHOD) == null) {
            Err.REQINV.thrw(ii, "Attribute method is mandatory");
        }
        if ((sendAuth = r.attrs.get(SENDAUTH)) != null && Boolean.parseBoolean(Token.string(sendAuth))) {
            byte[] usrname = r.attrs.get(USRNAME);
            byte[] passwd = r.attrs.get(PASSWD);
            if (usrname == null && passwd != null || usrname != null && passwd == null || usrname == null && passwd == null) {
                Err.REQINV.thrw(ii, "Provided credentials are invalid");
            }
        }
    }

    private static void checkBody(ANode body, TokenMap bodyAttrs, InputInfo ii) throws QueryException {
        if (bodyAttrs.get(MEDIATYPE) == null) {
            Err.REQINV.thrw(ii, "Attribute media-type of http:body is mandatory");
        }
        if (bodyAttrs.get(SRC) != null && (bodyAttrs.size() > 2 || body.children().more())) {
            Err.SRCATTR.thrw(ii, new Object[0]);
        }
    }
}

