/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.Text;
import org.basex.data.ExprInfo;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.item.QNm;
import org.basex.query.util.Var;

public final class VarList
extends ExprInfo {
    public Var[] vars = new Var[8];
    public int size;

    public void set(Var v) {
        int i = this.indexOf(v);
        if (i == -1) {
            this.add(v);
        } else {
            this.vars[i] = v;
        }
    }

    public void add(Var v) {
        if (this.size == this.vars.length) {
            this.vars = Arrays.copyOf(this.vars, this.size << 1);
        }
        this.vars[this.size++] = v;
    }

    public Var get(QNm name) {
        int i = this.size;
        while (i-- > 0) {
            if (!name.eq(this.vars[i].name)) continue;
            return this.vars[i];
        }
        return null;
    }

    public Var get(Var v) {
        int i = this.indexOf(v);
        return i == -1 ? null : this.vars[i];
    }

    private int indexOf(Var v) {
        int s = this.size - 1;
        while (s >= 0) {
            if (v.is(this.vars[s])) {
                return s;
            }
            --s;
        }
        return -1;
    }

    public boolean contains(Var v) {
        return this.indexOf(v) != -1;
    }

    public void check() throws QueryException {
        int i = 0;
        while (i < this.size) {
            this.vars[i].check();
            ++i;
        }
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        if (this.size == 0) {
            return;
        }
        ser.openElement(this, (byte[][])new byte[0][]);
        int i = 0;
        while (i < this.size) {
            this.vars[i].plan(ser);
            ++i;
        }
        ser.closeElement();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.size) {
            sb.append(String.valueOf(i == 0 ? "" : Text.NL) + i + ": " + this.vars[i]);
            ++i;
        }
        return sb.toString();
    }
}

