/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.Uri;
import org.basex.query.path.Test;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class NameTest
extends Test {
    public final InputInfo input;
    public final byte[] ln;

    public NameTest(boolean att, InputInfo ii) {
        this(null, Test.Name.ALL, att, ii);
    }

    public NameTest(QNm nm, Test.Name t, boolean att, InputInfo ii) {
        this.type = att ? NodeType.ATT : NodeType.ELM;
        this.ln = nm != null ? nm.ln() : null;
        this.name = nm;
        this.test = t;
        this.input = ii;
    }

    @Override
    public boolean comp(QueryContext ctx) throws QueryException {
        Data data;
        if (ctx.ns.size() != 0 && this.name != null && !this.name.hasUri()) {
            this.name.uri(ctx.ns.uri(this.name.pref(), false, this.input));
        }
        if ((data = ctx.data()) == null) {
            return true;
        }
        byte[] ns = data.ns.globalNS();
        if (ns == null) {
            return true;
        }
        boolean ok = true;
        if (this.test == Test.Name.STD && !this.name.ns()) {
            boolean bl = ok = this.type == NodeType.ATT || Token.eq(ns, ctx.nsElem);
            if (ok) {
                if (ns.length != 0) {
                    ctx.compInfo("skipping namespace test for \"%\"", new Object[]{this.ln});
                }
                this.test = Test.Name.NAME;
            }
        }
        boolean bl = ok && (this.test != Test.Name.NAME || (this.type == NodeType.ELM ? data.tagindex : data.atnindex).id(this.ln) != 0) ? true : (ok = false);
        if (!ok) {
            ctx.compInfo("removing unknown tag/attribute %", this.name);
        }
        return ok;
    }

    @Override
    public boolean eval(ANode node) {
        if (node.type != this.type) {
            return false;
        }
        switch (this.test) {
            case ALL: {
                return true;
            }
            case NAME: {
                return Token.eq(this.ln, Token.ln(node.nname()));
            }
            case NS: {
                return this.name.uri().eq(node.qname(this.tmpq).uri());
            }
        }
        return this.type == NodeType.ATT && !this.name.ns() ? Token.eq(this.ln, node.nname()) : this.name.eq(node.qname(this.tmpq));
    }

    public String toString() {
        if (this.test == Test.Name.ALL) {
            return "*";
        }
        if (this.test == Test.Name.NAME) {
            return "*:" + Token.string(this.name.atom());
        }
        String uri = this.name.uri() == Uri.EMPTY || this.name.ns() ? "" : "{" + Token.string(this.name.uri().atom()) + "}";
        return String.valueOf(uri) + (this.test == Test.Name.NS ? "*" : Token.string(this.name.atom()));
    }
}

