/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.iter;

import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.RangeSeq;
import org.basex.query.item.Value;
import org.basex.query.iter.ValueIter;

public final class RangeIter
extends ValueIter {
    private final long min;
    private final long max;
    private long pos;

    public RangeIter(long mn, long mx) {
        this.min = mn;
        this.max = mx + 1L;
        this.pos = mn - 1L;
    }

    @Override
    public Item next() {
        ++this.pos;
        return this.pos != this.max ? Itr.get(this.pos) : null;
    }

    @Override
    public long size() {
        return Math.abs(this.max - this.min);
    }

    @Override
    public Item get(long i) {
        return this.min + i >= this.max ? null : Itr.get(this.min + i);
    }

    @Override
    public boolean reset() {
        this.pos = this.min - 1L;
        return true;
    }

    @Override
    public Value finish() {
        return new RangeSeq(this.min, this.max - this.min);
    }

    public String toString() {
        return "(" + this.min + " to " + (this.max - 1L) + ")";
    }
}

