/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item.map;

import org.basex.query.QueryException;
import org.basex.query.func.FNSimple;
import org.basex.query.item.AtomType;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.item.map.Branch;
import org.basex.query.item.map.Leaf;
import org.basex.query.item.map.List;
import org.basex.query.iter.ItemCache;
import org.basex.util.InputInfo;

abstract class TrieNode {
    static final int KIDS = 32;
    static final int MASK = 31;
    static final TrieNode EMPTY = new TrieNode(0){

        @Override
        StringBuilder toString(StringBuilder sb, String ind) {
            return sb.append("map{}");
        }

        @Override
        TrieNode delete(int h, Item k, int l, InputInfo i) {
            return this;
        }

        @Override
        Value get(int h, Item k, int l, InputInfo i) {
            return null;
        }

        @Override
        boolean contains(int h, Item k, int l, InputInfo ii) {
            return false;
        }

        @Override
        TrieNode addAll(TrieNode o, int l, InputInfo ii) {
            return o;
        }

        @Override
        TrieNode add(Leaf o, int l, InputInfo ii) {
            return o;
        }

        @Override
        TrieNode add(List o, int l, InputInfo ii) {
            return o;
        }

        @Override
        TrieNode add(Branch o, int l, InputInfo ii) {
            return o;
        }

        @Override
        boolean verify() {
            return true;
        }

        @Override
        void keys(ItemCache ks) {
        }

        @Override
        boolean hasType(AtomType kt, SeqType vt) {
            return true;
        }

        @Override
        int hash(InputInfo ii) throws QueryException {
            return 0;
        }

        @Override
        boolean deep(InputInfo ii, TrieNode o) {
            return this == o;
        }

        @Override
        public TrieNode insert(int h, Item k, Value v, int l, InputInfo i) throws QueryException {
            return new Leaf(h, k, v);
        }

        @Override
        StringBuilder toString(StringBuilder sb) {
            return sb;
        }
    };
    final int size;

    TrieNode(int s) {
        assert (s != 0 || EMPTY == null);
        this.size = s;
    }

    abstract TrieNode insert(int var1, Item var2, Value var3, int var4, InputInfo var5) throws QueryException;

    abstract TrieNode delete(int var1, Item var2, int var3, InputInfo var4) throws QueryException;

    abstract Value get(int var1, Item var2, int var3, InputInfo var4) throws QueryException;

    abstract boolean contains(int var1, Item var2, int var3, InputInfo var4) throws QueryException;

    abstract TrieNode addAll(TrieNode var1, int var2, InputInfo var3) throws QueryException;

    abstract TrieNode add(Leaf var1, int var2, InputInfo var3) throws QueryException;

    abstract TrieNode add(List var1, int var2, InputInfo var3) throws QueryException;

    abstract TrieNode add(Branch var1, int var2, InputInfo var3) throws QueryException;

    abstract boolean verify();

    abstract void keys(ItemCache var1);

    static final int key(int hash, int lvl) {
        return hash >>> lvl * 5 & 0x1F;
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    abstract StringBuilder toString(StringBuilder var1, String var2);

    abstract boolean hasType(AtomType var1, SeqType var2);

    static final boolean deep(Value a, Value b, InputInfo ii) throws QueryException {
        return a.size() == b.size() && FNSimple.deep(ii, a.iter(), b.iter());
    }

    static final boolean eq(Item a, Item b, InputInfo ii) throws QueryException {
        return a.comparable(b) && a.eq(ii, b);
    }

    abstract int hash(InputInfo var1) throws QueryException;

    abstract boolean deep(InputInfo var1, TrieNode var2) throws QueryException;

    abstract StringBuilder toString(StringBuilder var1);
}

