/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import org.basex.api.dom.BXAttr;
import org.basex.api.dom.BXComm;
import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXElem;
import org.basex.api.dom.BXPI;
import org.basex.api.dom.BXText;
import org.basex.build.MemBuilder;
import org.basex.build.xml.DOMWrapper;
import org.basex.core.Prop;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.AtomType;
import org.basex.query.item.DBNode;
import org.basex.query.item.FAttr;
import org.basex.query.item.FComm;
import org.basex.query.item.FDoc;
import org.basex.query.item.FElem;
import org.basex.query.item.FPI;
import org.basex.query.item.FTxt;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public enum NodeType implements Type
{
    NOD("node", AtomType.ITEM),
    TXT("text", NOD){

        @Override
        public ANode e(Object o, InputInfo ii) {
            return o instanceof BXText ? ((BXText)o).getNod() : new FTxt((Text)o, null);
        }
    }
    ,
    PI("processing-instruction", NOD){

        @Override
        public ANode e(Object o, InputInfo ii) {
            return o instanceof BXPI ? ((BXPI)o).getNod() : new FPI((ProcessingInstruction)o, null);
        }
    }
    ,
    ELM("element", NOD){

        @Override
        public ANode e(Object o, InputInfo ii) {
            return o instanceof BXElem ? ((BXElem)o).getNod() : new FElem((Element)o, null, new TokenMap());
        }
    }
    ,
    DOC("document-node", NOD){

        @Override
        public ANode e(Object o, InputInfo ii) throws QueryException {
            String bu;
            DocumentFragment df;
            if (o instanceof BXDoc) {
                return ((BXDoc)o).getNod();
            }
            if (o instanceof Document) {
                try {
                    DOMWrapper p = new DOMWrapper((Document)o, "");
                    return new DBNode(MemBuilder.build(p, new Prop()), 0);
                }
                catch (IOException ex) {
                    Err.UNDOC.thrw(ii, ex);
                }
            }
            return new FDoc(df, (bu = (df = (DocumentFragment)o).getBaseURI()) != null ? Token.token(bu) : Token.EMPTY);
        }
    }
    ,
    DEL("document-node(...)", NOD),
    ATT("attribute", NOD){

        @Override
        public ANode e(Object o, InputInfo ii) {
            return o instanceof BXAttr ? ((BXAttr)o).getNod() : new FAttr((Attr)o, null);
        }
    }
    ,
    COM("comment", NOD){

        @Override
        public ANode e(Object o, InputInfo ii) {
            return o instanceof BXComm ? ((BXComm)o).getNod() : new FComm((Comment)o, null);
        }
    };

    private final byte[] nam;
    private final Type par;
    private SeqType seq;

    @Override
    public final boolean node() {
        return true;
    }

    @Override
    public boolean dat() {
        return false;
    }

    @Override
    public boolean dur() {
        return false;
    }

    @Override
    public boolean num() {
        return false;
    }

    @Override
    public boolean str() {
        return false;
    }

    @Override
    public boolean unt() {
        return true;
    }

    @Override
    public final boolean func() {
        return false;
    }

    @Override
    public final boolean map() {
        return false;
    }

    @Override
    public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
        return it.type != this ? this.error(it, ii) : it;
    }

    @Override
    public Item e(Object o, InputInfo ii) throws QueryException {
        Util.notexpected(o);
        return null;
    }

    private NodeType(String nm, Type pr) {
        this.nam = Token.token(nm);
        this.par = pr;
    }

    @Override
    public SeqType seq() {
        if (this.seq == null) {
            this.seq = new SeqType(this);
        }
        return this.seq;
    }

    Item error(Item it, InputInfo ii) throws QueryException {
        Err.cast(ii, this, it);
        return null;
    }

    @Override
    public final boolean instance(Type t) {
        return this == t || this.par != null && this.par.instance(t);
    }

    public static NodeType find(QNm type) {
        byte[] ln = type.ln();
        byte[] uri = type.uri().atom();
        NodeType[] nodeTypeArray = NodeType.values();
        int n = nodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeType t = nodeTypeArray[n2];
            if (Token.eq(ln, t.nam) && Token.eq(uri, Token.EMPTY)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(Token.string(this.nam)) + "()";
    }

    @Override
    public byte[] nam() {
        return this.nam;
    }

    /* synthetic */ NodeType(String string, int n, String string2, Type type, NodeType nodeType) {
        this(string2, type);
    }
}

