/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryText;
import org.basex.query.item.ANode;
import org.basex.query.item.FAttr;
import org.basex.query.item.FComm;
import org.basex.query.item.FNode;
import org.basex.query.item.FPI;
import org.basex.query.item.FTxt;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.iter.NodeCache;
import org.basex.query.util.NSGlobal;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class FElem
extends FNode {
    private final Atts ns;
    private final QNm name;
    private byte[] base;

    public FElem(QNm n, ANode p) {
        this(n, null, null, null, null, p);
    }

    public FElem(QNm n, byte[] p, byte[] u) {
        this(n, null, null, null, new Atts().add(p, u), null);
    }

    public FElem(QNm n, NodeCache ch, NodeCache at, byte[] b, Atts nsp, ANode p) {
        super(NodeType.ELM);
        this.name = n;
        this.children = ch == null ? new NodeCache() : ch;
        this.atts = at == null ? new NodeCache() : at;
        this.base = b == null ? Token.EMPTY : b;
        this.ns = nsp == null ? new Atts() : nsp;
        this.par = p;
    }

    FElem(Element elem, ANode p, TokenMap nss) {
        super(NodeType.ELM);
        Object uri;
        String nu = elem.getNamespaceURI();
        this.name = new QNm(Token.token(elem.getNodeName()), nu == null ? Token.EMPTY : Token.token(nu));
        this.par = p;
        String b = elem.getBaseURI();
        this.base = b == null ? Token.EMPTY : Token.token(b);
        this.ns = new Atts();
        NamedNodeMap at = elem.getAttributes();
        int as = at.getLength();
        ANode[] attArr = new ANode[as];
        int pos = 0;
        int i = 0;
        while (i < as) {
            Attr att = (Attr)at.item(i);
            byte[] nm = Token.token(att.getName());
            uri = Token.token(att.getValue());
            if (Token.eq(nm, Token.XMLNS)) {
                this.ns.add(Token.EMPTY, (byte[])uri);
            } else if (Token.startsWith(nm, Token.XMLNSC)) {
                this.ns.add(Token.ln(nm), (byte[])uri);
            } else {
                attArr[pos++] = new FAttr(att, this);
            }
            ++i;
        }
        this.atts = new NodeCache(attArr, pos);
        i = 0;
        while (i < this.ns.size) {
            nss.add(this.ns.key[i], this.ns.val[i]);
            ++i;
        }
        if (p == null) {
            FElem.nsScope(elem.getParentNode(), nss);
            byte[][] byArray = nss.keys();
            uri = byArray;
            int nm = byArray.length;
            int att = 0;
            while (att < nm) {
                byte key = uri[att];
                if (!this.ns.contains((byte[])key)) {
                    this.ns.add((byte[])key, nss.get((byte[])key));
                }
                ++att;
            }
        }
        byte[] pref = this.name.pref();
        byte[] uri2 = this.name.uri().atom();
        byte[] old = nss.get(pref);
        if (old == null || !Token.eq(uri2, old)) {
            this.ns.add(pref, uri2);
            nss.add(pref, uri2);
        }
        NodeList ch = elem.getChildNodes();
        int s = ch.getLength();
        ANode[] childArr = new ANode[s];
        this.children = new NodeCache(childArr, childArr.length);
        int i2 = 0;
        while (i2 < ch.getLength()) {
            Node child = ch.item(i2);
            switch (child.getNodeType()) {
                case 3: {
                    childArr[i2] = new FTxt((Text)child, (ANode)this);
                    break;
                }
                case 8: {
                    childArr[i2] = new FComm((Comment)child, (ANode)this);
                    break;
                }
                case 7: {
                    childArr[i2] = new FPI((ProcessingInstruction)child, this);
                    break;
                }
                case 1: {
                    childArr[i2] = new FElem((Element)child, this, nss);
                    break;
                }
            }
            ++i2;
        }
    }

    private static void nsScope(Node elem, TokenMap nss) {
        Node n = elem;
        while (n != null && n instanceof Element) {
            NamedNodeMap atts = n.getAttributes();
            byte[] pre = Token.token(n.getPrefix());
            if (nss.get(pre) != null) {
                nss.add(pre, Token.token(n.getNamespaceURI()));
            }
            int i = 0;
            int len = atts.getLength();
            while (i < len) {
                byte[] ln;
                Attr a = (Attr)atts.item(i);
                byte[] name = Token.token(a.getName());
                byte[] val = Token.token(a.getValue());
                if (Token.eq(name, Token.XMLNS)) {
                    if (nss.get(Token.EMPTY) == null) {
                        nss.add(Token.EMPTY, val);
                    }
                } else if (Token.startsWith(name, Token.XMLNS) && nss.get(ln = Token.ln(name)) == null) {
                    nss.add(ln, val);
                }
                ++i;
            }
            n = n.getParentNode();
        }
    }

    @Override
    public byte[] base() {
        return this.base;
    }

    public void base(byte[] b) {
        this.base = b;
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] nname() {
        return this.name.atom();
    }

    @Override
    public Atts ns() {
        return this.ns;
    }

    @Override
    public void serialize(Serializer ser) throws IOException {
        byte[] tag = this.name.atom();
        ser.openElement(tag, (byte[][])new byte[0][]);
        if (this.name.hasUri()) {
            ser.namespace(this.name.pref(), this.name.uri().atom());
        }
        if (ser.level() == 1) {
            Atts nns = this.nsScope();
            int a = 0;
            while (a < nns.size) {
                ser.namespace(nns.key[a], nns.val[a]);
                ++a;
            }
        } else if (this.ns != null) {
            int p = this.ns.size - 1;
            while (p >= 0) {
                ser.namespace(this.ns.key[p], this.ns.val[p]);
                --p;
            }
        }
        int n = 0;
        while ((long)n < this.atts.size()) {
            ANode node = this.atts.get(n);
            QNm atn = node.qname();
            if (atn.ns() && !NSGlobal.standard(atn.uri().atom())) {
                ser.namespace(atn.pref(), atn.uri().atom());
            }
            ser.attribute(atn.atom(), node.atom());
            ++n;
        }
        n = 0;
        while ((long)n < this.children.size()) {
            this.children.get(n).serialize(ser);
            ++n;
        }
        ser.closeElement();
    }

    @Override
    public FElem copy() {
        NodeCache ch = new NodeCache();
        NodeCache at = new NodeCache();
        FElem node = new FElem(this.name, ch, at, this.base, this.ns, this.par);
        int c = 0;
        while ((long)c < this.children.size()) {
            ch.add(this.children.get(c).copy());
            ch.get(c).parent(node);
            ++c;
        }
        c = 0;
        while ((long)c < this.atts.size()) {
            at.add(this.atts.get(c).copy());
            at.get(c).parent(node);
            ++c;
        }
        return node;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.emptyElement(this, (byte[][])new byte[][]{QueryText.NAM, this.name.atom()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("<");
        sb.append(Token.string(this.name.atom()));
        if (this.atts.size() != 0L || this.ns != null && this.ns.size != 0 || this.children.size() != 0L) {
            sb.append(" ...");
        }
        return sb.append("/>").toString();
    }
}

