/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.AtomType;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Uri;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;

public final class FNQName
extends FuncCall {
    public FNQName(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case INSCOPE: {
                return this.inscope(ctx, (ANode)this.checkType(this.expr[0].item(ctx, this.input), NodeType.ELM));
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.expr[0].item(ctx, this.input);
        Item it2 = this.expr.length == 2 ? this.expr[1].item(ctx, this.input) : null;
        switch (this.def) {
            case RESQNAME: {
                return it == null ? null : this.resolve(ctx, it, this.checkEmpty(it2));
            }
            case QNAME: {
                QNm nm;
                byte[] str;
                byte[] uri = it == null ? Token.EMPTY : this.checkType(it, AtomType.STR).atom(this.input);
                Str it3 = it2 == null ? Str.ZERO : this.checkType(it2, AtomType.STR);
                byte[] atm = ((Item)it3).atom(this.input);
                byte[] byArray = str = !Token.contains(atm, 58) && Token.eq(uri, QueryText.XMLURI) ? Token.concat(Token.XMLC, atm) : atm;
                if (!XMLToken.isQName(str)) {
                    Err.value(this.input, AtomType.QNM, it3);
                }
                if ((nm = new QNm(str, uri)).ns() && uri.length == 0) {
                    Err.value(this.input, AtomType.URI, nm.uri());
                }
                return nm;
            }
            case LOCNAMEQNAME: {
                if (it == null) {
                    return null;
                }
                QNm nm = (QNm)this.checkType(it, AtomType.QNM);
                return AtomType.NCN.e(Str.get(nm.ln()), ctx, this.input);
            }
            case PREQNAME: {
                if (it == null) {
                    return null;
                }
                QNm nm = (QNm)this.checkType(it, AtomType.QNM);
                return !nm.ns() ? null : AtomType.NCN.e(Str.get(nm.pref()), ctx, this.input);
            }
            case NSURIPRE: {
                byte[] pre = this.checkEStr(it);
                ANode an = (ANode)this.checkType(it2, NodeType.ELM);
                boolean copied = ctx.copiedNods.contains(an.data());
                Atts at = an.nsScope(!copied || ctx.nsInherit);
                int i = at != null ? at.get(pre) : -1;
                return i != -1 ? Uri.uri(at.val[i]) : null;
            }
            case RESURI: {
                Uri base;
                if (it == null) {
                    return null;
                }
                Uri rel = Uri.uri(this.checkEStr(it));
                if (!rel.valid()) {
                    Err.URIINV.thrw(this.input, it);
                }
                Uri uri = base = it2 == null ? ctx.baseURI : Uri.uri(this.checkEStr(it2));
                if (!base.valid()) {
                    Err.URIINV.thrw(this.input, base);
                }
                return base.resolve(rel);
            }
        }
        return super.item(ctx, ii);
    }

    private Item resolve(QueryContext ctx, Item q, Item it) throws QueryException {
        byte[] name = Token.trim(this.checkEStr(q));
        if (!XMLToken.isQName(name)) {
            Err.value(this.input, AtomType.QNM, q);
        }
        QNm nm = new QNm(name);
        byte[] pref = nm.pref();
        byte[] uri = ((ANode)this.checkType(it, NodeType.ELM)).uri(pref, ctx);
        if (uri == null) {
            Err.NSDECL.thrw(this.input, new Object[]{pref});
        }
        nm.uri(uri);
        return nm;
    }

    private Iter inscope(QueryContext ctx, ANode node) {
        Atts at;
        TokenSet pref = new TokenSet(new byte[][]{Token.XML});
        byte[] emp = null;
        ANode n = node;
        while ((at = n.ns()) != null) {
            QNm nm;
            if (n != node || ctx.nsPreserve) {
                int a = 0;
                while (a < at.size) {
                    byte[] pre = at.key[a];
                    if (pre.length == 0) {
                        if (emp == null) {
                            emp = at.val[a];
                        }
                    } else {
                        pref.add(pre);
                    }
                    ++a;
                }
            }
            if (emp == null && !(nm = n.qname()).ns()) {
                emp = nm.uri().atom();
            }
            if ((n = n.parent()) != null && ctx.nsInherit) continue;
        }
        if (emp == null) {
            emp = ctx.nsElem;
        }
        if (emp.length != 0) {
            pref.add(Token.EMPTY);
        }
        ItemCache ic = new ItemCache(pref.size());
        byte[][] byArray = pref.keys();
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte[] t = byArray[n3];
            ic.add(Str.get(t));
            ++n3;
        }
        return ic;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX && this.def == Function.INSCOPE || super.uses(u);
    }
}

