/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.Bln;
import org.basex.query.item.Item;
import org.basex.query.item.Value;
import org.basex.query.item.map.Map;
import org.basex.query.iter.Iter;
import org.basex.util.InputInfo;

public final class FNMap
extends FuncCall {
    public FNMap(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case MAPGET: {
                return this.get(ctx).iter();
            }
            case MAPKEYS: {
                return this.getMap(ctx).keys().iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case MAPGET: {
                return this.get(ctx);
            }
            case MAPKEYS: {
                return this.getMap(ctx).keys();
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case MAPNEW: {
                return this.newMap(ctx, ii);
            }
            case MAPENTRY: {
                return this.entry(ctx, ii);
            }
            case MAPCONT: {
                return this.contains(ctx, ii);
            }
            case MAPSIZE: {
                return this.getMap(ctx).mapSize();
            }
            case MAPREM: {
                return this.remove(ctx, ii);
            }
            case MAPCOLL: {
                return this.getMap(ctx).collation();
            }
        }
        return super.item(ctx, ii);
    }

    private Map remove(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.getMap(ctx).delete(this.expr[1].item(ctx, ii), ii);
    }

    private Map entry(QueryContext ctx, InputInfo ii) throws QueryException {
        return Map.entry(this.expr[0].item(ctx, ii), this.expr[1].value(ctx), ii);
    }

    private Map newMap(QueryContext ctx, InputInfo ii) throws QueryException {
        Item m;
        if (this.expr.length == 0) {
            return Map.EMPTY;
        }
        if (this.expr.length == 2) {
            this.checkColl(this.expr[1], ctx);
        }
        Map map = Map.EMPTY;
        Iter maps = this.expr[0].iter(ctx);
        while ((m = maps.next()) != null) {
            map = map.addAll(this.checkMap(m), ii);
        }
        return map;
    }

    private Value get(QueryContext ctx) throws QueryException {
        return this.getMap(ctx).get(this.expr[1].item(ctx, this.input), this.input);
    }

    private Bln contains(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.getMap(ctx).contains(this.expr[1].item(ctx, ii), ii);
    }

    private Map getMap(QueryContext ctx) throws QueryException {
        return this.checkMap(this.checkItem(this.expr[0], ctx));
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 || super.uses(u);
    }
}

