/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.Bln;
import org.basex.query.item.FNode;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeCache;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class FNId
extends FuncCall {
    public FNId(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Item it = this.checkEmpty((this.expr.length == 2 ? this.expr[1] : this.checkCtx(ctx)).item(ctx, this.input));
        ANode node = this.checkNode(it);
        switch (this.def) {
            case ID: {
                return this.id(ctx.iter(this.expr[0]), node);
            }
            case IDREF: {
                return this.idref(ctx.iter(this.expr[0]), node);
            }
            case ELID: {
                return this.elid(ctx.iter(this.expr[0]), node);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.checkEmpty((this.expr.length == 2 ? this.expr[1] : this.checkCtx(ctx)).item(ctx, this.input));
        switch (this.def) {
            case LANG: {
                return this.lang(Token.lc(this.checkEStr(this.expr[0], ctx)), this.checkNode(it));
            }
        }
        return super.item(ctx, ii);
    }

    private Iter elid(Iter it, ANode node) throws QueryException {
        ANode n;
        NodeCache nc = this.id(it, node);
        NodeCache res = new NodeCache().random();
        while ((n = nc.next()) != null) {
            res.add(n.parent());
        }
        return res;
    }

    private NodeCache id(Iter it, ANode node) throws QueryException {
        NodeCache nc = new NodeCache().random();
        this.add(this.ids(it), nc, this.checkRoot(node));
        return nc;
    }

    private Iter idref(Iter it, ANode node) throws QueryException {
        NodeCache nb = new NodeCache().random();
        this.addRef(this.ids(it), nb, this.checkRoot(node));
        return nb;
    }

    private Bln lang(byte[] lang, ANode node) throws QueryException {
        ANode n = node;
        while (n != null) {
            ANode at;
            AxisIter atts = n.attributes();
            while ((at = atts.next()) != null) {
                if (!Token.eq(at.qname().atom(), QueryText.LANG)) continue;
                byte[] ln = Token.lc(Token.norm(this.checkEStr(at)));
                return Bln.get(Token.startsWith(ln, lang) && (lang.length == ln.length || ln[lang.length] == 45));
            }
            n = n.parent();
        }
        return Bln.FALSE;
    }

    private byte[][] ids(Iter iter) throws QueryException {
        Item id;
        TokenList tl = new TokenList();
        while ((id = iter.next()) != null) {
            byte[][] byArray = Token.split(Token.norm(this.checkEStr(id)), 32);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] i = byArray[n2];
                tl.add(i);
                ++n2;
            }
        }
        return tl.toArray();
    }

    private void add(byte[][] ids, NodeCache nc, ANode node) throws QueryException {
        ANode att;
        AxisIter ai = node.attributes();
        while ((att = ai.next()) != null) {
            byte[][] byArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] nm;
                byte[] id = byArray[n2];
                if (Token.eq(this.checkEStr(att), id) && Token.contains(nm = Token.lc(att.qname().atom()), QueryText.ID) && !Token.contains(nm, QueryText.IDREF)) {
                    nc.add(node);
                }
                ++n2;
            }
        }
        ai = node.children();
        while ((att = ai.next()) != null) {
            this.add(ids, nc, att.finish());
        }
    }

    private void addRef(byte[][] ids, NodeCache nc, ANode node) throws QueryException {
        ANode att;
        AxisIter ai = node.attributes();
        while ((att = ai.next()) != null) {
            byte[][] byArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] nm;
                byte[] id = byArray[n2];
                if (Token.eq(this.checkEStr(att), id) && Token.contains(nm = Token.lc(att.qname().atom()), QueryText.IDREF)) {
                    nc.add(att.finish());
                }
                ++n2;
            }
        }
        ai = node.children();
        while ((att = ai.next()) != null) {
            this.addRef(ids, nc, att.finish());
        }
    }

    private ANode checkRoot(ANode node) throws QueryException {
        if (node instanceof FNode) {
            ANode n = node;
            while (n.type != NodeType.DOC) {
                if ((n = n.parent()) != null) continue;
                throw Err.IDDOC.thrw(this.input, new Object[0]);
            }
        }
        return node;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && this.def == Function.ELID || u == Expr.Use.CTX && this.expr.length == 1 || super.uses(u);
    }
}

