/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.DynFuncCall;
import org.basex.query.expr.Expr;
import org.basex.query.expr.PartFunApp;
import org.basex.query.expr.VarRef;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.Empty;
import org.basex.query.item.FItem;
import org.basex.query.item.FuncType;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;

public final class FNFunc
extends FuncCall {
    public FNFunc(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case MAP: {
                return this.map(ctx);
            }
            case FILTER: {
                return this.filter(ctx);
            }
            case MAPPAIRS: {
                return this.zip(ctx);
            }
            case FOLDLEFT: {
                return this.foldLeft(ctx);
            }
            case FOLDRIGHT: {
                return this.foldRight(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case FUNCARITY: {
                return Itr.get(this.getFun(0, FuncType.ANY_FUN, ctx).arity());
            }
            case FUNCNAME: {
                return this.getFun(0, FuncType.ANY_FUN, ctx).fName();
            }
            case PARTAPP: {
                return this.partApp(ctx, ii);
            }
        }
        return super.item(ctx, ii);
    }

    private Item partApp(QueryContext ctx, InputInfo ii) throws QueryException {
        FItem f = this.getFun(0, FuncType.ANY_FUN, ctx);
        long pos = this.expr.length == 2 ? 0L : this.checkItr(this.expr[2], ctx) - 1L;
        int arity = f.arity();
        if (pos < 0L || pos >= (long)arity) {
            Err.INVPOS.thrw(ii, f.name(), pos + 1L);
        }
        FuncType ft = (FuncType)f.type;
        Var[] vars = new Var[arity - 1];
        Expr[] vals = new Expr[arity];
        vals[(int)pos] = this.expr[1];
        int i = 0;
        int j = 0;
        while (i < arity - 1) {
            if ((long)i == pos) {
                ++j;
            }
            vars[i] = ctx.uniqueVar(ii, ft.args[j]);
            vals[j] = new VarRef(ii, vars[i]);
            ++i;
            ++j;
        }
        return new PartFunApp(ii, new DynFuncCall(ii, (Expr)f, vals), vars).comp(ctx).item(ctx, ii);
    }

    private Iter map(final QueryContext ctx) throws QueryException {
        final FItem f = this.withArity(0, 1, ctx);
        final Iter xs = this.expr[1].iter(ctx);
        return new Iter(){
            Iter ys = Empty.ITER;

            @Override
            public Item next() throws QueryException {
                Item it;
                while ((it = this.ys.next()) == null) {
                    Item x = xs.next();
                    if (x == null) {
                        return null;
                    }
                    this.ys = f.invIter(ctx, FNFunc.this.input, x);
                }
                return it;
            }
        };
    }

    private Iter filter(final QueryContext ctx) throws QueryException {
        final FItem f = this.withArity(0, 1, ctx);
        final Iter xs = this.expr[1].iter(ctx);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it;
                Item b;
                do {
                    if ((it = xs.next()) != null) continue;
                    return null;
                } while (!FNFunc.this.checkType(b = f.invItem(ctx, FNFunc.this.input, it), AtomType.BLN).bool(FNFunc.this.input));
                return it;
            }
        };
    }

    private Iter zip(final QueryContext ctx) throws QueryException {
        final FItem zipper = this.withArity(0, 2, ctx);
        final Iter xs = this.expr[1].iter(ctx);
        final Iter ys = this.expr[2].iter(ctx);
        return new Iter(){
            Iter zs = Empty.ITER;

            @Override
            public Item next() throws QueryException {
                Item it;
                while ((it = this.zs.next()) == null) {
                    Item x = xs.next();
                    Item y = ys.next();
                    if (x == null || y == null) {
                        return null;
                    }
                    this.zs = zipper.invIter(ctx, FNFunc.this.input, x, y);
                }
                return it;
            }
        };
    }

    private Iter foldLeft(QueryContext ctx) throws QueryException {
        FItem f = this.withArity(0, 2, ctx);
        Iter xs = this.expr[2].iter(ctx);
        Item x = xs.next();
        if (x == null) {
            return this.expr[1].iter(ctx);
        }
        Value sum = this.expr[1].value(ctx);
        do {
            sum = f.invValue(ctx, this.input, sum, x);
        } while ((x = xs.next()) != null);
        return sum.iter();
    }

    private Iter foldRight(QueryContext ctx) throws QueryException {
        FItem f = this.withArity(0, 2, ctx);
        Value xs = this.expr[2].value(ctx);
        if (xs.empty()) {
            return this.expr[1].iter(ctx);
        }
        Value res = this.expr[1].value(ctx);
        long i = xs.size();
        while (--i >= 0L) {
            res = f.invValue(ctx, this.input, xs.itemAt(i), res);
        }
        return res.iter();
    }

    private FItem getFun(int p, FuncType t, QueryContext ctx) throws QueryException {
        return (FItem)this.checkType(this.checkItem(this.expr[p], ctx), t);
    }

    private FItem withArity(int p, int a, QueryContext ctx) throws QueryException {
        Item f = this.checkItem(this.expr[p], ctx);
        if (!f.func() || ((FItem)f).arity() != a) {
            Err.type(this, FuncType.arity(a), f);
        }
        return (FItem)f;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.def == Function.PARTAPP && u == Expr.Use.CTX || u == Expr.Use.X30 || super.uses(u);
    }
}

