/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import org.basex.core.Commands;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.InfoIndex;
import org.basex.core.cmd.List;
import org.basex.data.Data;
import org.basex.index.IndexToken;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IndexAccess;
import org.basex.query.func.FNFt;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.query.item.DBNodeSeq;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Value;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.iter.ValueIter;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.up.primitives.Add;
import org.basex.query.up.primitives.DeleteNode;
import org.basex.query.up.primitives.Optimize;
import org.basex.query.up.primitives.ReplaceValue;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.ObjList;

public final class FNDb
extends FuncCall {
    public FNDb(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case DBOPEN: {
                return this.open(ctx).iter();
            }
            case DBTEXT: {
                return this.text(ctx);
            }
            case DBATTR: {
                return this.attribute(ctx);
            }
            case DBFULLTEXT: {
                return this.fulltext(ctx);
            }
            case DBLIST: {
                return this.list(ctx);
            }
            case DBNODEID: {
                return this.node(ctx, true);
            }
            case DBNODEPRE: {
                return this.node(ctx, false);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case DBEVENT: {
                return this.event(ctx);
            }
            case DBOPENID: {
                return this.open(ctx, true);
            }
            case DBOPENPRE: {
                return this.open(ctx, false);
            }
            case DBSYSTEM: {
                return this.system(ctx);
            }
            case DBINFO: {
                return this.info(ctx);
            }
            case DBADD: {
                return this.add(ctx);
            }
            case DBDELETE: {
                return this.delete(ctx);
            }
            case DBRENAME: {
                return this.rename(ctx);
            }
            case DBREPLACE: {
                return this.replace(ctx);
            }
            case DBOPTIMIZE: {
                return this.optimize(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case DBOPEN: {
                return this.open(ctx);
            }
        }
        return super.value(ctx);
    }

    private Value open(QueryContext ctx) throws QueryException {
        byte[] str = this.checkStr(this.expr[0], ctx);
        int s = Token.indexOf(str, 47);
        byte[] db = s == -1 ? str : Token.substring(str, 0, s);
        byte[] path = s == -1 ? Token.EMPTY : Token.substring(str, s + 1);
        Data data = ctx.resource.data(db, this.input);
        return DBNodeSeq.get(data.doc(Token.string(path)), data, true, s == -1);
    }

    private DBNode open(QueryContext ctx, boolean id) throws QueryException {
        int pre;
        Data data = this.data(0, ctx);
        int v = (int)this.checkItr(this.expr[1], ctx);
        int n = pre = id ? data.pre(v) : v;
        if (pre < 0 || pre >= data.meta.size) {
            Err.IDINVALID.thrw(this.input, this, v);
        }
        return new DBNode(data, pre);
    }

    private Iter text(QueryContext ctx) throws QueryException {
        IndexContext ic = new IndexContext(ctx, this.data(0, ctx), null, true);
        return new IndexAccess(this.input, this.expr[1], IndexToken.IndexType.TEXT, ic).iter(ctx);
    }

    private Iter attribute(QueryContext ctx) throws QueryException {
        IndexContext ic = new IndexContext(ctx, this.data(0, ctx), null, true);
        IndexAccess ia = new IndexAccess(this.input, this.expr[1], IndexToken.IndexType.ATTRIBUTE, ic);
        if (this.expr.length < 3) {
            return ia.iter(ctx);
        }
        Item name = this.checkEmpty(this.expr[2].item(ctx, this.input));
        QNm nm = new QNm(this.checkStr(name, ctx), ctx, this.input);
        final NameTest nt = new NameTest(nm, Test.Name.STD, true, this.input);
        if (!nt.comp(ctx)) {
            return Empty.ITER;
        }
        return new Iter(ia, ctx){
            final NodeIter ir;
            {
                this.ir = indexAccess.iter(queryContext);
            }

            @Override
            public Item next() throws QueryException {
                ANode n;
                while ((n = this.ir.next()) != null && !nt.eval(n)) {
                }
                return n;
            }
        };
    }

    private Iter fulltext(QueryContext ctx) throws QueryException {
        return FNFt.search(this.data(0, ctx), this.checkStr(this.expr[1], ctx), this, ctx);
    }

    private Iter list(QueryContext ctx) throws QueryException {
        ItemCache ic = new ItemCache();
        if (this.expr.length == 0) {
            for (String s : List.list(ctx.context)) {
                ic.add(Str.get(s));
            }
        } else {
            byte[] str = this.checkStr(this.expr[0], ctx);
            int s = Token.indexOf(str, 47);
            byte[] db = s == -1 ? str : Token.substring(str, 0, s);
            byte[] path = s == -1 ? Token.EMPTY : Token.substring(str, s + 1);
            Data data = ctx.resource.data(db, this.input);
            IntList il = data.doc(Token.string(path));
            int i = 0;
            int is = il.size();
            while (i < is) {
                ic.add(Str.get(data.text(il.get(i), true)));
                ++i;
            }
        }
        return ic;
    }

    private Str system(QueryContext ctx) {
        return Str.get(Token.delete(Info.info(ctx.context), 13));
    }

    private Str info(QueryContext ctx) throws QueryException {
        byte[] info;
        this.checkRead(ctx);
        Data data = this.data(0, ctx);
        if (this.expr.length == 1) {
            boolean create = ctx.context.user.perm(4);
            info = InfoDB.db(data.meta, false, true, create);
        } else {
            byte[] tp = this.checkStr(this.expr[1], ctx);
            Commands.CmdIndexInfo cmd = InfoIndex.info(Token.string(tp));
            if (cmd == null) {
                Err.NOIDX.thrw(this.input, this);
            }
            info = InfoIndex.info(cmd, data);
        }
        return Str.get(Token.delete(info, 13));
    }

    private Item add(QueryContext ctx) throws QueryException {
        Item i;
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        byte[] name = this.expr.length < 3 ? null : FNDb.path(this.checkStr(this.expr[2], ctx));
        byte[] path = this.expr.length < 4 ? null : FNDb.path(this.checkStr(this.expr[3], ctx));
        ObjList<Item> docs = new ObjList<Item>((int)Math.max(this.expr[1].size(), 1L));
        Iter iter = ctx.iter(this.expr[1]);
        while ((i = iter.next()) != null) {
            docs.add(i);
        }
        if (docs.size() > 0) {
            ctx.updates.add(new Add(data, this.input, docs, name, path, ctx.context), ctx);
        }
        return null;
    }

    private Item replace(QueryContext ctx) throws QueryException {
        byte[] trgpath;
        byte[] trgname;
        int p;
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        byte[] trg = FNDb.path(this.checkStr(this.expr[1], ctx));
        Item doc = this.checkItem(this.expr[2], ctx);
        IntList old = data.doc(Token.string(trg));
        if (old.size() > 0) {
            int pre = old.get(0);
            if (old.size() > 1 || !Token.eq(data.text(pre, true), trg)) {
                Err.DOCTRGMULT.thrw(this.input, new Object[0]);
            }
            ctx.updates.add(new DeleteNode(pre, data, this.input), ctx);
        }
        if ((p = Token.lastIndexOf(trg, 47)) < 0) {
            trgname = trg;
            trgpath = null;
        } else {
            trgname = Token.subtoken(trg, p + 1);
            trgpath = Token.subtoken(trg, 0, p);
        }
        ObjList<Item> docs = new ObjList<Item>(1);
        docs.add(doc);
        Add add = new Add(data, this.input, docs, trgname, trgpath, ctx.context);
        ctx.updates.add(add, ctx);
        return null;
    }

    private Item delete(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        byte[] target = FNDb.path(this.checkStr(this.expr[1], ctx));
        IntList il = data.doc(Token.string(target));
        int i = 0;
        int is = il.size();
        while (i < is) {
            int pre = il.get(i);
            ctx.updates.add(new DeleteNode(pre, data, this.input), ctx);
            ++i;
        }
        return null;
    }

    private Item rename(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        byte[] source = FNDb.path(this.checkStr(this.expr[1], ctx));
        byte[] target = FNDb.path(this.checkStr(this.expr[2], ctx));
        IntList il = data.doc(Token.string(source));
        int i = 0;
        int is = il.size();
        while (i < is) {
            int pre = il.get(i);
            byte[] trg = ACreate.newName(data, pre, source, target);
            if (trg.length == 0) {
                Err.EMPTYPATH.thrw(this.input, this);
            }
            ctx.updates.add(new ReplaceValue(pre, data, this.input, trg), ctx);
            ++i;
        }
        return null;
    }

    private Item optimize(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        boolean all = this.expr.length == 2 && this.checkBln(this.expr[1], ctx);
        Data data = this.data(0, ctx);
        ctx.updates.add(new Optimize(data, ctx.context, all, this.input), ctx);
        return null;
    }

    private Iter node(QueryContext ctx, final boolean id) throws QueryException {
        return new Iter(ctx){
            final Iter ir;
            {
                this.ir = queryContext.iter(FNDb.this.expr[0]);
            }

            @Override
            public Item next() throws QueryException {
                Item it = this.ir.next();
                if (it == null) {
                    return null;
                }
                DBNode node = FNDb.this.checkDBNode(it);
                return Itr.get(id ? node.data.id(node.pre) : node.pre);
            }
        };
    }

    private Item event(QueryContext ctx) throws QueryException {
        byte[] name = this.checkStr(this.expr[0], ctx);
        if (this.expr.length == 3) {
            this.expr[2].value(ctx);
        }
        ArrayOutput ao = new ArrayOutput();
        try {
            Item it;
            XMLSerializer xml = new XMLSerializer(ao);
            ValueIter ir = this.expr[1].value(ctx).iter();
            while ((it = ir.next()) != null) {
                it.serialize(xml);
            }
            xml.close();
        }
        catch (SerializerException ex) {
            throw new QueryException(this.input, ex);
        }
        catch (IOException ex) {
            Err.SERANY.thrw(this.input, ex);
        }
        if (!ctx.context.events.notify(ctx.context, name, ao.toArray())) {
            Err.NOEVENT.thrw(this.input, new Object[]{name});
        }
        return null;
    }

    @Override
    public boolean vacuous() {
        return this.def == Function.DBEVENT;
    }

    @Override
    public boolean uses(Expr.Use u) {
        boolean up;
        boolean bl = up = this.def == Function.DBADD || this.def == Function.DBDELETE || this.def == Function.DBRENAME || this.def == Function.DBREPLACE || this.def == Function.DBOPTIMIZE;
        return u == Expr.Use.CTX && (this.def == Function.DBTEXT || this.def == Function.DBATTR || this.def == Function.DBFULLTEXT || this.def == Function.DBEVENT || up) || u == Expr.Use.UPD && up || super.uses(u);
    }

    @Override
    public boolean iterable() {
        return this.def == Function.DBOPEN || this.def == Function.DBTEXT || this.def == Function.DBATTR || this.def == Function.DBFULLTEXT || super.iterable();
    }

    private Data data(int arg, QueryContext ctx) throws QueryException {
        Item it = this.checkEmpty(this.expr[arg].item(ctx, this.input));
        if (it.node()) {
            return this.checkDBNode((Item)it).data;
        }
        if (it.str()) {
            return ctx.resource.data(it.atom(this.input), this.input);
        }
        throw Err.STRNODTYPE.thrw(this.input, this, it.type);
    }

    private static byte[] path(byte[] path) {
        return Token.token(ACreate.path(Token.string(path)));
    }
}

