/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.item.FTNode;
import org.basex.query.iter.FTIter;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;

public final class FTWeight
extends FTExpr {
    private Expr weight;

    public FTWeight(InputInfo ii, FTExpr e, Expr w) {
        super(ii, e);
        this.weight = w;
    }

    @Override
    public FTExpr comp(QueryContext ctx) throws QueryException {
        this.weight = this.checkUp(this.weight, ctx).comp(ctx);
        return super.comp(ctx);
    }

    @Override
    public FTNode item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.weight(this.expr[0].item(ctx, this.input), ctx);
    }

    @Override
    public FTIter iter(final QueryContext ctx) {
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                return FTWeight.this.weight(FTWeight.this.expr[0].iter(ctx).next(), ctx);
            }
        };
    }

    FTNode weight(FTNode item, QueryContext ctx) throws QueryException {
        if (item == null) {
            return null;
        }
        double d = this.checkDbl(this.weight, ctx);
        if (Math.abs(d) > 1000.0) {
            Err.FTWEIGHT.thrw(this.input, d);
        }
        if (d == 0.0) {
            item.all.size = 0;
        }
        item.score(item.score() * d);
        return item;
    }

    @Override
    public boolean indexAccessible(IndexContext ic) {
        return false;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.weight.uses(u) || super.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.weight.count(v) + super.count(v);
    }

    @Override
    public boolean removable(Var v) {
        return this.weight.removable(v) && super.removable(v);
    }

    @Override
    public FTExpr remove(Var v) {
        this.weight = this.weight.remove(v);
        return super.remove(v);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        this.weight.plan(ser);
        this.expr[0].plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        return this.expr[0] + " " + "weight" + " " + this.weight;
    }
}

