/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.DBNode;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.MapType;
import org.basex.query.item.NodeType;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.item.Uri;
import org.basex.query.item.Value;
import org.basex.query.item.map.Map;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ParseExpr
extends Expr {
    public final InputInfo input;
    public long size = -1L;
    public SeqType type;

    public ParseExpr(InputInfo ii) {
        this.input = ii;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Item it = this.item(ctx, this.input);
        return it != null ? it.iter() : Empty.ITER;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Iter ir = this.iter(ctx);
        Item it = ir.next();
        if (it == null || ir.size() == 1L) {
            return it;
        }
        Item n = ir.next();
        if (n != null) {
            Err.XPSEQ.thrw(ii, this);
        }
        return it;
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        if (this.type().zeroOrOne()) {
            Item v = this.item(ctx, this.input);
            return v == null ? Empty.SEQ : v;
        }
        return ctx.iter(this).finish();
    }

    @Override
    public final Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = null;
        if (this.type().zeroOrOne()) {
            it = this.item(ctx, this.input);
        } else {
            Iter ir = this.iter(ctx);
            it = ir.next();
            if (it != null && !it.node() && ir.next() != null) {
                Err.CONDTYPE.thrw(this.input, this);
            }
        }
        return it == null ? Bln.FALSE : it;
    }

    @Override
    public final Item test(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.ebv(ctx, this.input);
        return (it.num() ? it.dbl(this.input) == (double)ctx.pos : it.bool(this.input)) ? it : null;
    }

    @Override
    public SeqType type() {
        return this.type != null ? this.type : SeqType.ITEM_ZM;
    }

    @Override
    public final long size() {
        return this.size == -1L ? this.type().occ() : this.size;
    }

    public final Expr preEval(QueryContext ctx) throws QueryException {
        return this.optPre(this.item(ctx, this.input), ctx);
    }

    protected final Expr optPre(Expr opt, QueryContext ctx) {
        if (opt != this) {
            ctx.compInfo("pre-evaluating %", this);
        }
        return opt == null ? Empty.SEQ : opt;
    }

    protected final Expr compBln(Expr e) {
        return e.type().eq(SeqType.BLN) ? e : Function.BOOLEAN.get(this.input, e);
    }

    public final Expr checkUp(Expr e, QueryContext ctx) throws QueryException {
        if (e != null && ctx.updating && e.uses(Expr.Use.UPD)) {
            Err.UPNOT.thrw(this.input, this.desc());
        }
        return e;
    }

    public void checkUp(QueryContext ctx, Expr ... expr) throws QueryException {
        if (!ctx.updating) {
            return;
        }
        int s = 0;
        Expr[] exprArray = expr;
        int n = expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            if (!e.vacuous()) {
                boolean u = e.uses(Expr.Use.UPD);
                if (u && s == 2 || !u && s == 1) {
                    Err.UPNOT.thrw(this.input, this.desc());
                }
                s = u ? 1 : 2;
            }
            ++n2;
        }
    }

    public final boolean checkBln(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkNoEmpty(e.item(ctx, this.input), AtomType.BLN);
        if (!it.unt() && it.type != AtomType.BLN) {
            Err.type(this, AtomType.BLN, it);
        }
        return it.bool(this.input);
    }

    public final double checkDbl(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkNoEmpty(e.item(ctx, this.input), AtomType.DBL);
        if (!it.unt() && !it.num()) {
            Err.number(this, it);
        }
        return it.dbl(this.input);
    }

    public final long checkItr(Expr e, QueryContext ctx) throws QueryException {
        return this.checkItr(this.checkNoEmpty(e.item(ctx, this.input), AtomType.ITR));
    }

    private Item checkNoEmpty(Item it, Type t) throws QueryException {
        if (it == null) {
            Err.XPEMPTYPE.thrw(this.input, this.desc(), t);
        }
        return it;
    }

    public final long checkItr(Item it) throws QueryException {
        if (!it.unt() && !it.type.instance(AtomType.ITR)) {
            Err.type(this, AtomType.ITR, it);
        }
        return it.itr(this.input);
    }

    public final ANode checkNode(Item it) throws QueryException {
        if (!it.node()) {
            Err.type(this, NodeType.NOD, it);
        }
        return (ANode)it;
    }

    public final DBNode checkDBNode(Item it) throws QueryException {
        if (!(it instanceof DBNode)) {
            Err.NODBCTX.thrw(this.input, this);
        }
        return (DBNode)it;
    }

    public final void checkColl(Expr e, QueryContext ctx) throws QueryException {
        byte[] u = this.checkStr(e, ctx);
        if (Token.eq(QueryText.URLCOLL, u)) {
            return;
        }
        Uri uri = Uri.uri(u);
        if (uri.absolute() || !ctx.baseURI.resolve(uri).eq(Uri.COLL)) {
            Err.IMPLCOL.thrw(this.input, e);
        }
    }

    public final byte[] checkStr(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkItem(e, ctx);
        if (!it.str() && !it.unt()) {
            Err.type(this, AtomType.STR, it);
        }
        return it.atom(this.input);
    }

    public final byte[] checkEStr(Item it) throws QueryException {
        if (it == null) {
            return Token.EMPTY;
        }
        if (!it.str() && !it.unt()) {
            Err.type(this, AtomType.STR, it);
        }
        return it.atom(this.input);
    }

    public final Value checkCtx(QueryContext ctx) throws QueryException {
        Value v = ctx.value;
        if (v == null) {
            Err.XPNOCTX.thrw(this.input, this);
        }
        return v;
    }

    public final Item checkItem(Expr e, QueryContext ctx) throws QueryException {
        return this.checkEmpty(e.item(ctx, this.input));
    }

    public final Item checkType(Item it, Type t) throws QueryException {
        if (!this.checkEmpty((Item)it).type.instance(t)) {
            Err.type(this, t, it);
        }
        return it;
    }

    public final Item checkEmpty(Item it) throws QueryException {
        if (it == null) {
            Err.XPEMPTY.thrw(this.input, this.desc());
        }
        return it;
    }

    public final byte[] checkEStr(Expr e, QueryContext ctx) throws QueryException {
        return this.checkEStr(e.item(ctx, this.input));
    }

    public final IO checkIO(Expr e, QueryContext ctx) throws QueryException {
        this.checkAdmin(ctx);
        byte[] name = this.checkStr(e, ctx);
        IO io = IO.get(Token.string(name));
        if (!io.exists()) {
            Err.DOCERR.thrw(this.input, new Object[]{name});
        }
        return io;
    }

    public final void checkAdmin(QueryContext ctx) throws QueryException {
        this.checkPerm(ctx, (byte)8);
    }

    public final void checkWrite(QueryContext ctx) throws QueryException {
        this.checkPerm(ctx, (byte)2);
    }

    public final void checkRead(QueryContext ctx) throws QueryException {
        this.checkPerm(ctx, (byte)1);
    }

    private void checkPerm(QueryContext ctx, byte p) throws QueryException {
        if (!ctx.context.user.perm(p)) {
            Err.PERMNO.thrw(this.input, p);
        }
    }

    public Map checkMap(Item it) throws QueryException {
        if (it instanceof Map) {
            return (Map)it;
        }
        throw Err.type(this, MapType.ANY_MAP, it);
    }
}

