/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.data.MemData;
import org.basex.data.StatsKey;
import org.basex.index.IndexToken;
import org.basex.index.Names;
import org.basex.index.RangeToken;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.RangeAccess;
import org.basex.query.expr.Single;
import org.basex.query.item.Bln;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.SeqType;
import org.basex.query.iter.Iter;
import org.basex.query.path.Axis;
import org.basex.query.path.AxisPath;
import org.basex.query.path.AxisStep;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.util.IndexContext;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class CmpR
extends Single {
    private final double min;
    private final boolean mni;
    private final double max;
    private final boolean mxi;
    private RangeToken rt;
    private final boolean atomic;

    private CmpR(InputInfo ii, Expr e, double mn, boolean in, double mx, boolean ix) {
        super(ii, e);
        this.min = mn;
        this.mni = in;
        this.max = mx;
        this.mxi = ix;
        this.type = SeqType.BLN;
        this.atomic = e.type().zeroOrOne();
    }

    static Expr get(CmpG ex) throws QueryException {
        if (!ex.expr[1].item()) {
            return ex;
        }
        Item it = (Item)ex.expr[1];
        if (!it.num()) {
            return ex;
        }
        Expr e = ex.expr[0];
        double d = it.dbl(ex.input);
        switch (ex.op.op) {
            case EQ: {
                return new CmpR(ex.input, e, d, true, d, true);
            }
            case GE: {
                return new CmpR(ex.input, e, d, true, Double.POSITIVE_INFINITY, true);
            }
            case GT: {
                return new CmpR(ex.input, e, d, false, Double.POSITIVE_INFINITY, true);
            }
            case LE: {
                return new CmpR(ex.input, e, Double.NEGATIVE_INFINITY, true, d, true);
            }
            case LT: {
                return new CmpR(ex.input, e, Double.NEGATIVE_INFINITY, true, d, false);
            }
        }
        return ex;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it;
        if (this.atomic) {
            Item it2 = this.expr.item(ctx, this.input);
            if (it2 == null) {
                return Bln.FALSE;
            }
            double d = it2.dbl(this.input);
            return Bln.get((this.mni ? d >= this.min : d > this.min) && (this.mxi ? d <= this.max : d < this.max));
        }
        Iter ir = ctx.iter(this.expr);
        while ((it = ir.next()) != null) {
            double d = it.dbl(this.input);
            if (!(this.mni ? d >= this.min : d > this.min) || !(this.mxi ? d <= this.max : d < this.max)) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    Expr intersect(CmpR c) {
        double mx;
        if (!c.expr.sameAs(this.expr)) {
            return null;
        }
        double mn = Math.max(this.min, c.min);
        return mn > (mx = Math.min(this.max, c.max)) ? Bln.FALSE : new CmpR(this.input, c.expr, mn, this.mni && c.mni, mx, this.mxi && c.mxi);
    }

    @Override
    public boolean indexAccessible(IndexContext ic) {
        boolean attr;
        AxisStep s = CmpG.indexStep(this.expr);
        if (s == null || ic.data instanceof MemData) {
            return false;
        }
        boolean text = s.test.type == NodeType.TXT && ic.data.meta.textindex;
        boolean bl = attr = s.test.type == NodeType.ATT && ic.data.meta.attrindex;
        if (!text && !attr || !this.mni || !this.mxi) {
            return false;
        }
        StatsKey key = this.key(ic, text);
        if (key == null) {
            return false;
        }
        this.rt = new RangeToken(text, Math.max(this.min, key.min), Math.min(this.max, key.max));
        ic.costs(this.rt.min > this.rt.max || this.rt.max < key.min || this.rt.min > key.max ? 0 : Math.max(1, ic.data.meta.size / 5));
        return ic.costs() == 0 || this.min != Double.NEGATIVE_INFINITY && this.max != Double.POSITIVE_INFINITY;
    }

    @Override
    public Expr indexEquivalent(IndexContext ic) {
        boolean text = this.rt.type() == IndexToken.IndexType.TEXT;
        ic.ctx.compInfo("applying range index", new Object[0]);
        return ic.invert(this.expr, new RangeAccess(this.input, this.rt, ic), text);
    }

    private StatsKey key(IndexContext ic, boolean text) {
        if (!ic.data.meta.uptodate || ic.data.ns.size() != 0) {
            return null;
        }
        AxisPath path = (AxisPath)this.expr;
        int st = path.step.length;
        AxisStep step = null;
        if (text) {
            AxisStep axisStep = step = st == 1 ? ic.step : path.step(st - 2);
            if (step.test.test != Test.Name.NAME) {
                return null;
            }
        } else {
            step = path.step(st - 1);
            if (!step.simple(Axis.ATTR, true)) {
                return null;
            }
        }
        Names names = text ? ic.data.tagindex : ic.data.atnindex;
        StatsKey key = names.stat(names.id(((NameTest)step.test).ln));
        return key == null || key.kind == StatsKey.Kind.INT || key.kind == StatsKey.Kind.DBL ? key : null;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.MIN, Token.token(this.min), QueryText.MAX, Token.token(this.max)});
        this.expr.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.min != Double.NEGATIVE_INFINITY) {
            sb.append(String.valueOf(this.min) + (this.mni ? " <= " : " < "));
        }
        sb.append(this.expr);
        if (this.max != Double.POSITIVE_INFINITY) {
            sb.append(String.valueOf(this.mxi ? " <= " : " < ") + this.max);
        }
        return sb.toString();
    }
}

