/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.item.ANode;
import org.basex.query.item.Bln;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class CmpN
extends Arr {
    private final Op op;

    public CmpN(InputInfo ii, Expr e1, Expr e2, Op o) {
        super(ii, e1, e2);
        this.op = o;
        this.type = SeqType.BLN_ZO;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        return this.optPre(this.oneEmpty() ? null : (this.values() ? this.item(ctx, this.input) : this), ctx);
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item a = this.expr[0].item(ctx, this.input);
        if (a == null) {
            return null;
        }
        Item b = this.expr[1].item(ctx, this.input);
        if (b == null) {
            return null;
        }
        return Bln.get(this.op.e(this.checkNode(a), this.checkNode(b)));
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.OP, Token.token(this.op.name)});
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            e.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public String desc() {
        return "'" + (Object)((Object)this.op) + "' operator";
    }

    @Override
    public String toString() {
        return this.toString(" " + (Object)((Object)this.op) + " ");
    }

    public static enum Op {
        EQ("is"){

            @Override
            public boolean e(ANode a, ANode b) {
                return a.is(b);
            }
        }
        ,
        ET("<<"){

            @Override
            public boolean e(ANode a, ANode b) {
                return a.diff(b) < 0;
            }
        }
        ,
        GT(">>"){

            @Override
            public boolean e(ANode a, ANode b) {
                return a.diff(b) > 0;
            }
        };

        public final String name;

        private Op(String n2) {
            this.name = n2;
        }

        public abstract boolean e(ANode var1, ANode var2) throws QueryException;

        public String toString() {
            return this.name;
        }
    }
}

