/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.math.BigDecimal;
import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.DTd;
import org.basex.query.item.Dat;
import org.basex.query.item.Date;
import org.basex.query.item.Dbl;
import org.basex.query.item.Dec;
import org.basex.query.item.Dtm;
import org.basex.query.item.Dur;
import org.basex.query.item.Flt;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Tim;
import org.basex.query.item.Type;
import org.basex.query.item.YMd;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;

public enum Calc {
    PLUS("+"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            boolean t2;
            Type ta = a.type;
            Type tb = b.type;
            boolean t1 = ta.num() || ta.unt();
            boolean bl = t2 = tb.num() || tb.unt();
            if (t1 ^ t2) {
                this.errNum(ii, !t1 ? a : b);
            }
            if (t1 && t2) {
                Type t = 1.type(ta, tb);
                if (t == AtomType.ITR) {
                    long l1 = a.itr(ii);
                    long l2 = b.itr(ii);
                    this.checkRange(ii, (double)l1 + (double)l2);
                    return Itr.get(l1 + l2);
                }
                if (t == AtomType.FLT) {
                    return Flt.get(a.flt(ii) + b.flt(ii));
                }
                if (t == AtomType.DBL) {
                    return Dbl.get(a.dbl(ii) + b.dbl(ii));
                }
                return Dec.get(a.dec(ii).add(b.dec(ii)));
            }
            if (ta == tb) {
                if (!ta.dur()) {
                    this.errNum(ii, !t1 ? a : b);
                }
                if (ta == AtomType.YMD) {
                    return new YMd((YMd)a, (YMd)b, true);
                }
                if (ta == AtomType.DTD) {
                    return new DTd((DTd)a, (DTd)b, true);
                }
            }
            if (ta == AtomType.DTM) {
                return new Dtm((Date)a, this.checkDur(ii, b), true, ii);
            }
            if (tb == AtomType.DTM) {
                return new Dtm((Date)b, this.checkDur(ii, a), true, ii);
            }
            if (ta == AtomType.DAT) {
                return new Dat((Date)a, this.checkDur(ii, b), true, ii);
            }
            if (tb == AtomType.DAT) {
                return new Dat((Date)b, this.checkDur(ii, a), true, ii);
            }
            if (ta == AtomType.TIM) {
                if (tb != AtomType.DTD) {
                    this.errType(ii, AtomType.DTD, b);
                }
                return new Tim((Tim)a, (DTd)b, true, ii);
            }
            if (tb == AtomType.TIM) {
                if (ta != AtomType.DTD) {
                    this.errType(ii, AtomType.DTD, b);
                }
                return new Tim((Tim)b, (DTd)a, true, ii);
            }
            this.errType(ii, ta, b);
            return null;
        }
    }
    ,
    MINUS("-"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            boolean t2;
            Type ta = a.type;
            Type tb = b.type;
            boolean t1 = ta.num() || ta.unt();
            boolean bl = t2 = tb.num() || tb.unt();
            if (t1 ^ t2) {
                this.errNum(ii, !t1 ? a : b);
            }
            if (t1 && t2) {
                Type t = 2.type(ta, tb);
                if (t == AtomType.ITR) {
                    long l1 = a.itr(ii);
                    long l2 = b.itr(ii);
                    this.checkRange(ii, (double)l1 - (double)l2);
                    return Itr.get(l1 - l2);
                }
                if (t == AtomType.DBL) {
                    return Dbl.get(a.dbl(ii) - b.dbl(ii));
                }
                if (t == AtomType.FLT) {
                    return Flt.get(a.flt(ii) - b.flt(ii));
                }
                return Dec.get(a.dec(ii).subtract(b.dec(ii)));
            }
            if (ta == tb) {
                if (ta == AtomType.DTM || ta == AtomType.DAT || ta == AtomType.TIM) {
                    return new DTd((Date)a, (Date)b);
                }
                if (ta == AtomType.YMD) {
                    return new YMd((YMd)a, (YMd)b, false);
                }
                if (ta == AtomType.DTD) {
                    return new DTd((DTd)a, (DTd)b, false);
                }
                this.errNum(ii, !t1 ? a : b);
            }
            if (ta == AtomType.DTM) {
                return new Dtm((Date)a, this.checkDur(ii, b), false, ii);
            }
            if (ta == AtomType.DAT) {
                return new Dat((Date)a, this.checkDur(ii, b), false, ii);
            }
            if (ta == AtomType.TIM) {
                if (tb != AtomType.DTD) {
                    this.errType(ii, AtomType.DTD, b);
                }
                return new Tim((Tim)a, (DTd)b, false, ii);
            }
            this.errType(ii, ta, b);
            return null;
        }
    }
    ,
    MULT("*"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            boolean t2;
            Type ta = a.type;
            Type tb = b.type;
            if (ta == AtomType.YMD) {
                if (!tb.num()) {
                    this.errNum(ii, b);
                }
                return new YMd((Dur)a, b.dbl(ii), true, ii);
            }
            if (tb == AtomType.YMD) {
                if (!ta.num()) {
                    this.errNum(ii, a);
                }
                return new YMd((Dur)b, a.dbl(ii), true, ii);
            }
            if (ta == AtomType.DTD) {
                if (!tb.num()) {
                    this.errNum(ii, b);
                }
                return new DTd((Dur)a, b.dbl(ii), true, ii);
            }
            if (tb == AtomType.DTD) {
                if (!ta.num()) {
                    this.errNum(ii, a);
                }
                return new DTd((Dur)b, a.dbl(ii), true, ii);
            }
            boolean t1 = ta.num() || ta.unt();
            boolean bl = t2 = tb.num() || tb.unt();
            if (t1 ^ t2) {
                this.errType(ii, ta, b);
            }
            if (t1 && t2) {
                Type t = 3.type(ta, tb);
                if (t == AtomType.ITR) {
                    long l1 = a.itr(ii);
                    long l2 = b.itr(ii);
                    this.checkRange(ii, (double)l1 * (double)l2);
                    return Itr.get(l1 * l2);
                }
                if (t == AtomType.DBL) {
                    return Dbl.get(a.dbl(ii) * b.dbl(ii));
                }
                if (t == AtomType.FLT) {
                    return Flt.get(a.flt(ii) * b.flt(ii));
                }
                return Dec.get(a.dec(ii).multiply(b.dec(ii)));
            }
            this.errNum(ii, !t1 ? a : b);
            return null;
        }
    }
    ,
    DIV("div"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            Type ta = a.type;
            Type tb = b.type;
            if (ta == tb) {
                if (ta == AtomType.YMD) {
                    BigDecimal bd = BigDecimal.valueOf(((YMd)b).ymd());
                    if (bd.equals(BigDecimal.ZERO)) {
                        Err.DATEZERO.thrw(ii, this.info());
                    }
                    return Dec.get(BigDecimal.valueOf(((YMd)a).ymd()).divide(bd, 20, 6));
                }
                if (ta == AtomType.DTD) {
                    BigDecimal bd = ((DTd)b).dtd();
                    if (bd.equals(BigDecimal.ZERO)) {
                        Err.DATEZERO.thrw(ii, this.info());
                    }
                    return Dec.get(((DTd)a).dtd().divide(bd, 20, 6));
                }
            }
            if (ta == AtomType.YMD) {
                if (!tb.num()) {
                    this.errNum(ii, b);
                }
                return new YMd((Dur)a, b.dbl(ii), false, ii);
            }
            if (ta == AtomType.DTD) {
                if (!tb.num()) {
                    this.errNum(ii, b);
                }
                return new DTd((Dur)a, b.dbl(ii), false, ii);
            }
            this.checkNum(ii, a, b);
            Type t = 4.type(ta, tb);
            if (t == AtomType.DBL) {
                return Dbl.get(a.dbl(ii) / b.dbl(ii));
            }
            if (t == AtomType.FLT) {
                return Flt.get(a.flt(ii) / b.flt(ii));
            }
            BigDecimal b1 = a.dec(ii);
            BigDecimal b2 = b.dec(ii);
            if (b2.signum() == 0) {
                Err.DIVZERO.thrw(ii, a);
            }
            int s = Math.max(18, Math.max(b1.scale(), b2.scale()));
            return Dec.get(b1.divide(b2, s, 6));
        }
    }
    ,
    IDIV("idiv"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            Type tb;
            Type ta;
            double d;
            this.checkNum(ii, a, b);
            double d1 = a.dbl(ii);
            double d2 = b.dbl(ii);
            if (d2 == 0.0) {
                Err.DIVZERO.thrw(ii, a);
            }
            if (Double.isNaN(d = d1 / d2) || Double.isInfinite(d)) {
                Err.DIVFLOW.thrw(ii, d1, d2);
            }
            return Itr.get(5.type(ta = a.type, tb = b.type) == AtomType.ITR ? a.itr(ii) / b.itr(ii) : (long)d);
        }
    }
    ,
    MOD("mod"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            this.checkNum(ii, a, b);
            Type t = 6.type(a.type, b.type);
            if (t == AtomType.DBL) {
                return Dbl.get(a.dbl(ii) % b.dbl(ii));
            }
            if (t == AtomType.FLT) {
                return Flt.get(a.flt(ii) % b.flt(ii));
            }
            if (t == AtomType.ITR) {
                long b1 = a.itr(ii);
                long b2 = b.itr(ii);
                if (b2 == 0L) {
                    Err.DIVZERO.thrw(ii, a);
                }
                return Itr.get(b1 % b2);
            }
            BigDecimal b1 = a.dec(ii);
            BigDecimal b2 = b.dec(ii);
            if (b2.signum() == 0) {
                Err.DIVZERO.thrw(ii, a);
            }
            BigDecimal q = b1.divide(b2, 0, 1);
            return Dec.get(b1.subtract(q.multiply(b2)));
        }
    };

    final String name;

    private Calc(String n2) {
        this.name = n2;
    }

    public abstract Item ev(InputInfo var1, Item var2, Item var3) throws QueryException;

    static final Type type(Type a, Type b) {
        if (a == AtomType.DBL || b == AtomType.DBL || a.unt() || b.unt()) {
            return AtomType.DBL;
        }
        if (a == AtomType.FLT || b == AtomType.FLT) {
            return AtomType.FLT;
        }
        if (a == AtomType.DEC || b == AtomType.DEC) {
            return AtomType.DEC;
        }
        return AtomType.ITR;
    }

    final void errType(InputInfo ii, Type t, Item it) throws QueryException {
        Err.type(ii, this.info(), t, it);
    }

    final void errNum(InputInfo ii, Item it) throws QueryException {
        Err.XPTYPENUM.thrw(ii, this.info(), it.type);
    }

    final Dur checkDur(InputInfo ii, Item it) throws QueryException {
        if (!it.dur()) {
            Err.XPDUR.thrw(ii, this.info(), it.type);
        }
        if (it.type == AtomType.DUR) {
            throw Err.SIMPLDUR.thrw(ii, this.info(), it);
        }
        return (Dur)it;
    }

    final void checkNum(InputInfo ii, Item a, Item b) throws QueryException {
        if (!a.unt() && !a.num()) {
            this.errNum(ii, a);
        }
        if (!b.unt() && !b.num()) {
            this.errNum(ii, b);
        }
    }

    final void checkRange(InputInfo ii, double d) throws QueryException {
        if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
            Err.RANGE.thrw(ii, d);
        }
    }

    final String info() {
        return "'" + this.name + "' operator";
    }

    public String toString() {
        return this.name;
    }

    /* synthetic */ Calc(String string, int n, String string2, Calc calc) {
        this(string2);
    }
}

