/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import org.basex.core.cmd.Set;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.And;
import org.basex.query.expr.Arith;
import org.basex.query.expr.CAttr;
import org.basex.query.expr.CComm;
import org.basex.query.expr.CDoc;
import org.basex.query.expr.CElem;
import org.basex.query.expr.CPI;
import org.basex.query.expr.CTxt;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Castable;
import org.basex.query.expr.Catch;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Concat;
import org.basex.query.expr.Context;
import org.basex.query.expr.DynFuncCall;
import org.basex.query.expr.Except;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Extension;
import org.basex.query.expr.Filter;
import org.basex.query.expr.For;
import org.basex.query.expr.ForLet;
import org.basex.query.expr.GFLWOR;
import org.basex.query.expr.If;
import org.basex.query.expr.InlineFunc;
import org.basex.query.expr.Instance;
import org.basex.query.expr.InterSect;
import org.basex.query.expr.Let;
import org.basex.query.expr.List;
import org.basex.query.expr.LitFunc;
import org.basex.query.expr.LitMap;
import org.basex.query.expr.Or;
import org.basex.query.expr.OrderBy;
import org.basex.query.expr.OrderByExpr;
import org.basex.query.expr.OrderByStable;
import org.basex.query.expr.PartFunApp;
import org.basex.query.expr.Pragma;
import org.basex.query.expr.Quantifier;
import org.basex.query.expr.Range;
import org.basex.query.expr.Root;
import org.basex.query.expr.Switch;
import org.basex.query.expr.Treat;
import org.basex.query.expr.Try;
import org.basex.query.expr.TypeCase;
import org.basex.query.expr.TypeSwitch;
import org.basex.query.expr.Unary;
import org.basex.query.expr.Union;
import org.basex.query.expr.UserFunc;
import org.basex.query.expr.VarRef;
import org.basex.query.ft.FTAnd;
import org.basex.query.ft.FTContains;
import org.basex.query.ft.FTContent;
import org.basex.query.ft.FTDistance;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTExtensionSelection;
import org.basex.query.ft.FTMildNot;
import org.basex.query.ft.FTNot;
import org.basex.query.ft.FTOptions;
import org.basex.query.ft.FTOr;
import org.basex.query.ft.FTOrder;
import org.basex.query.ft.FTScope;
import org.basex.query.ft.FTWeight;
import org.basex.query.ft.FTWindow;
import org.basex.query.ft.FTWords;
import org.basex.query.ft.ThesQuery;
import org.basex.query.ft.Thesaurus;
import org.basex.query.func.Variable;
import org.basex.query.item.AtomType;
import org.basex.query.item.Dbl;
import org.basex.query.item.Dec;
import org.basex.query.item.Empty;
import org.basex.query.item.FuncType;
import org.basex.query.item.Itr;
import org.basex.query.item.MapType;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Str;
import org.basex.query.item.Type;
import org.basex.query.item.Types;
import org.basex.query.item.Uri;
import org.basex.query.item.Value;
import org.basex.query.item.map.Map;
import org.basex.query.path.Axis;
import org.basex.query.path.AxisStep;
import org.basex.query.path.KindTest;
import org.basex.query.path.NameTest;
import org.basex.query.path.Path;
import org.basex.query.path.Test;
import org.basex.query.up.expr.Delete;
import org.basex.query.up.expr.Insert;
import org.basex.query.up.expr.Rename;
import org.basex.query.up.expr.Replace;
import org.basex.query.up.expr.Transform;
import org.basex.query.util.Err;
import org.basex.query.util.NSLocal;
import org.basex.query.util.TypedFunc;
import org.basex.query.util.Var;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.util.pkg.JarDesc;
import org.basex.query.util.pkg.JarParser;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.util.pkg.PkgValidator;
import org.basex.util.Array;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.JarLoader;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.Language;
import org.basex.util.ft.StopWords;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.ObjList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public class QueryParser
extends InputParser {
    public final QueryContext ctx;
    private final TokenBuilder tok = new TokenBuilder();
    private final TokenList modules = new TokenList();
    private QNm module;
    private Err alter;
    private QNm alterFunc;
    private int ap;
    private final StringList serial = new StringList();
    private boolean declElem;
    private boolean declFunc;
    private boolean declColl;
    private boolean declConstr;
    private boolean declSpaces;
    private boolean declOrder;
    private boolean declReval;
    private boolean declGreat;
    private boolean declPres;
    private boolean declBase;
    private boolean declItem;
    private boolean declVars;

    public QueryParser(String q, QueryContext c) {
        super(q);
        this.ctx = c;
        this.file = c.base();
    }

    public final Expr parse(IO f, Uri u) throws QueryException {
        this.file = f;
        if (!this.more()) {
            this.error(Err.QUERYEMPTY, new Object[0]);
        }
        int p = 0;
        while (p < this.ql) {
            int cp = this.query.codePointAt(p);
            if (!XMLToken.valid(cp)) {
                this.qp = p;
                this.error(Err.QUERYINV, this.query.codePointAt(p));
            }
            p += Character.charCount(cp);
        }
        return this.parse(u, true);
    }

    public final Expr parse(Uri u, boolean c) throws QueryException {
        Expr expr = null;
        try {
            this.versionDecl();
            if (u == null) {
                expr = this.mainModule();
                if (expr == null) {
                    if (this.alter != null) {
                        this.error();
                    } else {
                        this.error(Err.EXPREMPTY, new Object[0]);
                    }
                }
            } else {
                this.moduleDecl(u);
            }
            if (c && this.more()) {
                if (this.alter != null) {
                    this.error();
                }
                this.error(Err.QUERYEND, this.rest());
            }
        }
        catch (QueryException ex) {
            this.mark();
            ex.pos(this);
            throw ex;
        }
        this.ctx.funcs.check();
        this.ctx.vars.check();
        this.ctx.ns.finish(this.ctx.nsElem);
        byte[] empty = new QNm(Token.EMPTY).full();
        if (this.ctx.decFormats.get(empty) == null) {
            this.ctx.decFormats.add(empty, new DecFormatter());
        }
        return expr;
    }

    private void versionDecl() throws QueryException {
        int p = this.qp;
        if (!this.wsConsumeWs("xquery")) {
            return;
        }
        boolean version = this.wsConsumeWs("version");
        if (version) {
            String ver = Token.string(this.stringLiteral());
            if (ver.equals("1.0")) {
                this.ctx.xquery3 = false;
            } else if (ver.equals("1.1") || ver.equals("3.0")) {
                this.ctx.xquery3 = true;
            } else {
                this.error(Err.XQUERYVER, ver);
            }
        }
        if ((version || this.ctx.xquery3) && this.wsConsumeWs("encoding")) {
            String enc = Token.string(this.stringLiteral());
            if (!Token.supported(enc)) {
                this.error(Err.XQUERYENC2, enc);
            }
        } else if (!version) {
            this.qp = p;
            return;
        }
        this.wsCheck(";");
    }

    private Expr mainModule() throws QueryException {
        this.prolog1();
        this.prolog2();
        return this.expr();
    }

    private void moduleDecl(Uri u) throws QueryException {
        this.wsCheck("module");
        this.wsCheck("namespace");
        this.module = new QNm(this.ncName(Err.XPNAME));
        this.wsCheck("=");
        this.module.uri(this.stringLiteral());
        if (this.module.uri() == Uri.EMPTY) {
            this.error(Err.NSMODURI, new Object[0]);
        }
        this.ctx.ns.add(this.module, this.input());
        this.skipWS();
        this.check(59);
        this.prolog1();
        this.prolog2();
        if (u != Uri.EMPTY && !u.eq(this.module.uri())) {
            this.error(Err.WRONGMODULE, this.module.uri(), this.file);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prolog1() throws QueryException {
        while (true) {
            block12: {
                int p;
                block13: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                p = this.qp;
                                                if (!this.wsConsumeWs("declare")) break block13;
                                                if (!this.wsConsumeWs("default")) break block14;
                                                if (!(this.defaultNamespaceDecl() || this.defaultCollationDecl() || this.emptyOrderDecl() || this.decFormatDecl(true))) {
                                                    this.error(Err.DECLINCOMPLETE, new Object[0]);
                                                }
                                                break block12;
                                            }
                                            if (!this.wsConsumeWs("boundary-space")) break block15;
                                            this.boundarySpaceDecl();
                                            break block12;
                                        }
                                        if (!this.wsConsumeWs("base-uri")) break block16;
                                        this.baseURIDecl();
                                        break block12;
                                    }
                                    if (!this.wsConsumeWs("construction")) break block17;
                                    this.constructionDecl();
                                    break block12;
                                }
                                if (!this.wsConsumeWs("ordering")) break block18;
                                this.orderingModeDecl();
                                break block12;
                            }
                            if (!this.wsConsumeWs("revalidation")) break block19;
                            this.revalidationDecl();
                            break block12;
                        }
                        if (!this.wsConsumeWs("copy-namespaces")) break block20;
                        this.copyNamespacesDecl();
                        break block12;
                    }
                    if (this.wsConsumeWs("decimal-format")) {
                        this.decFormatDecl(false);
                        break block12;
                    } else if (this.wsConsumeWs("namespace")) {
                        this.namespaceDecl();
                        break block12;
                    } else {
                        if (!this.wsConsumeWs("ft-option")) {
                            this.qp = p;
                            return;
                        }
                        FTOpt opt = new FTOpt();
                        while (this.ftMatchOption(opt)) {
                        }
                        this.ctx.ftopt.init(opt);
                    }
                    break block12;
                }
                if (!this.wsConsumeWs("import")) {
                    return;
                }
                if (this.wsConsumeWs("schema")) {
                    this.schemaImport();
                } else {
                    if (!this.wsConsumeWs("module")) {
                        this.qp = p;
                        return;
                    }
                    this.moduleImport();
                }
            }
            this.skipWS();
            this.check(59);
        }
    }

    private void prolog2() throws QueryException {
        while (true) {
            int p = this.qp;
            if (!this.wsConsumeWs("declare")) {
                return;
            }
            if (this.ctx.xquery3 && this.wsConsumeWs("context")) {
                this.contextItemDecl();
            } else if (this.wsConsumeWs("variable")) {
                this.varDecl();
            } else if (this.wsConsumeWs("updating")) {
                this.ctx.updating = true;
                this.wsCheck("function");
                this.functionDecl(true);
            } else if (this.wsConsumeWs("function")) {
                this.functionDecl(false);
            } else if (this.wsConsumeWs("option")) {
                this.optionDecl();
            } else if (this.wsConsumeWs("default")) {
                this.error(Err.PROLOGORDER, new Object[0]);
            } else {
                this.qp = p;
                return;
            }
            this.skipWS();
            this.check(59);
        }
    }

    private void namespaceDecl() throws QueryException {
        QNm name = new QNm(this.ncName(Err.XPNAME));
        this.wsCheck("=");
        name.uri(this.stringLiteral());
        if (this.ctx.ns.find(name.ln()) != null) {
            this.error(Err.DUPLNSDECL, name);
        }
        this.ctx.ns.add(name, this.input());
    }

    private void revalidationDecl() throws QueryException {
        if (this.declReval) {
            this.error(Err.DUPLREVAL, new Object[0]);
        }
        this.declReval = true;
        if (this.wsConsumeWs("strict") || this.wsConsumeWs("lax")) {
            this.error(Err.NOREVAL, new Object[0]);
        }
        this.wsCheck("skip");
    }

    private void boundarySpaceDecl() throws QueryException {
        if (this.declSpaces) {
            this.error(Err.DUPLBOUND, new Object[0]);
        }
        this.declSpaces = true;
        boolean spaces = this.wsConsumeWs("preserve");
        if (!spaces) {
            this.wsCheck("strip");
        }
        this.ctx.spaces = spaces;
    }

    private boolean defaultNamespaceDecl() throws QueryException {
        boolean elem = this.wsConsumeWs("element");
        if (!elem && !this.wsConsumeWs("function")) {
            return false;
        }
        this.wsCheck("namespace");
        byte[] ns = this.stringLiteral();
        if (elem) {
            if (this.declElem) {
                this.error(Err.DUPLNS, new Object[0]);
            }
            this.declElem = true;
            this.ctx.nsElem = ns;
        } else {
            if (this.declFunc) {
                this.error(Err.DUPLNS, new Object[0]);
            }
            this.declFunc = true;
            this.ctx.nsFunc = ns;
        }
        return true;
    }

    private void optionDecl() throws QueryException {
        this.skipWS();
        QNm name = new QNm(this.qName(Err.QNAMEINV), this.ctx, this.input());
        byte[] val = this.stringLiteral();
        if (!name.ns()) {
            this.error(Err.NSMISS, name);
        }
        if (this.ctx.xquery3 && Token.eq(name.pref(), QueryText.OUTPUT)) {
            String key = Token.string(name.ln());
            if (this.module != null) {
                this.error(Err.MODOUT, new Object[0]);
            }
            if (this.ctx.serProp == null) {
                this.ctx.serProp = new SerializerProp();
            }
            if (this.ctx.serProp.get(key) == null) {
                this.error(Err.OUTWHICH, key);
            }
            if (this.serial.contains(key)) {
                this.error(Err.OUTDUPL, key);
            }
            this.ctx.serProp.set(key, (Object)Token.string(val));
            this.serial.add(key);
        } else if (Token.eq(name.pref(), QueryText.DB)) {
            String key = Token.string(Token.uc(name.ln()));
            Object obj = this.ctx.context.prop.get(key);
            if (obj == null) {
                this.error(Err.NOOPTION, key);
            }
            if (this.ctx.props == null) {
                this.ctx.props = new HashMap();
            }
            this.ctx.props.put(key, obj);
            Set.set(key, Token.string(val), this.ctx.context.prop);
        }
    }

    private void orderingModeDecl() throws QueryException {
        if (this.declOrder) {
            this.error(Err.DUPLORD, new Object[0]);
        }
        this.declOrder = true;
        this.ctx.ordered = this.wsConsumeWs("ordered");
        if (!this.ctx.ordered) {
            this.wsCheck("unordered");
        }
    }

    private boolean emptyOrderDecl() throws QueryException {
        if (!this.wsConsumeWs("order")) {
            return false;
        }
        this.wsCheck("empty");
        if (this.declGreat) {
            this.error(Err.DUPLORDEMP, new Object[0]);
        }
        this.declGreat = true;
        this.ctx.orderGreatest = this.wsConsumeWs("greatest");
        if (!this.ctx.orderGreatest) {
            this.wsCheck("least");
        }
        return true;
    }

    private void copyNamespacesDecl() throws QueryException {
        if (this.declPres) {
            this.error(Err.DUPLCOPYNS, new Object[0]);
        }
        this.declPres = true;
        this.ctx.nsPreserve = this.wsConsumeWs("preserve");
        if (!this.ctx.nsPreserve) {
            this.wsCheck("no-preserve");
        }
        this.consume(44);
        this.ctx.nsInherit = this.wsConsumeWs("inherit");
        if (!this.ctx.nsInherit) {
            this.wsCheck("no-inherit");
        }
    }

    private boolean decFormatDecl(boolean def) throws QueryException {
        int n;
        if (def && !this.wsConsumeWs("decimal-format")) {
            return false;
        }
        byte[] name = new QNm(def ? Token.EMPTY : this.qName(Err.QNAMEINV)).full();
        if (this.ctx.decFormats.get(name) != null) {
            this.error(Err.DECDUPL, new Object[0]);
        }
        HashMap<String, String> sl = new HashMap<String, String>();
        do {
            n = sl.size();
            String prop = Token.string(this.ncName(null));
            String[] stringArray = QueryText.DECFORMATS;
            int n2 = QueryText.DECFORMATS.length;
            int n3 = 0;
            while (n3 < n2) {
                String s = stringArray[n3];
                if (prop.equals(s)) {
                    String key = s;
                    if (sl.get(key) != null) {
                        this.error(Err.DECDUPLPROP, key);
                    }
                    this.wsCheck("=");
                    sl.put(key, Token.string(this.stringLiteral()));
                    break;
                }
                ++n3;
            }
            if (sl.size() != 0) continue;
            this.error(Err.NODECLFORM, prop);
        } while (n != sl.size());
        this.ctx.decFormats.add(name, new DecFormatter(this.input(), sl));
        return true;
    }

    private boolean defaultCollationDecl() throws QueryException {
        if (!this.wsConsumeWs("collation")) {
            return false;
        }
        if (this.declColl) {
            this.error(Err.DUPLCOLL, new Object[0]);
        }
        this.declColl = true;
        byte[] coll = this.ctx.baseURI.resolve(Uri.uri(this.stringLiteral())).atom();
        if (!Token.eq(QueryText.URLCOLL, coll)) {
            this.error(Err.COLLWHICH, new Object[]{coll});
        }
        return true;
    }

    private void baseURIDecl() throws QueryException {
        if (this.declBase) {
            this.error(Err.DUPLBASE, new Object[0]);
        }
        this.declBase = true;
        this.ctx.baseURI = Uri.uri(this.stringLiteral());
    }

    private void schemaImport() throws QueryException {
        if (this.wsConsumeWs("namespace")) {
            this.ncName(Err.XPNAME);
            this.wsCheck("=");
        } else if (this.wsConsumeWs("default")) {
            this.wsCheck("element");
            this.wsCheck("namespace");
        }
        byte[] ns = this.stringLiteral();
        if (ns.length == 0) {
            this.error(Err.NSEMPTY, new Object[0]);
        }
        if (this.wsConsumeWs("at")) {
            do {
                this.stringLiteral();
            } while (this.wsConsumeWs(","));
        }
        this.error(Err.IMPLSCHEMA, new Object[0]);
    }

    private void moduleImport() throws QueryException {
        QNm name = null;
        if (this.wsConsumeWs("namespace")) {
            name = new QNm(this.ncName(Err.XPNAME));
            this.wsCheck("=");
        } else {
            name = new QNm();
        }
        byte[] uri = this.stringLiteral();
        if (uri.length == 0) {
            this.error(Err.NSMODURI, new Object[0]);
        }
        if (this.modules.contains(uri)) {
            this.error(Err.DUPLMODULE, new Object[]{uri});
        }
        name.uri(uri);
        this.ctx.ns.add(name, this.input());
        try {
            if (this.wsConsumeWs("at")) {
                do {
                    this.module(this.stringLiteral(), name.uri());
                } while (this.wsConsumeWs(","));
            } else {
                TokenSet pkgs = this.ctx.context.repo.nsDict().get(uri);
                if (pkgs != null) {
                    for (byte[] pkg : pkgs) {
                        if (pkg == null) continue;
                        this.loadPackage(pkg, new TokenSet(), new TokenSet());
                    }
                } else {
                    boolean found = false;
                    for (byte[] u : QueryText.MODULES) {
                        found |= Token.eq(uri, u);
                    }
                    for (byte[] path : this.ctx.modDeclared) {
                        if (!Token.eq(this.ctx.modDeclared.get(path), uri)) continue;
                        this.module(path, name.uri());
                        found = true;
                    }
                    if (!found) {
                        this.error(Err.NOMODULE, new Object[]{uri});
                    }
                }
            }
        }
        catch (StackOverflowError ex) {
            this.error(Err.CIRCMODULE, new Object[0]);
        }
    }

    private void module(byte[] path, Uri uri) throws QueryException {
        byte[] u = this.ctx.modParsed.get(path);
        if (u != null) {
            if (!Token.eq(uri.atom(), u)) {
                this.error(Err.WRONGMODULE, uri, path);
            }
            return;
        }
        this.ctx.modParsed.add(path, uri.atom());
        IO io = this.io(Token.string(path));
        String qu = null;
        try {
            qu = Token.string(io.content());
        }
        catch (IOException ex) {
            this.error(Err.NOMODULEFILE, io);
        }
        NSLocal ns = this.ctx.ns;
        this.ctx.ns = new NSLocal();
        new QueryParser(qu, this.ctx).parse(io, uri);
        this.ctx.ns = ns;
        this.modules.add(uri.atom());
    }

    private void loadPackage(byte[] pkgName, TokenSet pkgsToLoad, TokenSet pkgsLoaded) throws QueryException {
        IOFile pkgDir;
        IOFile pkgDesc;
        if (pkgsLoaded.id(pkgName) != 0) {
            return;
        }
        byte[] pDir = this.ctx.context.repo.pkgDict().get(pkgName);
        if (pDir == null) {
            this.error(Err.NECPKGNOTINST, new Object[]{pkgName});
        }
        if (!((IO)(pkgDesc = new IOFile(pkgDir = this.ctx.context.repo.path(Token.string(pDir)), "expath-pkg.xml"))).exists()) {
            Util.debug("Missing package descriptor for package '%'", Token.string(pkgName));
        }
        Package pkg = new PkgParser(this.ctx.context.repo, this.input()).parse(pkgDesc);
        IOFile jarDesc = new IOFile(pkgDir, PkgText.JARDESC);
        if (((IO)jarDesc).exists()) {
            this.loadJars(jarDesc, pkgDir, Token.string(pkg.abbrev));
        }
        if (pkg.dep.size() != 0) {
            pkgsToLoad.add(pkgName);
        }
        for (Package.Dependency d : pkg.dep) {
            if (d.pkg == null) continue;
            byte[] depPkg = new PkgValidator(this.ctx.context.repo, this.input()).depPkg(d);
            if (depPkg == null) {
                this.error(Err.NECPKGNOTINST, Token.string(d.pkg));
                continue;
            }
            if (pkgsToLoad.id(depPkg) != 0) {
                this.error(Err.CIRCMODULE, new Object[0]);
            }
            this.loadPackage(depPkg, pkgsToLoad, pkgsLoaded);
        }
        for (Package.Component comp : pkg.comps) {
            String path = new IOFile(new IOFile(pkgDir, Token.string(pkg.abbrev)), Token.string(comp.file)).path();
            this.module(Token.token(path), Uri.uri(comp.uri));
        }
        if (pkgsToLoad.id(pkgName) != 0) {
            pkgsToLoad.delete(pkgName);
        }
        pkgsLoaded.add(pkgName);
    }

    private void loadJars(IO jarDesc, IOFile pkgDir, String modDir) throws QueryException {
        JarDesc desc = new JarParser(this.ctx.context, this.input()).parse(jarDesc);
        URL[] urls = new URL[desc.jars.size()];
        int i = 0;
        for (byte[] jar : desc.jars) {
            IOFile path = new IOFile(new IOFile(pkgDir, modDir), Token.string(jar));
            try {
                urls[i++] = new URL("file:" + path);
            }
            catch (MalformedURLException ex) {
                Util.debug(ex.getMessage(), new Object[0]);
            }
        }
        Reflect.setJarLoader(new JarLoader(urls));
        for (byte[] c : desc.classes) {
            this.ctx.ns.add(new QNm(Token.concat(Token.token("java:"), c)), this.input());
        }
    }

    private void contextItemDecl() throws QueryException {
        SeqType st;
        this.wsCheck("item");
        if (this.declItem) {
            this.error(Err.DUPLITEM, new Object[0]);
        }
        this.declItem = true;
        if (this.module != null) {
            this.error(Err.DECITEM, new Object[0]);
        }
        if ((st = this.optAsType()) != null && st.type == AtomType.EMP) {
            this.error(Err.NOTYPE, st);
        }
        this.ctx.initType = st;
        if (!this.wsConsumeWs("external")) {
            this.wsCheck(":=");
        } else if (!this.wsConsumeWs(":=")) {
            return;
        }
        this.ctx.initExpr = this.check(this.single(), Err.NOVARDECL);
    }

    private void varDecl() throws QueryException {
        Var old;
        Var v = this.typedVar();
        if (this.module != null && !v.name.uri().eq(this.module.uri())) {
            this.error(Err.MODNS, v);
        }
        if ((old = this.ctx.vars.get(v.name)) != null && old.declared) {
            this.error(Err.VARDEFINE, old);
        }
        (old != null ? old : v).declared = true;
        if (this.wsConsumeWs("external")) {
            if (old != null && v.type != null) {
                old.reset(v.type);
            }
            if (this.ctx.xquery3 && this.wsConsumeWs(":=")) {
                v.bind(this.check(this.single(), Err.NOVARDECL), this.ctx);
            }
        } else {
            this.wsCheck(":=");
            v.bind(this.check(this.single(), Err.NOVARDECL), this.ctx);
        }
        if (old == null) {
            this.ctx.vars.setGlobal(v);
        }
    }

    private Var typedVar() throws QueryException {
        return Var.create(this.ctx, this.input(), this.varName(), this.optAsType());
    }

    private SeqType optAsType() throws QueryException {
        return this.wsConsumeWs("as") ? this.sequenceType() : null;
    }

    private void constructionDecl() throws QueryException {
        if (this.declConstr) {
            this.error(Err.DUPLCONS, new Object[0]);
        }
        this.declConstr = true;
        this.ctx.construct = this.wsConsumeWs("preserve");
        if (!this.ctx.construct) {
            this.wsCheck("strip");
        }
    }

    private void functionDecl(boolean up) throws QueryException {
        this.skipWS();
        InputInfo ii = this.input();
        QNm name = new QNm(this.qName(Err.FUNCNAME));
        name.uri(name.ns() ? this.ctx.ns.uri(name.pref(), false, this.input()) : this.ctx.nsFunc);
        if (this.module != null && !name.uri().eq(this.module.uri())) {
            this.error(Err.MODNS, name);
        }
        this.wsCheck("(");
        int s = this.ctx.vars.size();
        Var[] args = this.paramList();
        this.wsCheck(")");
        UserFunc func = new UserFunc(ii, name, args, this.optAsType(), true);
        func.updating = up;
        this.ctx.funcs.add(func, this);
        if (!this.wsConsumeWs("external")) {
            func.expr = this.enclosed(Err.NOFUNBODY);
        }
        this.ctx.vars.reset(s);
    }

    private Var[] paramList() throws QueryException {
        Var[] args = new Var[]{};
        this.skipWS();
        while (true) {
            if (this.curr() != '$') {
                if (args.length == 0) break;
                this.check(36);
            }
            Var var = this.typedVar();
            this.ctx.vars.add(var);
            Var[] varArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Var v = varArray[n2];
                if (v.name.eq(var.name)) {
                    this.error(Err.FUNCDUPL, var);
                }
                ++n2;
            }
            args = Array.add(args, var);
            if (!this.consume(44)) break;
            this.skipWS();
        }
        return args;
    }

    private Expr enclosed(Err err) throws QueryException {
        this.wsCheck("{");
        Expr e = this.check(this.expr(), err);
        this.wsCheck("}");
        return e;
    }

    private Expr expr() throws QueryException {
        Expr e = this.single();
        if (e == null) {
            if (this.more()) {
                return null;
            }
            if (this.alter != null) {
                this.error();
            } else {
                this.error(Err.NOEXPR, new Object[0]);
            }
        }
        if (!this.wsConsume(",")) {
            return e;
        }
        Expr[] l = new Expr[]{e};
        do {
            l = this.add(l, this.single());
        } while (this.wsConsume(","));
        return new List(this.input(), l);
    }

    private Expr single() throws QueryException {
        this.alter = null;
        Expr e = this.gflwor();
        if (e == null) {
            e = this.quantified();
        }
        if (e == null) {
            e = this.switchh();
        }
        if (e == null) {
            e = this.typeswitch();
        }
        if (e == null) {
            e = this.iff();
        }
        if (e == null) {
            e = this.tryCatch();
        }
        if (e == null) {
            e = this.insert();
        }
        if (e == null) {
            e = this.deletee();
        }
        if (e == null) {
            e = this.rename();
        }
        if (e == null) {
            e = this.replace();
        }
        if (e == null) {
            e = this.transform();
        }
        if (e == null) {
            e = this.or();
        }
        return e;
    }

    private Expr gflwor() throws QueryException {
        int s = this.ctx.vars.size();
        ForLet[] fl = this.forLet();
        if (fl == null) {
            return null;
        }
        Expr where = null;
        if (this.wsConsumeWs("where")) {
            this.ap = this.qp;
            where = this.check(this.single(), Err.NOWHERE);
            this.alter = Err.NOWHERE;
        }
        Var[][] group = null;
        if (this.ctx.xquery3 && this.wsConsumeWs("group")) {
            this.wsCheck("by");
            this.ap = this.qp;
            Var[] grp = null;
            do {
                grp = this.groupSpec(fl, grp);
            } while (this.wsConsume(","));
            ObjList<Var> ng = new ObjList<Var>();
            Map ngp = Map.EMPTY;
            ForLet[] forLetArray = fl;
            int n = fl.length;
            int n2 = 0;
            while (n2 < n) {
                ForLet f = forLetArray[n2];
                Var[] varArray = f.vars();
                int n3 = varArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    block18: {
                        Var v = varArray[n4];
                        Value old = ngp.get(v.name, null);
                        int pos = old.item() ? (int)old.itemAt(0L).itr(null) : -1;
                        Var[] varArray2 = grp;
                        int n5 = grp.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Var g = varArray2[n6];
                            if (v.is(g)) {
                                if (pos >= 0) {
                                    ng.delete(pos);
                                    ngp = ngp.delete(old.itemAt(0L), null);
                                }
                                break block18;
                            }
                            ++n6;
                        }
                        if (pos >= 0) {
                            ng.set(pos, v);
                        } else {
                            ng.add(v);
                            ngp = ngp.insert(v.name, Itr.get(ng.size() - 1), null);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            Var[] ngrp = new Var[ng.size()];
            int i = ng.size();
            while (--i >= 0) {
                Var v = (Var)ng.get(i);
                ngrp[i] = Var.create(this.ctx, this.input(), v.name, v.type != null && v.type.one() ? SeqType.get(v.type.type, SeqType.Occ.OM) : null);
                this.ctx.vars.add(ngrp[i]);
            }
            group = new Var[][]{grp, ng.toArray(new Var[ng.size()]), ngrp};
            this.alter = Err.GRPBY;
        }
        OrderBy[] order = null;
        boolean stable = this.wsConsumeWs("stable");
        if (stable) {
            this.wsCheck("order");
        }
        if (stable || this.wsConsumeWs("order")) {
            this.wsCheck("by");
            this.ap = this.qp;
            do {
                order = this.orderSpec(order);
            } while (this.wsConsume(","));
            if (order != null) {
                order = Array.add(order, new OrderByStable(this.input()));
            }
            this.alter = Err.ORDERBY;
        }
        if (!this.wsConsumeWs("return")) {
            if (this.alter != null) {
                this.error();
            }
            this.error(where == null ? Err.FLWORWHERE : (order == null ? Err.FLWORORD : Err.FLWORRET), new Object[0]);
        }
        Expr ret = this.check(this.single(), Err.NORETURN);
        this.ctx.vars.reset(s);
        return GFLWOR.get(fl, where, order, group, ret, this.input());
    }

    private ForLet[] forLet() throws QueryException {
        ForLet[] fl = null;
        boolean comma = false;
        while (true) {
            boolean fr;
            boolean score;
            boolean bl = score = !(fr = this.wsConsumeWs("for", "$", Err.NOFOR)) && this.wsConsumeWs("let", "score", Err.NOLET);
            if (score) {
                this.wsCheck("score");
            } else if (!fr && !this.wsConsumeWs("let", "$", Err.NOLET)) {
                return fl;
            }
            do {
                if (comma && !fr) {
                    score = this.wsConsumeWs("score");
                }
                QNm name = this.varName();
                SeqType type = score ? SeqType.DBL : this.optAsType();
                Var var = Var.create(this.ctx, this.input(), name, type);
                Var ps = fr && this.wsConsumeWs("at") ? Var.create(this.ctx, this.input(), this.varName(), SeqType.ITR) : null;
                Var sc = fr && this.wsConsumeWs("score") ? Var.create(this.ctx, this.input(), this.varName(), SeqType.DBL) : null;
                this.wsCheck(fr ? "in" : ":=");
                Expr e = this.check(this.single(), Err.NOVARDECL);
                this.ctx.vars.add(var);
                if (ps != null) {
                    if (name.eq(ps.name)) {
                        this.error(Err.DUPLVAR, var);
                    }
                    this.ctx.vars.add(ps);
                }
                if (sc != null) {
                    if (name.eq(sc.name)) {
                        this.error(Err.DUPLVAR, var);
                    }
                    if (ps != null && ps.name.eq(sc.name)) {
                        this.error(Err.DUPLVAR, ps);
                    }
                    this.ctx.vars.add(sc);
                }
                fl = fl == null ? new ForLet[1] : Arrays.copyOf(fl, fl.length + 1);
                fl[fl.length - 1] = fr ? new For(this.input(), e, var, ps, sc) : new Let(this.input(), e, var, score);
                score = false;
                comma = true;
            } while (this.wsConsume(","));
            comma = false;
        }
    }

    private OrderBy[] orderSpec(OrderBy[] order) throws QueryException {
        OrderBy[] orderByArray;
        byte[] coll;
        boolean least;
        Expr e = this.check(this.single(), Err.ORDERBY);
        boolean desc = false;
        if (!this.wsConsumeWs("ascending")) {
            desc = this.wsConsumeWs("descending");
        }
        boolean bl = least = !this.ctx.orderGreatest;
        if (this.wsConsumeWs("empty")) {
            boolean bl2 = least = !this.wsConsumeWs("greatest");
            if (least) {
                this.wsCheck("least");
            }
        }
        if (this.wsConsumeWs("collation") && !Token.eq(QueryText.URLCOLL, coll = this.stringLiteral())) {
            this.error(Err.INVCOLL, new Object[]{coll});
        }
        if (e.empty()) {
            return order;
        }
        OrderByExpr ord = new OrderByExpr(this.input(), e, desc, least);
        if (order == null) {
            OrderBy[] orderByArray2 = new OrderBy[1];
            orderByArray = orderByArray2;
            orderByArray2[0] = ord;
        } else {
            orderByArray = Array.add(order, ord);
        }
        return orderByArray;
    }

    private Var[] groupSpec(ForLet[] fl, Var[] group) throws QueryException {
        Var[] varArray;
        byte[] coll;
        Var v = this.checkVar(this.varName(), Err.GVARNOTDEFINED);
        boolean dec = false;
        ForLet[] forLetArray = fl;
        int n = fl.length;
        int n2 = 0;
        while (n2 < n) {
            ForLet f = forLetArray[n2];
            if (f.declares(v)) {
                dec = true;
                break;
            }
            ++n2;
        }
        if (!dec) {
            throw Err.GVARNOTDEFINED.thrw(this.input(), v);
        }
        if (this.wsConsumeWs("collation") && !Token.eq(QueryText.URLCOLL, coll = this.stringLiteral())) {
            this.error(Err.INVCOLL, new Object[]{coll});
        }
        if (group == null) {
            Var[] varArray2 = new Var[1];
            varArray = varArray2;
            varArray2[0] = v;
        } else {
            varArray = Array.add(group, v);
        }
        return varArray;
    }

    private Expr quantified() throws QueryException {
        boolean some = this.wsConsumeWs("some", "$", Err.NOSOME);
        if (!some && !this.wsConsumeWs("every", "$", Err.NOSOME)) {
            return null;
        }
        int s = this.ctx.vars.size();
        For[] fl = new For[]{};
        do {
            Var var = this.typedVar();
            this.wsCheck("in");
            Expr e = this.check(this.single(), Err.NOSOME);
            this.ctx.vars.add(var);
            fl = Array.add(fl, new For(this.input(), e, var));
        } while (this.wsConsume(","));
        this.wsCheck("satisfies");
        Expr e = this.check(this.single(), Err.NOSOME);
        this.ctx.vars.reset(s);
        return new Quantifier(this.input(), fl, e, !some);
    }

    private Expr switchh() throws QueryException {
        if (!this.wsConsumeWs("switch", "(", Err.TYPEPAR)) {
            return null;
        }
        this.wsCheck("(");
        Expr[] exprs = new Expr[]{this.check(this.expr(), Err.NOSWITCH)};
        this.wsCheck(")");
        block0: while (true) {
            Expr[] cases = new Expr[]{};
            while (this.wsConsumeWs("case")) {
                cases = this.add(cases, this.single());
            }
            if (cases.length == 0) break;
            this.wsCheck("return");
            Expr ret = this.single();
            Expr[] exprArray = cases;
            int n = cases.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                Expr c = exprArray[n2];
                exprs = this.add(this.add(exprs, c), ret);
                ++n2;
            }
            break;
        }
        if (exprs.length == 1) {
            this.error(Err.WRONGEND, "case");
        }
        this.wsCheck("default");
        this.wsCheck("return");
        exprs = this.add(exprs, this.single());
        return new Switch(this.input(), exprs);
    }

    private Expr typeswitch() throws QueryException {
        if (!this.wsConsumeWs("typeswitch", "(", Err.TYPEPAR)) {
            return null;
        }
        this.wsCheck("(");
        Expr ts = this.check(this.expr(), Err.NOTYPESWITCH);
        this.wsCheck(")");
        TypeCase[] cases = new TypeCase[]{};
        int s = this.ctx.vars.size();
        boolean cs = true;
        do {
            if (!(cs = this.wsConsumeWs("case"))) {
                this.wsCheck("default");
            }
            this.skipWS();
            QNm name = null;
            if (this.curr(36)) {
                name = this.varName();
                if (cs) {
                    this.wsCheck("as");
                }
            }
            Var v = Var.create(this.ctx, this.input(), name, cs ? this.sequenceType() : null);
            if (name != null) {
                this.ctx.vars.add(v);
            }
            this.wsCheck("return");
            Expr ret = this.check(this.single(), Err.NOTYPESWITCH);
            cases = Array.add(cases, new TypeCase(this.input(), v, ret));
            this.ctx.vars.reset(s);
        } while (cs);
        if (cases.length == 1) {
            this.error(Err.NOTYPESWITCH, new Object[0]);
        }
        return new TypeSwitch(this.input(), ts, cases);
    }

    private Expr iff() throws QueryException {
        if (!this.wsConsumeWs("if", "(", Err.IFPAR)) {
            return null;
        }
        this.wsCheck("(");
        Expr iff = this.check(this.expr(), Err.NOIF);
        this.wsCheck(")");
        if (!this.wsConsumeWs("then")) {
            this.error(Err.NOIF, new Object[0]);
        }
        Expr thn = this.check(this.single(), Err.NOIF);
        if (!this.wsConsumeWs("else")) {
            this.error(Err.NOIF, new Object[0]);
        }
        Expr els = this.check(this.single(), Err.NOIF);
        return new If(this.input(), iff, thn, els);
    }

    private Expr or() throws QueryException {
        Expr e = this.and();
        if (!this.wsConsumeWs("or")) {
            return e;
        }
        Expr[] list = new Expr[]{e};
        do {
            list = this.add(list, this.and());
        } while (this.wsConsumeWs("or"));
        return new Or(this.input(), list);
    }

    private Expr and() throws QueryException {
        Expr e = this.comparison();
        if (!this.wsConsumeWs("and")) {
            return e;
        }
        Expr[] list = new Expr[]{e};
        do {
            list = this.add(list, this.comparison());
        } while (this.wsConsumeWs("and"));
        return new And(this.input(), list);
    }

    private Expr comparison() throws QueryException {
        Expr e = this.ftContains();
        if (e != null) {
            Enum c;
            Enum[] enumArray = CmpV.Op.values();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                c = enumArray[n2];
                if (this.wsConsumeWs(((CmpV.Op)c).name)) {
                    return new CmpV(this.input(), e, this.check(this.ftContains(), Err.CMPEXPR), (CmpV.Op)c);
                }
                ++n2;
            }
            enumArray = CmpN.Op.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                c = enumArray[n2];
                if (this.wsConsumeWs(((CmpN.Op)c).name)) {
                    return new CmpN(this.input(), e, this.check(this.ftContains(), Err.CMPEXPR), (CmpN.Op)c);
                }
                ++n2;
            }
            enumArray = CmpG.Op.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                c = enumArray[n2];
                if (this.wsConsume(((CmpG.Op)c).name)) {
                    return new CmpG(this.input(), e, this.check(this.ftContains(), Err.CMPEXPR), (CmpG.Op)c);
                }
                ++n2;
            }
        }
        return e;
    }

    private Expr ftContains() throws QueryException {
        Expr e = this.stringConcat();
        int p = this.qp;
        if (this.consume(61) && this.consume(62) || this.consume(60) && this.consume(45)) {
            this.skipWS();
        } else if (!this.wsConsumeWs("contains") || !this.wsConsumeWs("text")) {
            this.qp = p;
            return e;
        }
        FTExpr select = this.ftSelection(false);
        if (this.wsConsumeWs("without")) {
            this.wsCheck("content");
            this.union();
            this.error(Err.FTIGNORE, new Object[0]);
        }
        return new FTContains(e, select, this.input());
    }

    private Expr stringConcat() throws QueryException {
        Expr e = this.range();
        if (!this.consume("||")) {
            return e;
        }
        Expr[] list = new Expr[]{e};
        do {
            list = this.add(list, this.range());
        } while (this.wsConsume("||"));
        return new Concat(this.input(), list);
    }

    private Expr range() throws QueryException {
        Expr e = this.additive();
        if (!this.wsConsumeWs("to")) {
            return e;
        }
        return new Range(this.input(), e, this.check(this.additive(), Err.INCOMPLETE));
    }

    private Expr additive() throws QueryException {
        Expr e = this.multiplicative();
        while (true) {
            Calc c;
            Calc calc = this.consume(43) ? Calc.PLUS : (c = this.consume(45) ? Calc.MINUS : null);
            if (c == null) break;
            e = new Arith(this.input(), e, this.check(this.multiplicative(), Err.CALCEXPR), c);
        }
        return e;
    }

    private Expr multiplicative() throws QueryException {
        Expr e = this.union();
        while (e != null) {
            Calc c;
            Calc calc = this.consume(42) ? Calc.MULT : (this.wsConsumeWs("div") ? Calc.DIV : (this.wsConsumeWs("idiv") ? Calc.IDIV : (c = this.wsConsumeWs("mod") ? Calc.MOD : null)));
            if (c == null) break;
            e = new Arith(this.input(), e, this.check(this.union(), Err.CALCEXPR), c);
        }
        return e;
    }

    private Expr union() throws QueryException {
        Expr e = this.intersect();
        if (e == null || !this.isUnion()) {
            return e;
        }
        Expr[] list = new Expr[]{e};
        do {
            list = this.add(list, this.intersect());
        } while (this.isUnion());
        return new Union(this.input(), list);
    }

    private boolean isUnion() throws QueryException {
        if (this.wsConsumeWs("union")) {
            return true;
        }
        int p = this.qp;
        if (this.consume("|") && !this.consume("|")) {
            return true;
        }
        this.qp = p;
        return false;
    }

    private Expr intersect() throws QueryException {
        Expr e = this.instanceoff();
        if (this.wsConsumeWs("intersect")) {
            Expr[] list = new Expr[]{e};
            do {
                list = this.add(list, this.instanceoff());
            } while (this.wsConsumeWs("intersect"));
            return new InterSect(this.input(), list);
        }
        if (this.wsConsumeWs("except")) {
            Expr[] list = new Expr[]{e};
            do {
                list = this.add(list, this.instanceoff());
            } while (this.wsConsumeWs("except"));
            return new Except(this.input(), list);
        }
        return e;
    }

    private Expr instanceoff() throws QueryException {
        Expr e = this.treat();
        if (!this.wsConsumeWs("instance")) {
            return e;
        }
        this.wsCheck("of");
        return new Instance(this.input(), e, this.sequenceType());
    }

    private Expr treat() throws QueryException {
        Expr e = this.castable();
        if (!this.wsConsumeWs("treat")) {
            return e;
        }
        this.wsCheck("as");
        return new Treat(this.input(), e, this.sequenceType());
    }

    private Expr castable() throws QueryException {
        Expr e = this.cast();
        if (!this.wsConsumeWs("castable")) {
            return e;
        }
        this.wsCheck("as");
        return new Castable(this.input(), e, this.simpleType());
    }

    private Expr cast() throws QueryException {
        Expr e = this.unary();
        if (!this.wsConsumeWs("cast")) {
            return e;
        }
        this.wsCheck("as");
        return new Cast(this.input(), e, this.simpleType());
    }

    private Expr unary() throws QueryException {
        boolean minus = false;
        boolean found = false;
        while (true) {
            this.skipWS();
            if (this.consume(45)) {
                minus ^= true;
                found = true;
                continue;
            }
            if (!this.consume(43)) break;
            found = true;
        }
        Expr e = this.value();
        return found ? new Unary(this.input(), this.check(e, Err.EVALUNARY), minus) : e;
    }

    private Expr value() throws QueryException {
        this.validate();
        Expr e = this.path();
        return e != null ? e : this.extension();
    }

    private void validate() throws QueryException {
        if (this.wsConsumeWs("validate")) {
            if (!this.wsConsumeWs("strict") && !this.wsConsumeWs("lax") && this.wsConsumeWs("type")) {
                this.qName(Err.QNAMEINV);
            }
            this.wsCheck("{");
            this.check(this.single(), Err.NOVALIDATE);
            this.wsCheck("}");
            this.error(Err.IMPLVAL, new Object[0]);
        }
    }

    private Expr extension() throws QueryException {
        Expr[] pragmas = this.pragma();
        return pragmas.length == 0 ? null : new Extension(this.input(), pragmas, this.enclosed(Err.NOPRAGMA));
    }

    private Expr[] pragma() throws QueryException {
        Expr[] pragmas = new Expr[]{};
        while (this.wsConsumeWs("(#")) {
            char c;
            this.skipWS();
            QNm name = new QNm(this.qName(Err.PRAGMAINV), this.ctx, this.input());
            if (!name.ns()) {
                this.error(Err.NSMISS, name);
            }
            if ((c = this.curr()) != '#' && !Token.ws(c)) {
                this.error(Err.PRAGMAINV, new Object[0]);
            }
            this.tok.reset();
            while (c != '#' || this.next() != ')') {
                if (c == '\u0000') {
                    this.error(Err.PRAGMAINV, new Object[0]);
                }
                this.tok.add(this.consume());
                c = this.curr();
            }
            pragmas = this.add(pragmas, new Pragma(name, this.tok.trim().finish(), this.input()));
            this.qp += 2;
        }
        return pragmas;
    }

    private Expr path() throws QueryException {
        Expr root;
        int s;
        this.checkInit();
        int n = this.consume(47) ? (this.consume(47) ? 2 : 1) : (s = 0);
        if (s > 0) {
            this.checkAxis(s == 2 ? Axis.DESC : Axis.CHILD);
        }
        this.qm = this.qp;
        Expr ex = this.step();
        if (ex == null) {
            if (s == 2) {
                if (this.more()) {
                    this.checkInit();
                }
                this.error(Err.PATHMISS, new Object[0]);
            }
            return s == 1 ? new Root(this.input()) : null;
        }
        boolean slash = this.consume(47);
        boolean step = ex instanceof AxisStep;
        if (!slash && s == 0 && !step) {
            return ex;
        }
        Expr[] list = new Expr[]{};
        if (s == 2) {
            list = this.add(list, this.descOrSelf());
        }
        Expr expr = s > 0 ? new Root(this.input()) : (root = !step ? ex : null);
        if (root != ex) {
            list = this.add(list, ex);
        }
        if (slash) {
            do {
                boolean desc = this.consume(47);
                this.qm = this.qp;
                if (desc) {
                    list = this.add(list, this.descOrSelf());
                }
                this.checkAxis(desc ? Axis.DESC : Axis.CHILD);
                Expr st = this.step();
                if (st == null) {
                    this.error(Err.PATHMISS, new Object[0]);
                }
                if (st instanceof Context) continue;
                list = this.add(list, st);
            } while (this.consume(47));
        }
        if (list.length == 0) {
            list = this.add(list, AxisStep.get(this.input(), Axis.SELF, Test.NOD, new Expr[0]));
        }
        return Path.get(this.input(), root, list);
    }

    private AxisStep descOrSelf() {
        return AxisStep.get(this.input(), Axis.DESCORSELF, Test.NOD, new Expr[0]);
    }

    protected void checkInit() {
    }

    protected void checkAxis(Axis axis) {
    }

    protected void checkTest(Test test, boolean attr) {
    }

    protected void checkPred(boolean open) {
    }

    private Expr step() throws QueryException {
        Expr e = this.postfix();
        return e != null ? e : this.axis();
    }

    private AxisStep axis() throws QueryException {
        Axis ax = null;
        Test test = null;
        if (this.wsConsume("..")) {
            ax = Axis.PARENT;
            test = Test.NOD;
            this.checkTest(test, false);
        } else if (this.consume(64)) {
            ax = Axis.ATTR;
            test = this.test(true);
            this.checkTest(test, true);
            if (test == null) {
                --this.qp;
                this.error(Err.NOATTNAME, new Object[0]);
            }
        } else {
            Axis[] axisArray = Axis.values();
            int n = axisArray.length;
            int n2 = 0;
            while (n2 < n) {
                Axis a = axisArray[n2];
                if (this.wsConsumeWs(a.name, "::", Err.NOLOCSTEP)) {
                    this.wsConsume("::");
                    this.ap = this.qp;
                    ax = a;
                    test = this.test(a == Axis.ATTR);
                    this.checkTest(test, a == Axis.ATTR);
                    break;
                }
                ++n2;
            }
        }
        if (ax == null) {
            ax = Axis.CHILD;
            test = this.test(false);
            if (test != null && test.type == NodeType.ATT) {
                ax = Axis.ATTR;
            }
            this.checkTest(test, ax == Axis.ATTR);
        }
        if (test == null) {
            return null;
        }
        Expr[] pred = new Expr[]{};
        while (this.wsConsume("[")) {
            this.checkPred(true);
            pred = this.add(pred, this.expr());
            this.wsCheck("]");
            this.checkPred(false);
        }
        return AxisStep.get(this.input(), ax, test, pred);
    }

    private Test test(boolean att) throws QueryException {
        int p = this.qp;
        char ch = this.curr();
        if (XMLToken.isNCStartChar(ch)) {
            byte[] name = this.qName(null);
            int p2 = this.qp;
            if (this.wsConsumeWs("(")) {
                NodeType type = NodeType.find(new QNm(name, this.ctx, this.input()));
                if (type != null) {
                    this.tok.reset();
                    while (!this.consume(")")) {
                        if (this.curr(0)) {
                            this.error(Err.TESTINCOMPLETE, new Object[0]);
                        }
                        this.tok.add(this.consume());
                    }
                    this.skipWS();
                    return this.tok.trim().size() == 0 ? Test.get(type) : this.kindTest(type, this.tok.finish());
                }
            } else {
                this.qp = p2;
                if (Token.contains(name, 58)) {
                    this.skipWS();
                    return new NameTest(new QNm(name, this.ctx, this.input()), Test.Name.STD, att, this.input());
                }
                if (!this.consume(58)) {
                    this.skipWS();
                    QNm nm = new QNm(name, att ? Uri.EMPTY : null);
                    return new NameTest(nm, Test.Name.STD, att, this.input());
                }
                if (this.consume(42)) {
                    QNm nm = new QNm(Token.EMPTY, this.ctx.ns.uri(name, false, this.input()));
                    return new NameTest(nm, Test.Name.NS, att, this.input());
                }
            }
        } else if (this.consume(42)) {
            if (!this.consume(58)) {
                return new NameTest(att, this.input());
            }
            return new NameTest(new QNm(this.qName(Err.QNAMEINV)), Test.Name.NAME, att, this.input());
        }
        this.qp = p;
        return null;
    }

    private Expr postfix() throws QueryException {
        Expr old;
        Expr e = this.primary();
        do {
            old = e;
            if (this.wsConsume("[")) {
                if (e == null) {
                    this.error(Err.PREDMISSING, new Object[0]);
                }
                Expr[] pred = new Expr[]{};
                do {
                    pred = this.add(pred, this.expr());
                    this.wsCheck("]");
                } while (this.wsConsume("["));
                e = new Filter(this.input(), e, pred);
                continue;
            }
            if (e == null) continue;
            Expr[] args = this.argumentList(e);
            if (args == null) break;
            Var[] part = new Var[args.length];
            boolean pt = this.partial(args, part);
            e = new DynFuncCall(this.input(), e, args);
            if (!pt) continue;
            e = new PartFunApp(this.input(), e, part);
        } while (e != old);
        return e;
    }

    private boolean partial(Expr[] args, Var[] vars) {
        InputInfo ii = this.input();
        boolean found = false;
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                vars[i] = this.ctx.uniqueVar(ii, null);
                args[i] = new VarRef(ii, vars[i]);
                found = true;
            }
            ++i;
        }
        return found;
    }

    private Expr primary() throws QueryException {
        this.skipWS();
        char c = this.curr();
        if (c == '$') {
            return new VarRef(this.input(), this.checkVar(this.varName(), Err.VARUNDEF));
        }
        if (c == '(' && this.next() != '#') {
            return this.parenthesized();
        }
        if (c == '<') {
            return this.constructor();
        }
        if (XMLToken.isNCStartChar(c)) {
            Expr e;
            if (this.ctx.xquery3 && (e = this.functionItem()) != null) {
                return e;
            }
            e = this.functionCall();
            if (e != null) {
                return e;
            }
            e = this.compConstructor();
            if (e != null) {
                return e;
            }
            if (this.wsConsumeWs("ordered", "{", Err.INCOMPLETE) || this.wsConsumeWs("unordered", "{", Err.INCOMPLETE)) {
                return this.enclosed(Err.NOENCLEXPR);
            }
            if (this.wsConsumeWs("map", "{", Err.INCOMPLETE)) {
                return this.mapLiteral();
            }
        }
        if (c == '.' && !Token.digit(this.next())) {
            if (this.next() == '.') {
                return null;
            }
            this.consume(46);
            return new Context(this.input());
        }
        if (Token.digit(c) || c == '.') {
            return this.numericLiteral(false);
        }
        return this.quote(c) ? Str.get(this.stringLiteral()) : null;
    }

    private Expr mapLiteral() throws QueryException {
        this.wsCheck("{");
        Expr[] args = new Expr[]{};
        if (!this.wsConsume("}")) {
            do {
                args = Array.add(args, this.check(this.single(), Err.INVMAPKEY));
                this.wsCheck(":=");
                args = Array.add(args, this.check(this.single(), Err.INVMAPVAL));
            } while (this.wsConsume(","));
            this.wsCheck("}");
        }
        return new LitMap(this.input(), args);
    }

    private Expr functionItem() throws QueryException {
        int pos = this.qp;
        if (this.wsConsume("function") && this.wsConsume("(")) {
            int s = this.ctx.vars.size();
            Var[] args = this.paramList();
            this.wsCheck(")");
            SeqType type = this.optAsType();
            Expr body = this.enclosed(Err.NOFUNBODY);
            this.ctx.vars.reset(s);
            return new InlineFunc(this.input(), type, args, body);
        }
        this.qp = pos;
        this.skipWS();
        byte[] fn = this.qName(null);
        if (fn.length > 0 && this.consume("#")) {
            QNm name = new QNm(fn);
            if (name.ns()) {
                this.ctx.ns.uri(name);
            } else {
                name.uri(this.ctx.nsFunc);
            }
            long cardinal = ((Itr)this.numericLiteral(true)).itr(null);
            if (cardinal < 0L || cardinal > Integer.MAX_VALUE) {
                this.error(Err.FUNCUNKNOWN, new Object[]{fn});
            }
            Expr[] args = new Expr[(int)cardinal];
            Var[] vars = new Var[args.length];
            this.partial(args, vars);
            TypedFunc f = this.ctx.funcs.get(name, args, this.ctx, this);
            if (f == null) {
                this.error(Err.FUNCUNKNOWN, new Object[]{fn});
            }
            return new LitFunc(this.input(), name, f, vars);
        }
        this.qp = pos;
        return null;
    }

    private Expr numericLiteral(boolean itr) throws QueryException {
        this.tok.reset();
        while (Token.digit(this.curr())) {
            this.tok.add(this.consume());
        }
        if (this.consume(46)) {
            if (itr) {
                this.error(Err.NUMBERITR, new Object[0]);
            }
            return this.decimalLiteral();
        }
        if (XMLToken.isNCStartChar(this.curr())) {
            return this.checkDbl();
        }
        long l = Token.toLong(this.tok.finish());
        if (l == Long.MIN_VALUE) {
            this.error(Err.RANGE, this.tok);
        }
        return Itr.get(l);
    }

    /*
     * Unable to fully structure code
     */
    private Expr decimalLiteral() throws QueryException {
        this.tok.add(46);
        if (!XMLToken.isNCStartChar(this.curr())) ** GOTO lbl7
        return this.checkDbl();
lbl-1000:
        // 1 sources

        {
            this.tok.add(this.consume());
lbl7:
            // 2 sources

            ** while (Token.digit((int)this.curr()))
        }
lbl8:
        // 1 sources

        return XMLToken.isNCStartChar(this.curr()) != false ? this.checkDbl() : new Dec(this.tok.finish());
    }

    private Expr checkDbl() throws QueryException {
        if (!this.consume(101) && !this.consume(69)) {
            this.error(Err.NUMBERWS, new Object[0]);
        }
        this.tok.add(101);
        if (this.curr(43) || this.curr(45)) {
            this.tok.add(this.consume());
        }
        int s = this.tok.size();
        while (Token.digit(this.curr())) {
            this.tok.add(this.consume());
        }
        if (s == this.tok.size()) {
            this.error(Err.NUMBERINC, new Object[0]);
        }
        if (XMLToken.isNCStartChar(this.curr())) {
            this.error(Err.NUMBERWS, new Object[0]);
        }
        return Dbl.get(this.tok.finish(), this.input());
    }

    private byte[] stringLiteral() throws QueryException {
        this.skipWS();
        char del = this.curr();
        if (!this.quote(del)) {
            this.error(Err.NOQUOTE, new Object[]{this.found()});
        }
        this.consume();
        this.tok.reset();
        while (true) {
            if (!this.consume(del)) {
                if (this.curr(0)) {
                    this.error(Err.NOQUOTE, new Object[]{this.found()});
                }
                this.entity(this.tok);
                continue;
            }
            if (!this.consume(del)) break;
            this.tok.add(del);
        }
        return this.tok.finish();
    }

    private QNm varName() throws QueryException {
        this.wsCheck("$");
        this.skipWS();
        QNm name = new QNm(this.qName(Err.NOVARNAME));
        if (name.ns()) {
            name.uri(this.ctx.ns.uri(name.pref(), false, this.input()));
        }
        this.ctx.ns.uri(name);
        return name;
    }

    private Expr parenthesized() throws QueryException {
        this.wsCheck("(");
        Expr e = this.expr();
        this.wsCheck(")");
        return e == null ? Empty.SEQ : e;
    }

    private Expr functionCall() throws QueryException {
        Expr[] args;
        int p = this.qp;
        QNm name = new QNm(this.qName(null), this.ctx, this.input());
        if (NodeType.find(name) != null || (args = this.argumentList(name.atom())) == null) {
            this.qp = p;
            return null;
        }
        this.alter = Err.FUNCUNKNOWN;
        this.alterFunc = name;
        this.ap = this.qp;
        this.ctx.ns.uri(name);
        name.uri(name.ns() ? this.ctx.ns.uri(name.pref(), false, this.input()) : this.ctx.nsFunc);
        TypedFunc f = this.ctx.funcs.get(name, args, this.ctx, this);
        if (f != null) {
            this.alter = null;
            Var[] part = new Var[args.length];
            return this.partial(args, part) ? new PartFunApp(this.input(), f, part) : f.fun;
        }
        this.qp = p;
        return null;
    }

    private Expr[] argumentList(Object name) throws QueryException {
        if (!this.wsConsume("(")) {
            return null;
        }
        Expr[] args = new Expr[]{};
        if (!this.wsConsume(")")) {
            do {
                Expr arg = null;
                if (!this.wsConsume("?") && (arg = this.single()) == null) {
                    this.error(Err.FUNCMISS, name);
                }
                args = Array.add(args, arg);
            } while (this.wsConsume(","));
            if (!this.wsConsume(")")) {
                this.error(Err.FUNCMISS, name);
            }
        }
        return args;
    }

    private Expr constructor() throws QueryException {
        this.check(60);
        return this.consume(33) ? this.dirComment() : (this.consume(63) ? this.dirPI() : this.dirElement());
    }

    private Expr dirElement() throws QueryException {
        if (this.skipWS()) {
            this.error(Err.NOTAGNAME, new Object[0]);
        }
        QNm tag = new QNm(this.qName(Err.NOTAGNAME));
        this.consumeWSS();
        Expr[] cont = new Expr[]{};
        Atts ns = new Atts();
        int s = this.ctx.ns.size();
        boolean xmlDef = false;
        while (XMLToken.isNCStartChar(this.curr())) {
            byte[] atn = this.qName(null);
            Expr[] attv = new Expr[]{};
            this.consumeWSS();
            this.check(61);
            this.consumeWSS();
            char delim = this.consume();
            if (!this.quote(delim)) {
                this.error(Err.NOQUOTE, new Object[]{this.found()});
            }
            TokenBuilder tb = new TokenBuilder();
            boolean simple = true;
            while (true) {
                if (!this.consume(delim)) {
                    char c = this.curr();
                    if (c == '{') {
                        if (this.next() == '{') {
                            tb.add(this.consume());
                            this.consume();
                            continue;
                        }
                        byte[] text = tb.finish();
                        if (text.length != 0) {
                            attv = this.add(attv, Str.get(text));
                        } else {
                            attv = this.add(attv, this.enclosed(Err.NOENCLEXPR));
                            simple = false;
                        }
                        tb.reset();
                        continue;
                    }
                    if (c == '}') {
                        ++this.qp;
                        this.check(125);
                        tb.add(125);
                        continue;
                    }
                    if (c == '<' || c == '\u0000') {
                        this.error(Err.NOQUOTE, new Object[]{this.found()});
                        continue;
                    }
                    if (c == '\n' || c == '\t') {
                        ++this.qp;
                        tb.add(32);
                        continue;
                    }
                    this.entity(tb);
                    continue;
                }
                if (!this.consume(delim)) break;
                tb.add(delim);
            }
            if (tb.size() != 0) {
                attv = this.add(attv, Str.get(tb.finish()));
            }
            if (Token.eq(atn, Token.XMLNS)) {
                byte[] v;
                if (!simple) {
                    this.error(Err.NSCONS, new Object[0]);
                }
                byte[] byArray = v = attv.length == 0 ? Token.EMPTY : ((Str)attv[0]).atom();
                if (!tag.ns()) {
                    tag.uri(v);
                }
                this.addNS(ns, Token.EMPTY, v);
            } else if (Token.startsWith(atn, Token.XMLNSC)) {
                QNm nsd;
                byte[] pref;
                byte[] v;
                if (!simple) {
                    this.error(Err.NSCONS, new Object[0]);
                }
                byte[] byArray = v = attv.length == 0 ? Token.EMPTY : ((Str)attv[0]).atom();
                if (v.length == 0) {
                    this.error(Err.NSEMPTYURI, new Object[0]);
                }
                if (!Token.eq(pref = (nsd = new QNm(atn, v)).ln(), Token.XML) || !Token.eq(v, QueryText.XMLURI)) {
                    this.ctx.ns.add(nsd, this.input());
                    this.addNS(ns, pref, v);
                    if (Token.eq(pref, tag.pref())) {
                        tag.uri(v);
                    }
                } else {
                    if (xmlDef) {
                        this.error(Err.DUPLNSDEF, new Object[]{Token.XML});
                    }
                    xmlDef = true;
                }
            } else {
                cont = this.add(cont, new CAttr(this.input(), false, (Expr)new QNm(atn, Token.contains(atn, 58) ? null : Uri.EMPTY), attv));
            }
            if (!this.consumeWSS()) break;
        }
        if (this.consume(47)) {
            this.check(62);
        } else {
            this.check(62);
            while (this.curr() != '<' || this.next() != '/') {
                Expr e = this.dirElemContent(tag);
                if (e == null) continue;
                cont = this.add(cont, e);
            }
            this.qp += 2;
            if (this.skipWS()) {
                this.error(Err.NOTAGNAME, new Object[0]);
            }
            byte[] close = this.qName(Err.NOTAGNAME);
            this.consumeWSS();
            this.check(62);
            if (!Token.eq(tag.atom(), close)) {
                this.error(Err.TAGWRONG, tag.atom(), close);
            }
        }
        this.ctx.ns.size(s);
        return new CElem(this.input(), (Expr)tag, ns, false, cont);
    }

    private void addNS(Atts ns, byte[] k, byte[] v) throws QueryException {
        if (ns.get(k) != -1) {
            this.error(Err.DUPLNSDEF, new Object[]{k});
        }
        ns.add(k, v);
    }

    private Expr dirElemContent(QNm tag) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            char c;
            if ((c = this.curr()) == '<') {
                if (this.wsConsume("<![CDATA[")) {
                    tb.add(this.cDataSection());
                    tb.ent = true;
                    continue;
                }
                Str txt = this.text(tb);
                return txt != null ? txt : (this.next() == '/' ? null : this.constructor());
            }
            if (c == '{') {
                if (this.next() == '{') {
                    tb.add(this.consume());
                    this.consume();
                    continue;
                }
                Str txt = this.text(tb);
                return txt != null ? txt : this.enclosed(Err.NOENCLEXPR);
            }
            if (c == '}') {
                this.consume();
                this.check(125);
                tb.add(125);
                continue;
            }
            if (c != '\u0000') {
                this.entity(tb);
                continue;
            }
            this.error(Err.NOCLOSING, new Object[]{tag.atom()});
        }
    }

    private Str text(TokenBuilder tb) {
        byte[] t = tb.finish();
        return t.length == 0 || !tb.ent && !this.ctx.spaces && Token.ws(t) ? null : Str.get(t);
    }

    private Expr dirComment() throws QueryException {
        this.check(45);
        this.check(45);
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            if (this.not('-')) {
                tb.add(this.consume());
                continue;
            }
            this.consume();
            if (this.consume(45)) {
                this.check(62);
                return new CComm(this.input(), (Expr)Str.get(tb.finish()));
            }
            tb.add(45);
        }
    }

    private Expr dirPI() throws QueryException {
        byte[] str;
        if (this.consumeWSS()) {
            this.error(Err.PIXML, new Object[]{Token.EMPTY});
        }
        if ((str = Token.trim(this.qName(Err.PIWRONG))).length == 0 || Token.eq(Token.lc(str), Token.XML)) {
            this.error(Err.PIXML, new Object[]{str});
        }
        boolean space = this.skipWS();
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            if (this.not('?')) {
                if (!space) {
                    this.error(Err.PIWRONG, new Object[0]);
                }
                tb.add(this.consume());
                continue;
            }
            this.consume();
            if (this.consume(62)) {
                if (!XMLToken.isNCName(str)) {
                    Err.INVALPI.thrw(this.input(), new Object[]{str});
                }
                return new CPI(this.input(), (Expr)Str.get(str), (Expr)Str.get(tb.finish()));
            }
            tb.add(63);
        }
    }

    private byte[] cDataSection() throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            if (this.not(']')) {
                char c = this.consume();
                if (c == '\r') continue;
                tb.add(c);
                continue;
            }
            this.consume();
            if (this.curr(93) && this.next() == '>') {
                this.qp += 2;
                return tb.finish();
            }
            tb.add(93);
        }
    }

    private Expr compConstructor() throws QueryException {
        int p = this.qp;
        if (this.wsConsumeWs("document")) {
            return this.consume(this.compDoc(), p);
        }
        if (this.wsConsumeWs("element")) {
            return this.consume(this.compElemConstructor(), p);
        }
        if (this.wsConsumeWs("attribute")) {
            return this.consume(this.compAttribute(), p);
        }
        if (this.wsConsumeWs("text")) {
            return this.consume(this.compText(), p);
        }
        if (this.wsConsumeWs("comment")) {
            return this.consume(this.compComment(), p);
        }
        if (this.wsConsumeWs("processing-instruction")) {
            return this.consume(this.compPI(), p);
        }
        return null;
    }

    private Expr consume(Expr expr, int p) {
        if (expr == null) {
            this.qp = p;
        }
        return expr;
    }

    private Expr compDoc() throws QueryException {
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.check(this.expr(), Err.NODOCCONS);
        this.wsCheck("}");
        return new CDoc(this.input(), e);
    }

    private Expr compElemConstructor() throws QueryException {
        Expr[] exprArray;
        Expr name;
        this.skipWS();
        if (XMLToken.isNCStartChar(this.curr())) {
            name = new QNm(this.qName(null));
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), Err.NOTAGNAME);
            this.wsCheck("}");
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        InputInfo inputInfo = this.input();
        Atts atts = new Atts();
        if (e == null) {
            exprArray = new Expr[]{};
        } else {
            Expr[] exprArray2 = new Expr[1];
            exprArray = exprArray2;
            exprArray2[0] = e;
        }
        return new CElem(inputInfo, name, atts, true, exprArray);
    }

    private Expr compAttribute() throws QueryException {
        Expr nm;
        this.skipWS();
        if (XMLToken.isNCStartChar(this.curr())) {
            nm = new QNm(this.qName(null));
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            nm = this.expr();
            this.wsCheck("}");
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        return new CAttr(this.input(), true, nm, e == null ? Empty.SEQ : e);
    }

    private Expr compText() throws QueryException {
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.check(this.expr(), Err.NOTXTCONS);
        this.wsCheck("}");
        return new CTxt(this.input(), e);
    }

    private Expr compComment() throws QueryException {
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.check(this.expr(), Err.NOCOMCONS);
        this.wsCheck("}");
        return new CComm(this.input(), e);
    }

    private Expr compPI() throws QueryException {
        Expr name;
        this.skipWS();
        if (XMLToken.isNCStartChar(this.curr())) {
            name = Str.get(this.ncName(null));
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), Err.PIWRONG);
            this.wsCheck("}");
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        return new CPI(this.input(), name, e == null ? Empty.SEQ : e);
    }

    private SeqType simpleType() throws QueryException {
        this.skipWS();
        QNm type = new QNm(this.qName(Err.TYPEINVALID));
        type.uri(this.ctx.ns.uri(type.pref(), false, this.input()));
        this.skipWS();
        Type t = Types.find(type, true);
        if (t == AtomType.AAT || t == AtomType.NOT) {
            this.error(Err.CASTUNKNOWN, type);
        }
        if (t == null) {
            this.error(Err.TYPEUNKNOWN, type);
        }
        return SeqType.get(t, this.consume(63) ? SeqType.Occ.ZO : SeqType.Occ.O);
    }

    private SeqType sequenceType() throws QueryException {
        this.skipWS();
        Type t = this.itemType();
        SeqType.Occ occ = this.consume(63) ? SeqType.Occ.ZO : (this.consume(43) ? SeqType.Occ.OM : (this.consume(42) ? SeqType.Occ.ZM : SeqType.Occ.O));
        this.skipWS();
        if (t == AtomType.EMP && occ != SeqType.Occ.O) {
            this.error(Err.EMPTYSEQOCC, t);
        }
        KindTest kt = this.tok.size() == 0 ? null : this.kindTest(t, this.tok.finish());
        this.tok.reset();
        return SeqType.get(t, occ, kt == null ? null : (kt.extype == null || t == kt.extype || !kt.extype.node() ? kt.name : new QNm(Token.EMPTY)));
    }

    private Type itemType() throws QueryException {
        Type t;
        boolean atom;
        QNm type;
        block17: {
            block18: {
                block19: {
                    this.skipWS();
                    if (this.consume("(")) {
                        Type ret = this.itemType();
                        this.wsCheck(")");
                        return ret;
                    }
                    type = new QNm(this.qName(Err.TYPEINVALID));
                    type.uri(this.ctx.ns.uri(type.pref(), false, this.input()));
                    atom = !this.wsConsumeWs("(");
                    t = Types.find(type, atom);
                    this.tok.reset();
                    if (atom) break block17;
                    if (t == null || !t.func()) break block18;
                    if (this.wsConsume("*")) break block19;
                    if (t.map()) {
                        Type keyType = this.itemType();
                        if (keyType == null) {
                            throw this.error(Err.MAPTKV, new Object[]{type.atom()});
                        }
                        if (!keyType.instance(AtomType.AAT)) {
                            throw this.error(Err.MAPTAAT, keyType);
                        }
                        this.wsCheck(",");
                        t = MapType.get((AtomType)keyType, this.sequenceType());
                        if (!this.wsConsume(")")) {
                            this.error(Err.FUNCMISS, new Object[]{type.atom()});
                        }
                    } else {
                        SeqType[] args = new SeqType[]{};
                        if (!this.wsConsume(")")) {
                            do {
                                args = Array.add(args, this.sequenceType());
                            } while (this.wsConsume(","));
                            if (!this.wsConsume(")")) {
                                this.error(Err.FUNCMISS, new Object[]{type.atom()});
                            }
                        }
                        this.wsCheck("as");
                        t = FuncType.get(args, this.sequenceType());
                    }
                    break block17;
                }
                if (this.wsConsume(")")) break block17;
                this.error(Err.FUNCMISS, new Object[]{type.atom()});
                break block17;
            }
            int par = 0;
            while (par != 0 || !this.wsConsumeWs(")")) {
                switch (this.curr()) {
                    case '(': {
                        ++par;
                        break;
                    }
                    case ')': {
                        --par;
                        break;
                    }
                    case '\u0000': {
                        this.error(Err.FUNCMISS, new Object[]{type.atom()});
                    }
                }
                this.tok.add(this.consume());
            }
        }
        if (t == null) {
            if (atom) {
                this.error(Err.TYPEUNKNOWN, type);
            }
            this.error(Err.NOTYPE, new TokenBuilder(type.atom()).add(40).add(this.tok.finish()).add(41));
        }
        return t;
    }

    private KindTest kindTest(Type t, byte[] k) throws QueryException {
        byte[] nm = Token.trim(k);
        if (t == NodeType.PI) {
            boolean s = Token.startsWith(k, 39) || Token.startsWith(k, 34);
            nm = Token.trim(Token.delete(Token.delete(k, 39), 34));
            if (!XMLToken.isNCName(nm)) {
                if (s) {
                    this.error(Err.XPINVNAME, new Object[]{nm});
                }
                this.error(Err.TESTINVALID, t, k);
            }
            return new KindTest((NodeType)t, new QNm(nm, this.ctx, this.input()), null);
        }
        if (t != NodeType.ELM && t != NodeType.ATT) {
            this.error(Err.TESTINVALID, t, k);
        }
        Type tp = t;
        int i = Token.indexOf(nm, 44);
        if (i != -1) {
            QNm test = new QNm(Token.trim(Token.substring(nm, i + 1)), this.ctx, this.input());
            if (!Token.eq(test.uri().atom(), QueryText.XSURI)) {
                this.error(Err.TYPEUNDEF, test);
            }
            byte[] ln = test.ln();
            tp = Types.find(test, true);
            if (!(tp != null || Token.eq(ln, QueryText.ANYTYPE) || Token.eq(ln, QueryText.ANYSIMPLE) || Token.eq(ln, QueryText.UNTYPED))) {
                this.error(Err.VARUNDEF, test);
            }
            if (tp == AtomType.ATM || tp == AtomType.AAT) {
                tp = null;
            }
            nm = Token.trim(Token.substring(nm, 0, i));
        }
        if (nm.length == 1 && nm[0] == 42) {
            return new KindTest((NodeType)t, null, tp);
        }
        if (!XMLToken.isQName(nm)) {
            this.error(Err.TESTINVALID, t, k);
        }
        return new KindTest((NodeType)t, new QNm(nm, this.ctx, this.input()), tp);
    }

    private Expr tryCatch() throws QueryException {
        if (!this.ctx.xquery3 || !this.wsConsumeWs("try")) {
            return null;
        }
        Expr tr = this.enclosed(Err.NOENCLEXPR);
        this.wsCheck("catch");
        Catch[] ct = new Catch[]{};
        do {
            QNm[] codes = new QNm[]{};
            do {
                this.skipWS();
                if (XMLToken.isNCStartChar(this.curr())) {
                    codes = Array.add(codes, new QNm(this.qName(Err.QNAMEINV)));
                    continue;
                }
                this.wsCheck("*");
                codes = Array.add(codes, null);
            } while (this.wsConsumeWs("|"));
            Catch c = new Catch(this.input(), codes, this.ctx);
            int s = c.prepare(this.ctx);
            c.expr = this.enclosed(Err.NOENCLEXPR);
            c.finish(s, this.ctx);
            ct = Array.add(ct, c);
        } while (this.wsConsumeWs("catch"));
        return new Try(this.input(), tr, ct);
    }

    private FTExpr ftSelection(boolean prg) throws QueryException {
        FTExpr old;
        FTExpr expr = this.ftOr(prg);
        FTExpr first = null;
        boolean ordered = false;
        do {
            old = expr;
            if (this.wsConsumeWs("ordered")) {
                ordered = true;
                old = null;
            } else if (this.wsConsumeWs("window")) {
                expr = new FTWindow(this.input(), expr, this.additive(), this.ftUnit());
            } else if (this.wsConsumeWs("distance")) {
                Expr[] rng = this.ftRange(false);
                if (rng == null) {
                    this.error(Err.FTRANGE, new Object[0]);
                }
                expr = new FTDistance(this.input(), expr, rng, this.ftUnit());
            } else if (this.wsConsumeWs("at")) {
                boolean end;
                boolean start = this.wsConsumeWs("start");
                boolean bl = end = !start && this.wsConsumeWs("end");
                if (!start && !end) {
                    this.error(Err.INCOMPLETE, new Object[0]);
                }
                expr = new FTContent(this.input(), expr, start, end);
            } else if (this.wsConsumeWs("entire")) {
                this.wsCheck("content");
                expr = new FTContent(this.input(), expr, false, false);
            } else {
                boolean diff;
                boolean same = this.wsConsumeWs("same");
                boolean bl = diff = !same && this.wsConsumeWs("different");
                if (same || diff) {
                    FTUnit unit = null;
                    if (this.wsConsumeWs("sentence")) {
                        unit = FTUnit.SENTENCE;
                    } else if (this.wsConsumeWs("paragraph")) {
                        unit = FTUnit.PARAGRAPH;
                    } else {
                        this.error(Err.INCOMPLETE, new Object[0]);
                    }
                    expr = new FTScope(this.input(), expr, unit, same);
                }
            }
            if (first != null || old == null || old == expr) continue;
            first = expr;
        } while (old != expr);
        if (ordered) {
            if (first == null) {
                return new FTOrder(this.input(), expr);
            }
            first.expr[0] = new FTOrder(this.input(), first.expr[0]);
        }
        return expr;
    }

    private FTExpr ftOr(boolean prg) throws QueryException {
        FTExpr e = this.ftAnd(prg);
        if (!this.wsConsumeWs("ftor")) {
            return e;
        }
        FTExpr[] list = new FTExpr[]{e};
        do {
            list = Array.add(list, this.ftAnd(prg));
        } while (this.wsConsumeWs("ftor"));
        return new FTOr(this.input(), list);
    }

    private FTExpr ftAnd(boolean prg) throws QueryException {
        FTExpr e = this.ftMildNot(prg);
        if (!this.wsConsumeWs("ftand")) {
            return e;
        }
        FTExpr[] list = new FTExpr[]{e};
        do {
            list = Array.add(list, this.ftMildNot(prg));
        } while (this.wsConsumeWs("ftand"));
        return new FTAnd(this.input(), list);
    }

    private FTExpr ftMildNot(boolean prg) throws QueryException {
        FTExpr e = this.ftUnaryNot(prg);
        if (!this.wsConsumeWs("not")) {
            return e;
        }
        FTExpr[] list = new FTExpr[]{};
        do {
            this.wsCheck("in");
            list = Array.add(list, this.ftUnaryNot(prg));
        } while (this.wsConsumeWs("not"));
        return new FTMildNot(this.input(), e, list.length == 1 ? list[0] : new FTOr(this.input(), list));
    }

    private FTExpr ftUnaryNot(boolean prg) throws QueryException {
        boolean not = this.wsConsumeWs("ftnot");
        FTExpr e = this.ftPrimaryWithOptions(prg);
        return not ? new FTNot(this.input(), e) : e;
    }

    private FTExpr ftPrimaryWithOptions(boolean prg) throws QueryException {
        FTExpr expr = this.ftPrimary(prg);
        FTOpt fto = new FTOpt();
        boolean found = false;
        while (this.ftMatchOption(fto)) {
            found = true;
        }
        if (!Language.supported(fto.ln, fto.is(FTFlag.ST) && fto.sd == null)) {
            this.error(Err.FTLAN, new Object[]{fto.ln});
        }
        if (this.wsConsumeWs("weight")) {
            expr = new FTWeight(this.input(), expr, this.enclosed(Err.NOENCLEXPR));
        }
        return found ? new FTOptions(this.input(), expr, fto) : expr;
    }

    private FTExpr ftPrimary(boolean prg) throws QueryException {
        Expr e;
        Expr[] pragmas = this.pragma();
        if (pragmas.length != 0) {
            this.wsCheck("{");
            FTExpr e2 = this.ftSelection(true);
            this.wsCheck("}");
            return new FTExtensionSelection(this.input(), pragmas, e2);
        }
        if (this.wsConsumeWs("(")) {
            FTExpr e3 = this.ftSelection(false);
            this.wsCheck(")");
            return e3;
        }
        this.skipWS();
        Expr expr = this.curr(123) ? this.enclosed(Err.NOENCLEXPR) : (e = this.quote(this.curr()) ? Str.get(this.stringLiteral()) : null);
        if (e == null) {
            this.error(prg ? Err.NOPRAGMA : Err.NOENCLEXPR, new Object[0]);
        }
        FTWords.FTMode mode = FTWords.FTMode.M_ANY;
        if (this.wsConsumeWs("all")) {
            mode = this.wsConsumeWs("words") ? FTWords.FTMode.M_ALLWORDS : FTWords.FTMode.M_ALL;
        } else if (this.wsConsumeWs("any")) {
            mode = this.wsConsumeWs("word") ? FTWords.FTMode.M_ANYWORD : FTWords.FTMode.M_ANY;
        } else if (this.wsConsumeWs("phrase")) {
            mode = FTWords.FTMode.M_PHRASE;
        }
        Expr[] occ = null;
        if (this.wsConsumeWs("occurs")) {
            occ = this.ftRange(false);
            if (occ == null) {
                this.error(Err.FTRANGE, new Object[0]);
            }
            this.wsCheck("times");
        }
        return new FTWords(this.input(), e, mode, occ);
    }

    private Expr[] ftRange(boolean i) throws QueryException {
        Expr[] occ = new Expr[]{Itr.get(1L), Itr.get(Long.MAX_VALUE)};
        if (this.wsConsumeWs("exactly")) {
            occ[0] = this.ftAdditive(i);
            occ[1] = occ[0];
        } else if (this.wsConsumeWs("at")) {
            if (this.wsConsumeWs("least")) {
                occ[0] = this.ftAdditive(i);
            } else {
                this.wsCheck("most");
                occ[0] = Itr.get(0L);
                occ[1] = this.ftAdditive(i);
            }
        } else if (this.wsConsumeWs("from")) {
            occ[0] = this.ftAdditive(i);
            this.wsCheck("to");
            occ[1] = this.ftAdditive(i);
        } else {
            return null;
        }
        return occ;
    }

    private Expr ftAdditive(boolean i) throws QueryException {
        if (!i) {
            return this.additive();
        }
        this.skipWS();
        this.tok.reset();
        while (Token.digit(this.curr())) {
            this.tok.add(this.consume());
        }
        if (this.tok.size() == 0) {
            this.error(Err.INTEXP, new Object[0]);
        }
        return Itr.get(Token.toLong(this.tok.finish()));
    }

    private FTUnit ftUnit() throws QueryException {
        if (this.wsConsumeWs("words")) {
            return FTUnit.WORD;
        }
        if (this.wsConsumeWs("sentences")) {
            return FTUnit.SENTENCE;
        }
        if (this.wsConsumeWs("paragraphs")) {
            return FTUnit.PARAGRAPH;
        }
        this.error(Err.INCOMPLETE, new Object[0]);
        return null;
    }

    private boolean ftMatchOption(FTOpt opt) throws QueryException {
        if (!this.wsConsumeWs("using")) {
            return false;
        }
        if (this.wsConsumeWs("lowercase")) {
            if (opt.isSet(FTFlag.LC) || opt.isSet(FTFlag.UC) || opt.isSet(FTFlag.CS)) {
                this.error(Err.FTDUP, "case");
            }
            opt.set(FTFlag.CS, true);
            opt.set(FTFlag.LC, true);
        } else if (this.wsConsumeWs("uppercase")) {
            if (opt.isSet(FTFlag.LC) || opt.isSet(FTFlag.UC) || opt.isSet(FTFlag.CS)) {
                this.error(Err.FTDUP, "case");
            }
            opt.set(FTFlag.CS, true);
            opt.set(FTFlag.UC, true);
        } else if (this.wsConsumeWs("case")) {
            if (opt.isSet(FTFlag.LC) || opt.isSet(FTFlag.UC) || opt.isSet(FTFlag.CS)) {
                this.error(Err.FTDUP, "case");
            }
            opt.set(FTFlag.CS, this.wsConsumeWs("sensitive"));
            if (!opt.is(FTFlag.CS)) {
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("diacritics")) {
            if (opt.isSet(FTFlag.DC)) {
                this.error(Err.FTDUP, "diacritics");
            }
            opt.set(FTFlag.DC, this.wsConsumeWs("sensitive"));
            if (!opt.is(FTFlag.DC)) {
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("language")) {
            if (opt.ln != null) {
                this.error(Err.FTDUP, "language");
            }
            byte[] lan = this.stringLiteral();
            opt.ln = Language.get(Token.string(lan));
            if (opt.ln == null) {
                this.error(Err.FTLAN, new Object[]{lan});
            }
        } else if (this.wsConsumeWs("option")) {
            this.optionDecl();
        } else {
            boolean using;
            boolean bl = using = !this.wsConsumeWs("no");
            if (this.wsConsumeWs("stemming")) {
                if (opt.isSet(FTFlag.ST)) {
                    this.error(Err.FTDUP, "stemming");
                }
                opt.set(FTFlag.ST, using);
            } else if (this.wsConsumeWs("thesaurus")) {
                if (opt.th != null) {
                    this.error(Err.FTDUP, "thesaurus");
                }
                opt.th = new ThesQuery();
                if (using) {
                    boolean par = this.wsConsume("(");
                    if (!this.wsConsumeWs("default")) {
                        this.ftThesaurusID(opt.th);
                    }
                    while (par && this.wsConsume(",")) {
                        this.ftThesaurusID(opt.th);
                    }
                    if (par) {
                        this.wsCheck(")");
                    }
                }
            } else if (this.wsConsumeWs("stop")) {
                this.wsCheck("words");
                if (opt.sw != null) {
                    this.error(Err.FTDUP, "stop words");
                }
                opt.sw = new StopWords();
                if (this.wsConsumeWs("default")) {
                    if (!using) {
                        this.error(Err.FTSTOP, new Object[0]);
                    }
                } else {
                    boolean union = false;
                    boolean except = false;
                    while (using) {
                        if (this.wsConsume("(")) {
                            do {
                                byte[] sl = this.stringLiteral();
                                if (except) {
                                    opt.sw.delete(sl);
                                    continue;
                                }
                                if (union && opt.sw.id(sl) != 0) continue;
                                opt.sw.add(sl);
                            } while (this.wsConsume(","));
                            this.wsCheck(")");
                        } else if (this.wsConsumeWs("at")) {
                            IO fl;
                            String fn = Token.string(this.stringLiteral());
                            if (this.ctx.stop != null) {
                                fn = this.ctx.stop.get(fn);
                            }
                            if (!opt.sw.read(fl = this.io(fn), except)) {
                                this.error(Err.NOSTOPFILE, fl);
                            }
                        } else if (!union && !except) {
                            this.error(Err.FTSTOP, new Object[0]);
                        }
                        union = this.wsConsumeWs("union");
                        boolean bl2 = except = !union && this.wsConsumeWs("except");
                        if (union || except) {
                            continue;
                        }
                        break;
                    }
                }
            } else if (this.wsConsumeWs("wildcards")) {
                if (opt.isSet(FTFlag.WC)) {
                    this.error(Err.FTDUP, "wildcards");
                }
                if (opt.is(FTFlag.FZ)) {
                    this.error(Err.FTFZWC, new Object[0]);
                }
                opt.set(FTFlag.WC, using);
            } else if (this.wsConsumeWs("fuzzy")) {
                if (opt.isSet(FTFlag.FZ)) {
                    this.error(Err.FTDUP, "fuzzy");
                }
                if (opt.is(FTFlag.WC)) {
                    this.error(Err.FTFZWC, new Object[0]);
                }
                opt.set(FTFlag.FZ, using);
            } else {
                this.error(Err.FTMATCH, Character.valueOf(this.consume()));
                return false;
            }
        }
        return true;
    }

    private void ftThesaurusID(ThesQuery thes) throws QueryException {
        this.wsCheck("at");
        String fn = Token.string(this.stringLiteral());
        if (this.ctx.thes != null) {
            fn = this.ctx.thes.get(fn);
        }
        IO fl = this.io(fn);
        byte[] rel = this.wsConsumeWs("relationship") ? this.stringLiteral() : Token.EMPTY;
        Expr[] range = this.ftRange(true);
        long min = 0L;
        long max = Long.MAX_VALUE;
        if (range != null) {
            this.wsCheck("levels");
            min = ((Itr)range[0]).itr(this.input());
            max = ((Itr)range[1]).itr(this.input());
        }
        thes.add(new Thesaurus(fl, rel, min, max, this.ctx.context));
    }

    private Expr insert() throws QueryException {
        int p = this.qp;
        if (!this.wsConsumeWs("insert") || !this.wsConsumeWs("node") && !this.wsConsumeWs("nodes")) {
            this.qp = p;
            return null;
        }
        Expr s = this.check(this.single(), Err.INCOMPLETE);
        boolean first = false;
        boolean last = false;
        boolean before = false;
        boolean after = false;
        if (this.wsConsumeWs("as")) {
            first = this.wsConsumeWs("first");
            if (!first) {
                this.wsCheck("last");
                last = true;
            }
            this.wsCheck("into");
        } else if (!this.wsConsumeWs("into")) {
            after = this.wsConsumeWs("after");
            boolean bl = before = !after && this.wsConsumeWs("before");
            if (!after && !before) {
                this.error(Err.INCOMPLETE, new Object[0]);
            }
        }
        Expr trg = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating = true;
        return new Insert(this.input(), s, first, last, before, after, trg);
    }

    private Expr deletee() throws QueryException {
        int p = this.qp;
        if (!this.wsConsumeWs("delete") || !this.wsConsumeWs("nodes") && !this.wsConsumeWs("node")) {
            this.qp = p;
            return null;
        }
        this.ctx.updating = true;
        return new Delete(this.input(), this.check(this.single(), Err.INCOMPLETE));
    }

    private Expr rename() throws QueryException {
        int p = this.qp;
        if (!this.wsConsumeWs("rename") || !this.wsConsumeWs("node")) {
            this.qp = p;
            return null;
        }
        Expr trg = this.check(this.single(), Err.INCOMPLETE);
        this.wsCheck("as");
        Expr n = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating = true;
        return new Rename(this.input(), trg, n);
    }

    private Expr replace() throws QueryException {
        int p = this.qp;
        if (!this.wsConsumeWs("replace")) {
            return null;
        }
        boolean v = this.wsConsumeWs("value");
        if (v) {
            this.wsCheck("of");
            this.wsCheck("node");
        } else if (!this.wsConsumeWs("node")) {
            this.qp = p;
            return null;
        }
        Expr t = this.check(this.single(), Err.INCOMPLETE);
        this.wsCheck("with");
        Expr r = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating = true;
        return new Replace(this.input(), t, r, v);
    }

    private Expr transform() throws QueryException {
        if (!this.wsConsumeWs("copy", "$", Err.INCOMPLETE)) {
            return null;
        }
        boolean u = this.ctx.updating;
        this.ctx.updating = false;
        Let[] fl = new Let[]{};
        do {
            Var v = Var.create(this.ctx, this.input(), this.varName());
            this.wsCheck(":=");
            Expr e = this.check(this.single(), Err.INCOMPLETE);
            this.ctx.vars.add(v);
            fl = Array.add(fl, new Let(this.input(), e, v));
        } while (this.wsConsumeWs(","));
        this.wsCheck("modify");
        Expr m = this.check(this.single(), Err.INCOMPLETE);
        this.wsCheck("return");
        Expr r = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating = u;
        return new Transform(this.input(), fl, m, r);
    }

    private byte[] ncName(Err err) throws QueryException {
        this.skipWS();
        this.tok.reset();
        if (this.ncName()) {
            return this.tok.finish();
        }
        if (err != null) {
            this.error(err, new Object[0]);
        }
        return Token.EMPTY;
    }

    private byte[] qName(Err err) throws QueryException {
        this.tok.reset();
        boolean ok = this.ncName();
        if (ok && this.consume(58)) {
            this.ncName2();
        }
        if (!ok && err != null) {
            this.error(err, new Object[0]);
        }
        return this.tok.finish();
    }

    private boolean ncName2() {
        char c = this.curr();
        if (!XMLToken.isNCStartChar(c)) {
            --this.qp;
            return false;
        }
        this.tok.add(58);
        do {
            this.tok.add(this.consume());
        } while (XMLToken.isNCChar(c = this.curr()));
        return true;
    }

    private boolean ncName() {
        if (!XMLToken.isNCStartChar(this.curr())) {
            return false;
        }
        do {
            this.tok.add(this.consume());
        } while (XMLToken.isNCChar(this.curr()));
        return true;
    }

    private void entity(TokenBuilder tb) throws QueryException {
        int p = this.qp;
        if (this.consume(38)) {
            if (this.consume(35)) {
                int b = this.consume(120) ? 16 : 10;
                int n = 0;
                do {
                    boolean h;
                    char c = this.curr();
                    boolean m = Token.digit(c);
                    boolean bl = h = b == 16 && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F');
                    if (!m && !h) {
                        this.entityError(p, Err.INVENTITY);
                    }
                    long nn = n;
                    if ((long)(n = n * b + (this.consume() & 0xF)) < nn) {
                        this.entityError(p, Err.INVCHARREF);
                    }
                    if (m) continue;
                    n += 9;
                } while (!this.consume(59));
                if (!XMLToken.valid(n)) {
                    this.entityError(p, Err.INVCHARREF);
                }
                tb.add(n);
            } else {
                if (this.consume("lt")) {
                    tb.add(60);
                } else if (this.consume("gt")) {
                    tb.add(62);
                } else if (this.consume("amp")) {
                    tb.add(38);
                } else if (this.consume("quot")) {
                    tb.add(34);
                } else if (this.consume("apos")) {
                    tb.add(39);
                } else {
                    this.entityError(p, Err.INVENTITY);
                }
                if (!this.consume(59)) {
                    this.entityError(p, Err.INVENTITY);
                }
            }
            tb.ent = true;
        } else {
            char c = this.consume();
            char cp = c;
            if (Character.isHighSurrogate(c) && this.curr() != '\u0000' && Character.isLowSurrogate(this.curr())) {
                cp = Character.toCodePoint(c, this.consume());
            }
            if (cp == '\r' && this.curr(cp = '\n')) {
                this.consume();
            }
            tb.add(cp);
        }
    }

    private void entityError(int p, Err c) throws QueryException {
        String sub = this.query.substring(p, Math.min(p + 20, this.ql));
        int sc = sub.indexOf(59);
        String ent = sc != -1 ? sub.substring(0, sc + 1) : sub;
        this.error(c, ent);
    }

    private IO io(String fn) {
        IO base;
        IO fl = IO.get(fn);
        if (!fl.exists() && (base = this.ctx.base()) != null) {
            fl = base.merge(fn);
        }
        if (!fl.exists() && this.file != null) {
            fl = this.file.merge(fn);
        }
        return fl;
    }

    private <E extends Expr> E check(E expr, Err err) throws QueryException {
        if (expr == null) {
            this.error(err, new Object[0]);
        }
        return expr;
    }

    private void check(int ch) throws QueryException {
        if (!this.consume(ch)) {
            this.error(Err.WRONGCHAR, Character.valueOf((char)ch), this.found());
        }
    }

    private void wsCheck(String s) throws QueryException {
        if (!this.wsConsume(s)) {
            this.error(Err.WRONGCHAR, s, this.found());
        }
    }

    private Var checkVar(QNm name, Err err) throws QueryException {
        Var v = this.ctx.vars.get(name);
        if (v == null && !this.declVars) {
            this.declVars = true;
            Variable.init(this.ctx);
            v = this.ctx.vars.get(name);
        }
        if (v == null) {
            this.error(err, String.valueOf('$') + Token.string(name.atom()));
        }
        return v;
    }

    private boolean not(char ch) throws QueryException {
        char c = this.curr();
        if (c == '\u0000') {
            this.error(Err.WRONGEND, Character.valueOf(ch));
        }
        return c != ch;
    }

    private boolean wsConsumeWs(String t) throws QueryException {
        int p = this.qp;
        if (!this.wsConsume(t)) {
            return false;
        }
        if (this.skipWS() || !XMLToken.isNCStartChar(t.charAt(0)) || !XMLToken.isNCChar(this.curr())) {
            return true;
        }
        this.qp = p;
        return false;
    }

    private boolean wsConsumeWs(String s1, String s2, Err expr) throws QueryException {
        int p = this.qp;
        if (!this.wsConsumeWs(s1)) {
            return false;
        }
        this.alter = expr;
        this.ap = this.qp;
        int p2 = this.qp;
        boolean ok = this.wsConsume(s2);
        this.qp = ok ? p2 : p;
        return ok;
    }

    private boolean wsConsume(String str) throws QueryException {
        this.skipWS();
        return this.consume(str);
    }

    private boolean skipWS() throws QueryException {
        int p = this.qp;
        while (this.more()) {
            char c = this.curr();
            if (c == '(' && this.next() == ':') {
                this.comment();
                continue;
            }
            if (c <= '\u0000' || c > ' ') {
                return p != this.qp;
            }
            ++this.qp;
        }
        return p != this.qp;
    }

    private void comment() throws QueryException {
        ++this.qp;
        while (++this.qp < this.ql) {
            if (this.curr(40) && this.next() == ':') {
                this.comment();
            }
            if (!this.curr(58) || this.next() != ')') continue;
            this.qp += 2;
            return;
        }
        this.error(Err.COMCLOSE, new Object[0]);
    }

    private boolean consumeWSS() {
        int p = this.qp;
        while (this.more()) {
            char c = this.curr();
            if (c <= '\u0000' || c > ' ') {
                return p != this.qp;
            }
            ++this.qp;
        }
        return true;
    }

    private QueryException error() throws QueryException {
        this.qp = this.ap;
        if (this.alter != Err.FUNCUNKNOWN) {
            throw this.error(this.alter, new Object[0]);
        }
        this.ctx.funcs.funError(this.alterFunc, this);
        throw this.error(this.alter, new Object[]{this.alterFunc.atom()});
    }

    private Expr[] add(Expr[] ar, Expr e) throws QueryException {
        if (e == null) {
            this.error(Err.INCOMPLETE, new Object[0]);
        }
        int a = ar.length;
        Expr[] tmp = new Expr[a + 1];
        System.arraycopy(ar, 0, tmp, 0, a);
        tmp[a] = e;
        return tmp;
    }

    public QueryException error(Err err, Object ... arg) throws QueryException {
        throw err.thrw(this.input(), arg);
    }
}

