/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.basex.core.Context;
import org.basex.core.Progress;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.FTPosData;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.io.IO;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryResources;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.item.DBNode;
import org.basex.query.item.Dat;
import org.basex.query.item.Dtm;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Tim;
import org.basex.query.item.Uri;
import org.basex.query.item.Value;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.util.Err;
import org.basex.query.util.NSLocal;
import org.basex.query.util.UserFuncs;
import org.basex.query.util.Var;
import org.basex.query.util.Variables;
import org.basex.query.util.format.DecFormatter;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;

public final class QueryContext
extends Progress {
    public final UserFuncs funcs = new UserFuncs();
    public final Variables vars = new Variables();
    public NSLocal ns = new NSLocal();
    public final QueryResources resource;
    public final Context context;
    public String query;
    public boolean xquery3;
    public HashMap<String, String> stop;
    public HashMap<String, String> thes;
    public HashMap<String, Object> props;
    public Expr root;
    public Value value;
    public long pos;
    public long size;
    Nodes nodes;
    public FTOpt ftopt = new FTOpt();
    public FTLexer fttoken;
    public Dat date;
    public Dtm dtm;
    public Tim time;
    public final TokenObjMap<DecFormatter> decFormats = new TokenObjMap();
    public byte[] nsFunc = QueryText.FNURI;
    public byte[] nsElem = Token.EMPTY;
    public Uri baseURI = Uri.EMPTY;
    public Uri collation = Uri.uri(QueryText.URLCOLL);
    public boolean spaces;
    public boolean orderGreatest;
    public boolean nsPreserve = true;
    public boolean nsInherit = true;
    public boolean ordered;
    public boolean construct;
    public FTPosData ftpos;
    public byte ftoknum;
    public final HashSet<Data> copiedNods = new HashSet();
    public final Updates updates = new Updates();
    public boolean updating;
    public boolean leaf;
    public boolean grouping;
    public int varIDs;
    final TokenMap modDeclared = new TokenMap();
    final TokenMap modParsed = new TokenMap();
    SerializerProp serProp;
    SeqType initType;
    Expr initExpr;
    public int tailCalls;
    public final int maxCalls;
    private final TokenBuilder info = new TokenBuilder();
    private final boolean inf;
    private boolean firstOpt = true;
    private boolean firstEval = true;

    public QueryContext(Context ctx) {
        this.resource = new QueryResources(this);
        this.context = ctx;
        this.nodes = ctx.current;
        this.xquery3 = ctx.prop.is(Prop.XQUERY3);
        boolean bl = this.inf = ctx.prop.is(Prop.QUERYINFO) || Util.debug;
        if (ctx.query != null) {
            this.baseURI = Uri.uri(Token.token(ctx.query.url()));
        }
        this.maxCalls = ctx.prop.num(Prop.TAILCALLS);
    }

    public void parse(String q) throws QueryException {
        this.root = new QueryParser(q, this).parse(this.base(), null);
        this.query = q;
    }

    public void module(String q) throws QueryException {
        new QueryParser(q, this).parse(this.base(), Uri.EMPTY);
    }

    public void compile() throws QueryException {
        if (this.inf) {
            this.compInfo(String.valueOf(Text.NL) + Text.QUERYCOMP, new Object[0]);
        }
        if (this.initExpr != null) {
            try {
                this.value = this.initExpr.value(this);
            }
            catch (QueryException ex) {
                if (ex.err() != Err.XPNOCTX) {
                    throw ex;
                }
                Err.CTXINIT.thrw(((ParseExpr)this.initExpr).input, ex.getMessage());
            }
        } else if (this.nodes != null) {
            if (this.nodes.ftpos != null) {
                this.ftpos = new FTPosData();
            }
            this.resource.compile(this.nodes);
        }
        if (this.value != null && this.initType != null) {
            this.value = this.initType.promote(this.value, this, null);
        }
        try {
            this.funcs.comp(this);
            this.root = this.root.comp(this);
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            Err.XPSTACK.thrw(null, new Object[0]);
        }
        if (this.inf) {
            this.info.add(String.valueOf(Text.NL) + Text.QUERYRESULT + this.funcs + this.root + Text.NL);
        }
    }

    protected Result eval() throws QueryException {
        Item it;
        Iter ir = this.iter();
        ItemCache ic = new ItemCache();
        if (this.nodes != null) {
            IntList pre = new IntList();
            while ((it = ir.next()) != null) {
                this.checkStop();
                if (!(it instanceof DBNode) || it.data() != this.nodes.data) break;
                pre.add(((DBNode)it).pre);
            }
            int ps = pre.size();
            if (it == null) {
                return ps == 0 ? ic : new Nodes(pre.toArray(), this.nodes.data, this.ftpos).checkRoot();
            }
            int p = 0;
            while (p < ps) {
                ic.add(new DBNode(this.nodes.data, pre.get(p)));
                ++p;
            }
            ic.add(it);
        }
        while ((it = ir.next()) != null) {
            this.checkStop();
            ic.add(it);
        }
        return ic;
    }

    public Iter iter() throws QueryException {
        try {
            return this.updating ? this.value().iter() : this.iter(this.root);
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw Err.XPSTACK.thrw(null, new Object[0]);
        }
    }

    public Value value() throws QueryException {
        try {
            Value v = this.value(this.root);
            if (this.updating) {
                this.updates.applyUpdates(this);
                if (this.context.data != null) {
                    this.context.update();
                }
            }
            return v;
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw Err.XPSTACK.thrw(null, new Object[0]);
        }
    }

    protected void plan(Serializer ser) throws IOException {
        boolean r;
        boolean bl = r = this.funcs.size() != 0 || this.vars.global().size != 0;
        if (r) {
            ser.openElement(QueryText.PLAN, (byte[][])new byte[0][]);
        }
        this.funcs.plan(ser);
        this.vars.plan(ser);
        this.root.plan(ser);
        if (r) {
            ser.closeElement();
        }
    }

    public Iter iter(Expr e) throws QueryException {
        this.checkStop();
        return e.iter(this);
    }

    public Value value(Expr e) throws QueryException {
        this.checkStop();
        return e.value(this);
    }

    public Data data() {
        return this.value != null ? this.value.data() : null;
    }

    public Var uniqueVar(InputInfo ii, SeqType t) {
        return Var.create(this, ii, new QNm(Token.token(this.varIDs)), t);
    }

    public void copy(QueryContext ctx) {
        this.baseURI = ctx.baseURI;
        this.spaces = ctx.spaces;
        this.construct = ctx.construct;
        this.nsInherit = ctx.nsInherit;
        this.nsPreserve = ctx.nsPreserve;
        this.collation = ctx.collation;
        this.nsElem = ctx.nsElem;
        this.nsFunc = ctx.nsFunc;
        this.orderGreatest = ctx.orderGreatest;
        this.ordered = ctx.ordered;
    }

    public void compInfo(String string, Object ... ext) {
        if (!this.inf) {
            return;
        }
        if (!this.firstOpt) {
            this.info.add("- ");
        }
        this.firstOpt = false;
        this.info.addExt(string, ext).add(Text.NL);
    }

    public void evalInfo(byte[] string) {
        if (!this.inf) {
            return;
        }
        if (this.firstEval) {
            this.info.add(Text.NL).add(Text.QUERYEVAL).add(Text.NL);
        }
        this.info.add("- ").add(string).add(Text.NL);
        this.firstEval = false;
    }

    public IO base() {
        return this.baseURI != Uri.EMPTY ? IO.get(Token.string(this.baseURI.atom())) : null;
    }

    public String info() {
        return this.info.toString();
    }

    public SerializerProp serProp(boolean opt) throws SerializerException {
        if (this.serProp != null) {
            return this.serProp;
        }
        String serial = this.context.prop.get(Prop.SERIALIZER);
        if (opt && serial.isEmpty()) {
            return null;
        }
        return new SerializerProp(serial);
    }

    @Override
    public String tit() {
        return Text.QUERYEVAL;
    }

    @Override
    public String det() {
        return Text.QUERYEVAL;
    }

    @Override
    public double prog() {
        return 0.0;
    }

    public String toString() {
        return String.valueOf(Util.name(this)) + '[' + this.base() + ']';
    }
}

