/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.Prop;
import org.basex.data.DataText;
import org.basex.data.FTPos;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.util.Err;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public final class XMLSerializer
extends Serializer {
    private static final SerializerProp PROPS = new SerializerProp();
    private static final byte[] NL = Token.token(Prop.NL);
    private static final TokenList EMPTIES = new TokenList();
    private static final TokenList SCRIPTS = new TokenList();
    private static final TokenSet BOOLEAN = new TokenSet();
    private static final TokenSet URIS = new TokenSet();
    private final TokenList cdata = new TokenList();
    private final boolean indent;
    private final boolean format;
    private final boolean escape;
    private final boolean content;
    private final byte[] wUri;
    private final byte[] wPre;
    private final boolean wrap;
    private final int indents;
    private final char tab;
    private final String enc;
    private final String version;
    private final String media;
    private final String mth;
    private final PrintOutput out;
    private String docsys;
    private String docpub;
    private boolean ind;
    private boolean item;
    private boolean script;

    static {
        EMPTIES.add(Token.token("area"));
        EMPTIES.add(Token.token("base"));
        EMPTIES.add(Token.token("br"));
        EMPTIES.add(Token.token("col"));
        EMPTIES.add(Token.token("hr"));
        EMPTIES.add(Token.token("img"));
        EMPTIES.add(Token.token("input"));
        EMPTIES.add(Token.token("link"));
        EMPTIES.add(Token.token("meta"));
        EMPTIES.add(Token.token("basefont"));
        EMPTIES.add(Token.token("frame"));
        EMPTIES.add(Token.token("isindex"));
        EMPTIES.add(Token.token("param"));
        SCRIPTS.add(Token.token("script"));
        SCRIPTS.add(Token.token("style"));
        BOOLEAN.add(Token.token("area:nohref"));
        BOOLEAN.add(Token.token("button:disabled"));
        BOOLEAN.add(Token.token("dir:compact"));
        BOOLEAN.add(Token.token("dl:compact"));
        BOOLEAN.add(Token.token("frame:noresize"));
        BOOLEAN.add(Token.token("hr:noshade"));
        BOOLEAN.add(Token.token("img:ismap"));
        BOOLEAN.add(Token.token("input:checked"));
        BOOLEAN.add(Token.token("input:disabled"));
        BOOLEAN.add(Token.token("input:readonly"));
        BOOLEAN.add(Token.token("menu:compact"));
        BOOLEAN.add(Token.token("object:declare"));
        BOOLEAN.add(Token.token("ol:compact"));
        BOOLEAN.add(Token.token("optgroup:disabled"));
        BOOLEAN.add(Token.token("option:selected"));
        BOOLEAN.add(Token.token("option:disabled"));
        BOOLEAN.add(Token.token("script:defer"));
        BOOLEAN.add(Token.token("select:multiple"));
        BOOLEAN.add(Token.token("select:disabled"));
        BOOLEAN.add(Token.token("td:nowrap"));
        BOOLEAN.add(Token.token("textarea:disabled"));
        BOOLEAN.add(Token.token("textarea:readonly"));
        BOOLEAN.add(Token.token("th:nowrap"));
        BOOLEAN.add(Token.token("ul:compact"));
        URIS.add(Token.token("a:href"));
        URIS.add(Token.token("a:name"));
        URIS.add(Token.token("applet:codebase"));
        URIS.add(Token.token("area:href"));
        URIS.add(Token.token("base:href"));
        URIS.add(Token.token("blockquote:cite"));
        URIS.add(Token.token("body:background"));
        URIS.add(Token.token("button:datasrc"));
        URIS.add(Token.token("del:cite"));
        URIS.add(Token.token("div:datasrc"));
        URIS.add(Token.token("form:action"));
        URIS.add(Token.token("frame:longdesc"));
        URIS.add(Token.token("frame:src"));
        URIS.add(Token.token("head:profile"));
        URIS.add(Token.token("iframe:longdesc"));
        URIS.add(Token.token("iframe:src"));
        URIS.add(Token.token("img:longdesc"));
        URIS.add(Token.token("img:src"));
        URIS.add(Token.token("img:usemap"));
        URIS.add(Token.token("input:datasrc"));
        URIS.add(Token.token("input:src"));
        URIS.add(Token.token("input:usemap"));
        URIS.add(Token.token("ins:cite"));
        URIS.add(Token.token("link:href"));
        URIS.add(Token.token("object:archive"));
        URIS.add(Token.token("object:classid"));
        URIS.add(Token.token("object:codebase"));
        URIS.add(Token.token("object:data"));
        URIS.add(Token.token("object:datasrc"));
        URIS.add(Token.token("object:usemap"));
        URIS.add(Token.token("q:cite"));
        URIS.add(Token.token("script:for"));
        URIS.add(Token.token("script:src"));
        URIS.add(Token.token("select:datasrc"));
        URIS.add(Token.token("span:datasrc"));
        URIS.add(Token.token("table:datasrc"));
        URIS.add(Token.token("textarea:datasrc"));
    }

    public XMLSerializer(OutputStream os) throws IOException {
        this(os, null);
    }

    public XMLSerializer(OutputStream os, SerializerProp props) throws IOException {
        this.out = PrintOutput.get(os);
        SerializerProp p = props == null ? PROPS : props;
        String m = p.check(SerializerProp.S_METHOD, "xml", "xhtml", "html", "text");
        String string = m.equals("xml") ? "xml" : (m.equals("xhtml") ? "xhtml" : (this.mth = m.equals("html") ? "html" : "text"));
        this.version = p.get(SerializerProp.S_VERSION).isEmpty() ? (this.mth == "html" ? "4.0" : "1.0") : (this.mth == "html" ? p.check(SerializerProp.S_VERSION, "4.0", "4.01") : (this.mth != "text" ? p.check(SerializerProp.S_VERSION, "1.0", "1.1") : p.get(SerializerProp.S_VERSION)));
        String cdse = p.get(SerializerProp.S_CDATA_SECTION_ELEMENTS);
        if (!cdse.isEmpty()) {
            String[] stringArray = cdse.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                if (!c.isEmpty()) {
                    this.cdata.add(Token.token(c));
                }
                ++n2;
            }
        }
        boolean decl = p.check(SerializerProp.S_OMIT_XML_DECLARATION, "yes", "no").equals("no");
        boolean bom = p.check(SerializerProp.S_BYTE_ORDER_MARK, "yes", "no").equals("yes");
        String sa = p.check(SerializerProp.S_STANDALONE, "yes", "no", "omit");
        p.check(SerializerProp.S_NORMALIZATION_FORM, "NFC", "none");
        String maps = p.get(SerializerProp.S_USE_CHARACTER_MAPS);
        if (!maps.isEmpty()) {
            Err.SERMAP.thrwSerial(maps);
        }
        this.enc = Token.normEncoding(p.get(SerializerProp.S_ENCODING), null);
        this.docsys = p.get(SerializerProp.S_DOCTYPE_SYSTEM);
        this.docpub = p.get(SerializerProp.S_DOCTYPE_PUBLIC);
        this.media = p.get(SerializerProp.S_MEDIA_TYPE);
        this.format = p.check(SerializerProp.S_FORMAT, "yes", "no").equals("yes");
        this.indent = p.check(SerializerProp.S_INDENT, "yes", "no").equals("yes") && this.format;
        this.undecl = p.check(SerializerProp.S_UNDECLARE_PREFIXES, "yes", "no").equals("yes");
        this.escape = p.check(SerializerProp.S_ESCAPE_URI_ATTRIBUTES, "yes", "no").equals("yes");
        this.content = p.check(SerializerProp.S_INCLUDE_CONTENT_TYPE, "yes", "no").equals("yes");
        this.indents = Math.max(0, Token.toInt(p.get(SerializerProp.S_INDENTS)));
        this.tab = (char)(p.check(SerializerProp.S_TABULATOR, "yes", "no").equals("yes") ? 9 : 32);
        this.wPre = Token.token(p.get(SerializerProp.S_WRAP_PREFIX));
        this.wUri = Token.token(p.get(SerializerProp.S_WRAP_URI));
        boolean bl = this.wrap = this.wPre.length != 0;
        if (this.docsys.isEmpty()) {
            this.docsys = null;
            this.docpub = null;
        } else if (this.docpub.isEmpty()) {
            this.docpub = null;
        }
        if (!Token.supported(this.enc)) {
            Err.SERENCODING.thrwSerial(this.enc);
        }
        if (this.undecl && this.version.equals("1.0")) {
            Err.SERUNDECL.thrwSerial(new Object[0]);
        }
        if (bom) {
            if (this.enc == "UTF-8") {
                this.out.write(239);
                this.out.write(187);
                this.out.write(191);
            } else if (this.enc == "UTF-16LE") {
                this.out.write(255);
                this.out.write(254);
            } else if (this.enc == "UTF-16BE") {
                this.out.write(254);
                this.out.write(255);
            }
        }
        if (this.mth != "html" && this.mth != "text") {
            if (decl) {
                this.print(DataText.PI1);
                this.print("xml version=\"");
                this.print(this.version);
                this.print("\" encoding=\"");
                this.print(p.get(SerializerProp.S_ENCODING));
                if (!sa.equals("omit")) {
                    this.print("\" standalone=\"");
                    this.print(sa);
                }
                this.print(DataText.ATT2);
                this.print(DataText.PI2);
                this.ind = this.indent;
            } else if (!sa.equals("omit") || this.version.equals("1.1") && this.docsys != null) {
                Err.SERSTAND.thrwSerial(new Object[0]);
            }
        }
        if (this.wrap) {
            this.openElement(this.wPre.length != 0 ? Token.concat(this.wPre, Token.COLON, DataText.RESULTS) : DataText.RESULTS, (byte[][])new byte[0][]);
            this.namespace(this.wPre, this.wUri);
            this.finishElement();
        }
    }

    public void init() {
        this.ind = false;
        this.item = false;
    }

    @Override
    public void cls() throws IOException {
        if (this.wrap) {
            this.closeElement();
        }
        this.out.flush();
    }

    @Override
    public void openResult() throws IOException {
        if (this.wrap) {
            this.openElement(this.wPre.length != 0 ? Token.concat(this.wPre, Token.COLON, DataText.RESULT) : DataText.RESULT, (byte[][])new byte[0][]);
            this.ind = false;
        }
    }

    @Override
    public void closeResult() throws IOException {
        if (this.wrap) {
            this.closeElement();
        }
    }

    @Override
    public void attribute(byte[] n, byte[] v) throws IOException {
        byte[] tagatt;
        if (this.mth == "text") {
            return;
        }
        this.print(32);
        this.print(n);
        byte[] byArray = tagatt = this.mth == "xml" || this.tags.size() == 0 ? Token.EMPTY : Token.concat(Token.lc(this.tags.get(this.tags.size() - 1)), Token.COLON, Token.lc(n));
        if (this.mth == "html" && BOOLEAN.id(tagatt) != 0) {
            return;
        }
        byte[] val = this.escape && (this.mth == "html" || this.mth == "xhtml") && URIS.id(tagatt) != 0 ? Token.escape(v) : v;
        this.print(DataText.ATT1);
        int k = 0;
        while (k < val.length) {
            int ch = Token.cp(val, k);
            if (!this.format || this.mth == "html" && (ch == 60 || ch == 38 && val[Math.min(k + 1, val.length - 1)] == 123)) {
                this.print(ch);
            } else {
                switch (ch) {
                    case 34: {
                        this.print(DataText.E_QU);
                        break;
                    }
                    case 9: 
                    case 10: {
                        this.hex(ch);
                        break;
                    }
                    default: {
                        this.ch(ch);
                    }
                }
            }
            k += Token.cl(val, k);
        }
        this.print(DataText.ATT2);
    }

    @Override
    public void text(byte[] b) throws IOException {
        this.finishElement();
        if (this.cdata.size() != 0 && this.cdata.contains(this.tags.get(this.tags.size() - 1)) && this.mth != "html" && this.mth != "text") {
            this.print(DataText.CDATA1);
            int c = 0;
            int k = 0;
            while (k < b.length) {
                int ch = Token.cp(b, k);
                if (ch == 93) {
                    ++c;
                } else {
                    if (c > 1 && ch == 62) {
                        this.print(DataText.CDATA2);
                        this.print(DataText.CDATA1);
                    }
                    c = 0;
                }
                this.print(ch);
                k += Token.cl(b, k);
            }
            this.print(DataText.CDATA2);
        } else {
            int k = 0;
            while (k < b.length) {
                this.ch(Token.cp(b, k));
                k += Token.cl(b, k);
            }
        }
        this.ind = false;
    }

    @Override
    public void text(byte[] b, FTPos ftp) throws IOException {
        this.finishElement();
        FTLexer lex = new FTLexer().sc().init(b);
        while (lex.hasNext()) {
            FTSpan span = lex.next();
            if (!span.special && ftp.contains(span.pos)) {
                this.print(4);
            }
            byte[] t = span.text;
            int k = 0;
            while (k < t.length) {
                this.ch(Token.cp(t, k));
                k += Token.cl(t, k);
            }
        }
        this.ind = false;
    }

    @Override
    public void comment(byte[] n) throws IOException {
        if (this.mth == "text") {
            return;
        }
        this.finishElement();
        if (this.ind) {
            this.indent(true);
        }
        this.print(DataText.COM1);
        this.print(n);
        this.print(DataText.COM2);
    }

    @Override
    public void pi(byte[] n, byte[] v) throws IOException {
        if (this.mth == "text") {
            return;
        }
        this.finishElement();
        if (this.ind) {
            this.indent(true);
        }
        if (this.mth == "html" && Token.contains(v, 62)) {
            Err.SERPI.thrwSerial(new Object[0]);
        }
        this.print(DataText.PI1);
        this.print(n);
        this.print(32);
        this.print(v);
        this.print(this.mth == "html" ? DataText.ELEM2 : DataText.PI2);
    }

    @Override
    public void item(byte[] b) throws IOException {
        this.finishElement();
        if (this.ind) {
            this.print(32);
        }
        int k = 0;
        while (k < b.length) {
            this.ch(Token.cp(b, k));
            k += Token.cl(b, k);
        }
        this.ind = this.format;
        this.item = true;
    }

    private void ch(int ch) throws IOException {
        if (this.mth == "html") {
            if (this.script) {
                this.print(ch);
                return;
            }
            if (ch < 32 && ch != 9 && ch != 10 && ch != 13) {
                return;
            }
            if (ch > 127 && ch < 160) {
                Err.SERILL.thrwSerial(Integer.toHexString(ch));
            }
            if (ch == 160) {
                this.print(DataText.E_NBSP);
                return;
            }
        }
        if (!this.format) {
            this.print(ch);
        } else if (ch < 32 && ch != 9 && ch != 10 || ch > 127 && ch < 160) {
            this.hex(ch);
        } else {
            switch (ch) {
                case 38: {
                    this.print(DataText.E_AMP);
                    break;
                }
                case 62: {
                    this.print(DataText.E_GT);
                    break;
                }
                case 60: {
                    this.print(DataText.E_LT);
                    break;
                }
                default: {
                    this.print(ch);
                }
            }
        }
    }

    @Override
    public boolean finished() {
        return this.out.finished();
    }

    @Override
    protected void start(byte[] t) throws IOException {
        if (this.mth == "text") {
            return;
        }
        if (this.tags.size() == 1 && this.docsys != null) {
            if (this.ind) {
                this.indent(false);
            }
            this.print("<!DOCTYPE ");
            if (this.mth == "html") {
                this.print("html");
            } else {
                this.print(t);
            }
            if (this.docpub != null) {
                this.print(" PUBLIC \"" + this.docpub + "\"");
            } else {
                this.print(" SYSTEM");
            }
            this.print(" \"" + this.docsys + "\"");
            this.print(DataText.ELEM2);
            this.print(NL);
            this.docsys = null;
        }
        if (this.ind) {
            this.indent(false);
        }
        this.print(DataText.ELEM1);
        this.print(t);
        this.ind = this.indent;
        if (this.mth == "html") {
            this.script = SCRIPTS.contains(Token.lc(t));
        }
        if (this.content && (this.mth == "html" || this.mth == "xhtml") && Token.eq(Token.lc(t), DataText.HEAD)) {
            this.emptyElement(DataText.META, (byte[][])new byte[][]{DataText.HTTPEQUIV, DataText.CONTTYPE, DataText.CONTENT, Token.concat(Token.token(this.media), DataText.CHARSET, Token.token(this.enc))});
        }
    }

    @Override
    protected void empty() throws IOException {
        if (this.mth == "text") {
            return;
        }
        if (this.mth == "xml") {
            this.print(DataText.ELEM4);
        } else {
            byte[] tag = this.tags.get(this.tags.size());
            boolean empty = EMPTIES.contains(Token.lc(tag));
            if (this.mth == "xhtml" && empty) {
                this.print(32);
                this.print(DataText.ELEM4);
            } else {
                this.print(DataText.ELEM2);
                if (this.mth == "html" && empty) {
                    return;
                }
                this.ind = false;
                this.close(tag);
            }
        }
    }

    @Override
    protected void finish() throws IOException {
        if (this.mth != "text") {
            this.print(DataText.ELEM2);
        }
    }

    @Override
    protected void close(byte[] t) throws IOException {
        if (this.mth == "text") {
            return;
        }
        if (this.ind) {
            this.indent(true);
        }
        this.print(DataText.ELEM3);
        this.print(t);
        this.print(DataText.ELEM2);
        this.ind = this.indent;
        if (this.mth == "html") {
            this.script &= !SCRIPTS.contains(Token.lc(t));
        }
    }

    private void indent(boolean close) throws IOException {
        if (this.item) {
            this.item = false;
        } else {
            this.print(NL);
            int ls = (this.level() - (close ? 0 : 1)) * this.indents;
            int l = 0;
            while (l < ls) {
                this.print(this.tab);
                ++l;
            }
        }
    }

    private void hex(int ch) throws IOException {
        this.print("&#x");
        this.print(Token.HEX[ch >> 4]);
        this.print(Token.HEX[ch & 0xF]);
        this.print(59);
    }

    private void print(byte[] token) throws IOException {
        if (this.enc == "UTF-8") {
            byte[] byArray = token;
            int n = token.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                this.out.write(b);
                ++n2;
            }
        } else {
            this.print(Token.string(token));
        }
    }

    private void print(int ch) throws IOException {
        if (this.enc == "UTF-8") {
            if (ch <= 127) {
                this.out.write(ch);
            } else if (ch <= 2047) {
                this.out.write(ch >> 6 & 0x1F | 0xC0);
                this.out.write(ch >> 0 & 0x3F | 0x80);
            } else if (ch <= 65535) {
                this.out.write(ch >> 12 & 0xF | 0xE0);
                this.out.write(ch >> 6 & 0x3F | 0x80);
                this.out.write(ch >> 0 & 0x3F | 0x80);
            } else {
                this.out.write(ch >> 18 & 7 | 0xF0);
                this.out.write(ch >> 12 & 0x3F | 0x80);
                this.out.write(ch >> 6 & 0x3F | 0x80);
                this.out.write(ch >> 0 & 0x3F | 0x80);
            }
        } else {
            this.print(new TokenBuilder(4).add(ch).toString());
        }
    }

    private void print(String s) throws IOException {
        if (this.enc == "UTF-8") {
            this.print(Token.token(s));
        } else if (this.enc == "UTF-16BE" || this.enc == "UTF-16LE") {
            boolean l = this.enc == "UTF-16LE";
            int i = 0;
            while (i < s.length()) {
                char ch = s.charAt(i);
                this.out.write(l ? ch & 0xFF : ch >>> 8);
                this.out.write(l ? ch >>> 8 : ch & 0xFF);
                ++i;
            }
        } else {
            this.out.write(s.getBytes(this.enc));
        }
    }
}

