/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import org.basex.data.DataText;
import org.basex.data.FTPos;
import org.basex.data.Result;
import org.basex.io.serial.Serializer;
import org.basex.util.Token;
import org.basex.util.Util;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXSerializer
extends Serializer
implements XMLReader {
    private ContentHandler content;
    private LexicalHandler lexical;
    private final Result result;
    private String tag;
    private AttributesImpl atts;

    public SAXSerializer(Result res) {
        this.result = res;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.content;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        this.parse("");
    }

    @Override
    public void parse(String id) throws SAXException {
        try {
            this.content.startDocument();
            this.result.serialize(this);
            this.content.endDocument();
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void setContentHandler(ContentHandler c) {
        this.content = c;
    }

    public void setLexicalHandler(LexicalHandler l) {
        this.lexical = l;
    }

    @Override
    public void setDTDHandler(DTDHandler h) {
        Util.notimplemented(new Object[0]);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        Util.notimplemented(new Object[0]);
    }

    @Override
    public void setErrorHandler(ErrorHandler h) {
        Util.notimplemented(new Object[0]);
    }

    @Override
    public void setFeature(String name, boolean value) {
        Util.notimplemented(new Object[0]);
    }

    @Override
    public void setProperty(String name, Object value) {
        Util.notimplemented(new Object[0]);
    }

    @Override
    public void openResult() throws IOException {
        this.openElement(DataText.RESULT, (byte[][])new byte[0][]);
    }

    @Override
    public void closeResult() throws IOException {
        this.closeElement();
    }

    @Override
    public void attribute(byte[] n, byte[] v) {
        String an = Token.string(n);
        this.atts.addAttribute("", an, an, "", Token.string(v));
    }

    @Override
    protected void start(byte[] t) {
        this.tag = Token.string(t);
        this.atts = new AttributesImpl();
    }

    @Override
    protected void empty() throws IOException {
        this.finish();
        try {
            this.content.endElement("", this.tag, this.tag);
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    protected void finish() throws IOException {
        try {
            this.content.startElement("", this.tag, this.tag, this.atts);
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    protected void close(byte[] t) throws IOException {
        try {
            this.tag = Token.string(t);
            this.content.endElement("", this.tag, this.tag);
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    protected void cls() {
    }

    @Override
    public void text(byte[] b) throws IOException {
        this.finishElement();
        char[] c = Token.string(b).toCharArray();
        try {
            this.content.characters(c, 0, c.length);
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void text(byte[] b, FTPos ftp) throws IOException {
        this.text(b);
    }

    @Override
    public void comment(byte[] t) throws IOException {
        this.finishElement();
        try {
            char[] c = Token.string(t).toCharArray();
            if (this.lexical != null) {
                this.lexical.comment(c, 0, t.length);
            }
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void pi(byte[] n, byte[] v) throws IOException {
        this.finishElement();
        try {
            this.content.processingInstruction(Token.string(n), Token.string(v));
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void item(byte[] b) throws IOException {
        this.finishElement();
        throw new IOException("Can't serialize atomic items.");
    }
}

