/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.io.IOException;
import org.basex.data.MetaData;

public abstract class TableAccess {
    protected final MetaData meta;
    protected boolean dirty;

    protected TableAccess(MetaData md) {
        this.meta = md;
    }

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;

    public abstract int read1(int var1, int var2);

    public abstract int read2(int var1, int var2);

    public abstract int read4(int var1, int var2);

    public abstract long read5(int var1, int var2);

    public abstract void write1(int var1, int var2, int var3);

    public abstract void write2(int var1, int var2, int var3);

    public abstract void write4(int var1, int var2, int var3);

    public abstract void write5(int var1, int var2, long var3);

    public final void replace(int pre, byte[] entries, int sub) {
        this.dirty = true;
        int nsize = entries.length >>> 4;
        int diff = sub - nsize;
        int last = diff <= 0 ? pre + nsize - Math.abs(diff) : pre + nsize;
        this.copy(entries, pre, last);
        int off = last - pre << 4;
        if (diff < 0) {
            byte[] tmp = new byte[entries.length - off];
            System.arraycopy(entries, off, tmp, 0, tmp.length);
            this.insert(last, tmp);
        } else if (diff > 0) {
            this.delete(last, diff);
        }
    }

    public final void set(int pre, byte[] entries) {
        this.dirty = true;
        this.copy(entries, pre, pre + (entries.length >>> 4));
    }

    protected abstract void copy(byte[] var1, int var2, int var3);

    public abstract void delete(int var1, int var2);

    public abstract void insert(int var1, byte[] var2);
}

