/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.Num;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;

final class FTTrieHash
extends TokenSet {
    byte[][] pre = new byte[8][];
    byte[][] pos = new byte[8][];
    int[] sizes = new int[8];
    private IntList il;
    private int it;

    FTTrieHash() {
    }

    void index(byte[] key, int pr, int po) {
        int id = this.add(key);
        if (id < 0) {
            id = -id;
            this.pre[id] = Num.add(this.pre[id], pr);
            this.pos[id] = Num.add(this.pos[id], po);
            int n = id;
            this.sizes[n] = this.sizes[n] + 1;
        } else {
            this.pre[id] = Num.newNum(pr);
            this.pos[id] = Num.newNum(po);
            this.sizes[id] = 1;
        }
    }

    @Override
    protected void rehash() {
        super.rehash();
        int s = this.size << 1;
        this.pre = Array.copyOf(this.pre, s);
        this.pos = Array.copyOf(this.pos, s);
        this.sizes = Arrays.copyOf(this.sizes, s);
    }

    void init() {
        int[] ids = new int[this.size];
        int i = 0;
        while (i < this.size) {
            ids[i] = i;
            ++i;
        }
        this.il = new IntList(ids);
        this.il.sort(this.keys, false, true);
        this.it = 0;
    }

    void initIter() {
        this.it = 0;
    }

    boolean more() {
        return ++this.it < this.size;
    }

    byte[] key() {
        return this.keys[this.it];
    }

    int next() {
        return this.il.get(this.it);
    }
}

