/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.tree;

import org.basex.data.Data;
import org.basex.gui.view.tree.ChildIterator;
import org.basex.gui.view.tree.TreeBorder;
import org.basex.gui.view.tree.TreeConstants;
import org.basex.util.list.IntList;
import org.basex.util.list.ObjList;

final class TreeNodeCache
implements TreeConstants {
    private int maxLevel;
    private final IntList[] nodes;

    TreeNodeCache(Data data, boolean atts) {
        ObjList<IntList> alil = new ObjList<IntList>();
        int ts = data.meta.size;
        IntList roots = data.doc();
        alil.add(new IntList());
        int i = 0;
        int is = roots.size();
        while (i < is) {
            int root = roots.get(i);
            ((IntList)alil.get(0)).add(root);
            int sh = i + 1 == roots.size() ? ts : roots.get(i + 1);
            int p = root + 1;
            while (p < sh) {
                int k = data.kind(p);
                if (atts || k != 3) {
                    int lv = 0;
                    int par = data.parent(p, k);
                    while (par != ((IntList)alil.get(lv)).get(((IntList)alil.get(lv)).size() - 1)) {
                        ++lv;
                    }
                    int j = alil.size();
                    while (j <= lv + 1) {
                        alil.add(new IntList());
                        ++j;
                    }
                    ((IntList)alil.get(lv + 1)).add(p);
                }
                ++p;
            }
            ++i;
        }
        this.maxLevel = alil.size();
        this.nodes = alil.toArray(new IntList[alil.size()]);
    }

    private IntList getNextNodeLine(IntList parentList, Data data) {
        int l = parentList.size();
        IntList line = new IntList();
        int i = 0;
        while (i < l) {
            int p = parentList.get(i);
            ChildIterator iter = new ChildIterator(data, p);
            while (iter.more()) {
                int pre = iter.next();
                data.kind(pre);
                line.add(pre);
            }
            ++i;
        }
        return line;
    }

    private int getMinIndex(int lv, int lp, int rp) {
        boolean l = false;
        int r = this.nodes[lv].size() - 1;
        int min = this.searchPreIndex(lv, lp, rp, 0, r);
        if (min == -1) {
            return min;
        }
        int[] n = this.nodes[lv].toArray();
        while (min-- > 0 && n[min] > lp) {
        }
        return min + 1;
    }

    TreeBorder[] subtree(Data d, int pre) {
        TreeBorder[] bo = new TreeBorder[this.maxLevel];
        if (pre == 0 && d.meta.ndocs == 1) {
            int i = 0;
            while (i < this.maxLevel) {
                bo[i] = new TreeBorder(i, 0, this.nodes[i].size());
                ++i;
            }
            return bo;
        }
        int[] rlp = this.findPre(pre);
        int rl = rlp[0];
        int ri = rlp[1];
        bo[rl] = new TreeBorder(rl, ri, 1);
        int np = pre + d.size(pre, d.kind(pre));
        int h = 1;
        int i = rl + 1;
        while (i < this.maxLevel) {
            int min = this.getMinIndex(i, pre, np);
            if (min == -1) break;
            int c = 0;
            int j = min;
            while (j < this.nodes[i].size()) {
                if (this.nodes[i].get(j) >= np) break;
                ++c;
                ++j;
            }
            bo[i] = new TreeBorder(i, min, c);
            ++h;
            ++i;
        }
        TreeBorder[] bon = new TreeBorder[h];
        System.arraycopy(bo, rl, bon, 0, h);
        return bon;
    }

    private int[] findPre(int pre) {
        int[] nArray;
        int pos = -1;
        int l = 0;
        while (l < this.maxLevel) {
            pos = this.searchPreArrayPos(l, 0, this.nodes[l].size() - 1, pre);
            if (pos > -1) break;
            ++l;
        }
        if (pos > -1) {
            int[] nArray2 = new int[2];
            nArray2[0] = l;
            nArray = nArray2;
            nArray2[1] = pos;
        } else {
            nArray = null;
        }
        return nArray;
    }

    int searchPreArrayPos(int lv, int l, int r, int pre) {
        return this.searchPreIndex(lv, pre, pre, l, r);
    }

    int searchPreIndex(int lv, int lb, int rb, int l, int r) {
        int index = -1;
        int ll = l;
        int rr = r;
        while (rr >= ll && index == -1) {
            int m = ll + (rr - ll) / 2;
            if (this.nodes[lv].get(m) < lb) {
                ll = m + 1;
                continue;
            }
            if (this.nodes[lv].get(m) > rb) {
                rr = m - 1;
                continue;
            }
            index = m;
        }
        return index;
    }

    int getPrePerLevelAndIndex(int lv, int i) {
        return this.nodes[lv].get(i);
    }
}

